/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.callDispositionLead.controller;

import com.coraltele.db.coralapps.callcenter.entity.view.CallDispositionLeadView;
import com.coraltele.db.coralapps.callcenter.repository.CallDispositionLeadRepository;
import com.coraltele.db.coralapps.callcenter.specification.CallDispositionLeadSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.coralApps.callcenter.callDispositionLead.service.CallDispositionLeadService;
import com.coraltele.service.coralApps.callcenter.dynamicPopUpData.model.InboundOutboundCallModel;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.user.service.UserService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/callDispositionLead"})
public class CallDispositionLeadController {
    private static final Logger logger = LogManager.getLogger(CallDispositionLeadController.class);
    @Autowired
    CallDispositionLeadService callDispositionLeadService;
    @Autowired
    CallDispositionLeadRepository callDispositionLeadRepository;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadService;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllDispositionLead(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.callDispositionLeadService.getAllCallDispositionData(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for callDisposition--");
            boolean teamLeaderUser = false;
            if (this.userService.checkRoleTL(principal.getName())) {
                teamLeaderUser = true;
            }
            List queueId = null;
            if (teamLeaderUser) {
                queueId = this.queueTLService.getQueueListByTeamLeaderInt(principal.getName());
            }
            Specification filters = CallDispositionLeadSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, queueId);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.callDispositionLeadRepository.findAll(filters, sort) : this.callDispositionLeadRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (CallDispositionLeadView item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for callDisposition", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading callDisposition CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(CallDispositionLeadView item, String columnName) {
        switch (columnName) {
            case "accountNumber": {
                return this.checkNull((Object)item.getAccountNumber());
            }
            case "agentId": {
                return this.checkNull((Object)item.getAgentId());
            }
            case "agentName": {
                return this.checkNull((Object)item.getAgentName());
            }
            case "campaign": {
                return this.checkNull((Object)item.getCampaign());
            }
            case "customerName": {
                return this.checkNull((Object)item.getCustomerName());
            }
            case "disposition": {
                return this.checkNull((Object)item.getDisposition());
            }
            case "dispositionId": {
                return this.checkNull((Object)item.getDispositionId());
            }
            case "emailId": {
                return this.checkNull((Object)item.getEmailId());
            }
            case "phoneNumber": {
                return this.checkNull((Object)item.getPhoneNumber());
            }
            case "queueId": {
                return this.checkNull((Object)item.getQueueId());
            }
            case "recordType": {
                return this.checkNull((Object)item.getRecordType());
            }
            case "remarks": {
                return this.checkNull((Object)item.getRemarks());
            }
            case "createdOn": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatter((LocalDateTime)item.getCreatedOn()));
            }
            case "dispositionTime": {
                return this.checkNull((Object)DateFormatUtility.dateAndTimeFormatter((LocalDateTime)item.getDispositionTime()));
            }
        }
        return null;
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/fields"})
    public ResponseEntity<RequestResponse> getModelFields() {
        RequestResponse returnValue = this.callDispositionLeadService.printModelFields(InboundOutboundCallModel.class);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    static {
        columnMappings.put("accountNumber", "Account Number");
        columnMappings.put("agentId", "AgentId");
        columnMappings.put("agentName", "Agent Name");
        columnMappings.put("campaign", "Campaign");
        columnMappings.put("customerName", "Customer Name");
        columnMappings.put("disposition", "Disposition");
        columnMappings.put("dispositionId", "DispositionId");
        columnMappings.put("emailId", "EmailId");
        columnMappings.put("phoneNumber", "PhoneNumber");
        columnMappings.put("queueId", "QueueId");
        columnMappings.put("recordType", "Record Type");
        columnMappings.put("remarks", "Remarks");
        columnMappings.put("createdOn", "CreatedOn");
        columnMappings.put("dispositionTime", "Disposition Time");
    }
}

