/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.ClassPathResource;

/*
 * Exception performing whole class analysis ignored.
 */
public class PublishPRI {
    private static final Logger logger = LogManager.getLogger(PublishPRI.class);

    public static int publishAkomPri(String cardName, String ipAddress, String state) throws IOException {
        logger.info("Pri Config Started");
        int returnValue = 0;
        String priMode = state.equals("MASTER") ? "pri-net" : "pri-cpe";
        if (cardName.trim().isEmpty() || ipAddress.trim().isEmpty() || state.trim().isEmpty()) {
            returnValue = 1;
        } else if (cardName.equals("AKOM")) {
            logger.info("PRI Config Found For Card: " + cardName);
            logger.info("Start Populating File for " + cardName + "Pri Card");
            PublishPRI.populateFile((String)"asterisk/sip.conf", (String)"/etc/asterisk/sip.conf", (String)ipAddress, (String)priMode);
            PublishPRI.populateFile((String)"asterisk/extensions.conf", (String)"/etc/asterisk/extensions.conf", (String)ipAddress, (String)priMode);
            PublishPRI.populateFile((String)"asterisk/dahdi-channels.conf", (String)"/etc/asterisk/dahdi-channels.conf", (String)ipAddress, (String)priMode);
            logger.info("File for " + cardName + "Pri Card Populated");
            logger.info("Start configuration for " + cardName + "Pri Card");
            logger.info("Configuration for " + cardName + "Pri Card Done");
        }
        return returnValue;
    }

    static void populateFile(String srcFile, String dstFile, String ipAddress, String state) throws IOException {
        FileWriter fileWriter = new FileWriter(dstFile);
        try (BufferedWriter out = new BufferedWriter(fileWriter);){
            ClassPathResource resourceTemplate = new ClassPathResource(srcFile);
            InputStream initialStream = resourceTemplate.getInputStream();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)initialStream, (Writer)writer, (Charset)Charset.defaultCharset());
            String writeContent = writer.toString();
            writeContent = writeContent.replace("$$IP", ipAddress);
            writeContent = writeContent.replace("$$PRI_MODE", state);
            out.write(writeContent);
            logger.info("File {} populated", (Object)dstFile);
        }
        catch (Exception E) {
            logger.info("Error while writing {1} File", (Object)dstFile, (Object)E);
        }
    }
}

