/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Document;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PdfPageNumberEvent
extends PdfPageEventHelper {
    @Autowired
    PdfReportRepository pdfReportRepository;
    private Image logo;
    private String reportFileName;
    private LocalDateTime currentTime;
    private static String localDateFormat = "dd-MM-yyyy hh:mm:ss a";
    String localDateString = LocalDateTime.now().format(DateTimeFormatter.ofPattern(localDateFormat));
    private static Font COURIER_SMALL = new Font(Font.FontFamily.COURIER, 12.0f, 1);

    public void initialize(String logoImgPath, String reportFileName, String localDateFormat, LocalDateTime currentTime) throws BadElementException, IOException {
        this.logo = Image.getInstance((String)logoImgPath);
        this.logo.scalePercent(50.0f, 50.0f);
        this.reportFileName = reportFileName;
        this.currentTime = currentTime;
    }

    public void onEndPage(PdfWriter writer, Document document) {
        PdfContentByte canvas = writer.getDirectContent();
        Rectangle pageSize = document.getPageSize();
        int page = writer.getPageNumber();
        ColumnText.showTextAligned((PdfContentByte)canvas, (int)1, (Phrase)new Phrase("Page " + page), (float)pageSize.getRight(40.0f), (float)pageSize.getBottom(20.0f), (float)0.0f);
        if (writer.getPageNumber() > 1) {
            String reportName = this.reportFileName;
            ColumnText.showTextAligned((PdfContentByte)canvas, (int)0, (Phrase)new Phrase(reportName, COURIER_SMALL), (float)pageSize.getLeft(40.0f), (float)pageSize.getTop(20.0f), (float)0.0f);
            ColumnText.showTextAligned((PdfContentByte)canvas, (int)2, (Phrase)new Phrase("Generated On:" + this.currentTime.format(DateTimeFormatter.ofPattern(localDateFormat)), COURIER_SMALL), (float)pageSize.getRight(40.0f), (float)pageSize.getTop(20.0f), (float)0.0f);
        }
    }
}

