/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class Bootstrap {
    private static final Logger logger = LogManager.getLogger(Bootstrap.class);
    private static String testVersion = "2.4";

    private Bootstrap() {
    }

    public static void checkTelemetryDatabase() {
        DriverManagerDataSource dsSwitch = new DriverManagerDataSource();
        dsSwitch.setDriverClassName("org.postgresql.Driver");
        dsSwitch.setUrl("jdbc:postgresql://127.0.0.1:5432/postgres");
        dsSwitch.setUsername("postgres");
        dsSwitch.setPassword("");
        JdbcTemplate jdbcConnection = new JdbcTemplate((DataSource)dsSwitch);
        Integer count = (Integer)jdbcConnection.queryForObject("SELECT count(*) as cnt FROM pg_database WHERE datname = 'telemetry'", Integer.class);
        if (count == null || count == 0) {
            jdbcConnection.update("CREATE DATABASE telemetry");
            Bootstrap.createCoralNMSSchema();
        }
    }

    public static void createCoralNMSSchema() {
        DriverManagerDataSource dsSwitch = new DriverManagerDataSource();
        dsSwitch.setDriverClassName("org.postgresql.Driver");
        dsSwitch.setUrl("jdbc:postgresql://127.0.0.1:5432/telemetry");
        dsSwitch.setUsername("postgres");
        dsSwitch.setPassword("");
        JdbcTemplate jdbcConnection = new JdbcTemplate((DataSource)dsSwitch);
        jdbcConnection.update("CREATE SCHEMA coralnms");
    }

    public static void updateBillingSchema(ApplicationContext context, String subFolder) {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName("org.postgresql.Driver");
        dataSource.setUrl("jdbc:postgresql://127.0.0.1:5432/billing");
        dataSource.setUsername("postgres");
        dataSource.setPassword("");
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        try {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            Resource[] resources = resolver.getResources("classpath:schema/billing/" + subFolder + "/*.sql");
            Arrays.sort(resources, Comparator.comparing(Resource::getFilename));
            for (Resource resource : resources) {
                logger.info("Processing file: billing/{}/{}", (Object)subFolder, (Object)resource.getFilename());
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream()));){
                    String sqlScript = reader.lines().filter(line -> !line.trim().startsWith("--")).collect(Collectors.joining("\n"));
                    if (sqlScript.trim().isEmpty()) continue;
                    jdbcTemplate.execute(sqlScript);
                    logger.info("Executed: {}", (Object)resource.getFilename());
                }
                catch (Exception e) {
                    logger.error("Error at file: billing/{}/{}", (Object)subFolder, (Object)resource.getFilename());
                    logger.error("Error while executing billing schema scripts: ", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while executing billing schema scripts: ", (Throwable)e);
        }
    }

    public static void updateUsersSchema(ApplicationContext context, String subFolder) {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName("org.postgresql.Driver");
        dataSource.setUrl("jdbc:postgresql://127.0.0.1:5432/users");
        dataSource.setUsername("postgres");
        dataSource.setPassword("");
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        try {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            Resource[] resources = resolver.getResources("classpath:schema/users/" + subFolder + "/*.sql");
            Arrays.sort(resources, Comparator.comparing(Resource::getFilename));
            for (Resource resource : resources) {
                logger.info("Processing file: users/{}/{}", (Object)subFolder, (Object)resource.getFilename());
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream()));){
                    String sqlScript = reader.lines().filter(line -> !line.trim().startsWith("--")).collect(Collectors.joining("\n"));
                    if (sqlScript.trim().isEmpty()) continue;
                    jdbcTemplate.execute(sqlScript);
                    logger.info("Executed: {}", (Object)resource.getFilename());
                }
                catch (Exception e) {
                    logger.error("Error at file: users/{}/{}", (Object)subFolder, (Object)resource.getFilename());
                    logger.error("Error while executing users schema scripts: ", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while executing billing users scripts: ", (Throwable)e);
        }
    }

    public static void createPostgresExtension() {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName("org.postgresql.Driver");
        dataSource.setUrl("jdbc:postgresql://127.0.0.1:5432/switch");
        dataSource.setUsername("postgres");
        dataSource.setPassword("Pgadmin@123");
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        try {
            String extensionName = "pgcrypto";
            String sql = "CREATE EXTENSION IF NOT EXISTS \"" + extensionName + "\";";
            jdbcTemplate.execute(sql);
            logger.info("Extension '{}' created successfully (if not existed already)", (Object)extensionName);
        }
        catch (Exception e) {
            logger.error("Error while creating extension : ", (Throwable)e);
        }
    }

    public static void testVersion() {
        logger.info("<<<<<<<<<<<<<<<<<<<<<<<< Test-Version : {} >>>>>>>>>>>>>>>>>>>>>>>>", (Object)testVersion);
        Bootstrap.executeCommand((String)"mkdir -p /mnt/backupfiles");
        Bootstrap.executeCommand((String)"mkdir -p /etc/coraltele/forms/");
        Bootstrap.executeCommand((String)"cp /etc/coraltele/dashboards/dial.json /etc/coraltele/forms/");
    }

    private static void executeCommand(String command) {
        StringBuilder output;
        block6: {
            output = new StringBuilder("created");
            try {
                String line;
                ProcessBuilder pb = new ProcessBuilder("bash", "-c", command);
                pb.redirectErrorStream(true);
                Process process = pb.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    output.append(line).append("\n");
                }
                try {
                    int exitCode = process.waitFor();
                    if (exitCode == 0) {
                        logger.info("Command executed successfully: " + command);
                        break block6;
                    }
                    logger.info("Command execution failed with exit code: " + exitCode);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        logger.info("status of command execution: {}", (Object)output.toString());
    }

    public static void deployFiles() {
        try {
            Resource[] resources;
            File destDir = new File("/etc/coraltele");
            String resourceBasePath = "local-files";
            logger.info("Deploying local files to {}", (Object)destDir.getAbsolutePath());
            if (!destDir.exists()) {
                destDir.mkdirs();
            }
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            for (Resource resource : resources = resolver.getResources("classpath*:" + resourceBasePath + "/**")) {
                File targetFile;
                File parentDir;
                String decodedPath;
                int baseIndex;
                if (!resource.exists() || !resource.isReadable() || resource.getFilename().endsWith("/") || (baseIndex = (decodedPath = URLDecoder.decode(resource.getURL().getPath(), "UTF-8")).indexOf(resourceBasePath)) < 0) continue;
                String relativePath = decodedPath.substring(baseIndex + resourceBasePath.length());
                if (relativePath.startsWith("/") || relativePath.startsWith("\\")) {
                    relativePath = relativePath.substring(1);
                }
                if (!(parentDir = (targetFile = new File(destDir, relativePath)).getParentFile()).exists()) {
                    parentDir.mkdirs();
                }
                logger.info("Deploying file: {} to {}", (Object)relativePath, (Object)targetFile.getAbsolutePath());
                try (InputStream in = resource.getInputStream();){
                    Files.copy(in, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            logger.info("All files deployed successfully.");
        }
        catch (IOException e) {
            logger.error("Error while deploying files: ", (Throwable)e);
        }
    }
}

