/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.telemetry.main.entity.view;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import lombok.Generated;
import org.hibernate.annotations.Subselect;
import org.springframework.data.annotation.Immutable;

@Entity
@Immutable
@Subselect(value="WITH severity_exists AS (\n      SELECT COUNT (*)> 0 AS exists FROM m_severity\n    )  \n    SELECT a.id, a.alertgeneratedon, alertclosedon, a.servicecode, a.assetid, a.alias,c.node_name AS assetname, \n           a.categorycode, b.description AS category, a.ipaddress, a.name, \n           a.severity, \n           CASE WHEN a.status = 'true' THEN 'Closed' ELSE 'Open' END AS status, \n         CASE \n               WHEN s.exists AND d.severity_name IS NOT NULL THEN d.severity_name \n              WHEN NOT s.exists THEN CASE \n                  WHEN a.severity = 0 THEN 'Ok' \n                  WHEN a.severity = 1 THEN 'Warning' \n                  WHEN a.severity = 2 THEN 'Error' \n                   ELSE 'Critical' END \n              ELSE NULL \n          END AS severityname \n    FROM public.alerthistory a \n    LEFT JOIN coralnms.m_category b ON a.categorycode = b.code \n    LEFT JOIN coralnms.scada_assets c ON a.assetid = c.id \n    LEFT JOIN m_severity d ON a.severity = d.severity_level, \n         severity_exists s")
public class AlertHistoryView {
    @Id
    private Long id;
    @Column(name="alertgeneratedon")
    private Long alertGeneratedOn;
    @Column(name="alertclosedon")
    private Long alertClosedOn;
    @Column(name="servicecode")
    private String serviceCode;
    @Column(name="assetid")
    private Long assetId;
    @Column(name="assetname")
    private String assetName;
    @Column(name="categorycode")
    private String categoryCode;
    private String category;
    @Column(name="ipaddress")
    private String ipAddress;
    private String name;
    private Integer severity;
    private String status;
    @Column(name="severityname")
    private String severityName;
    private String alias;

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getAlertGeneratedOn() {
        return this.alertGeneratedOn;
    }

    @Generated
    public Long getAlertClosedOn() {
        return this.alertClosedOn;
    }

    @Generated
    public String getServiceCode() {
        return this.serviceCode;
    }

    @Generated
    public Long getAssetId() {
        return this.assetId;
    }

    @Generated
    public String getAssetName() {
        return this.assetName;
    }

    @Generated
    public String getCategoryCode() {
        return this.categoryCode;
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getSeverity() {
        return this.severity;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getSeverityName() {
        return this.severityName;
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setAlertGeneratedOn(Long alertGeneratedOn) {
        this.alertGeneratedOn = alertGeneratedOn;
    }

    @Generated
    public void setAlertClosedOn(Long alertClosedOn) {
        this.alertClosedOn = alertClosedOn;
    }

    @Generated
    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    @Generated
    public void setAssetId(Long assetId) {
        this.assetId = assetId;
    }

    @Generated
    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }

    @Generated
    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    @Generated
    public void setCategory(String category) {
        this.category = category;
    }

    @Generated
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSeverity(Integer severity) {
        this.severity = severity;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setSeverityName(String severityName) {
        this.severityName = severityName;
    }

    @Generated
    public void setAlias(String alias) {
        this.alias = alias;
    }
}

