/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.coralapps.callcenter.entity.view;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import lombok.Generated;
import org.hibernate.annotations.Subselect;

@Entity
@Subselect(value="SELECT row_number() OVER () AS id,\nstart_stamp,\n       caller_id_number,\n       destination_number,\n       duration,\n       billsec,\n       CASE \n           WHEN COALESCE(billsec, 0) > 0 \n                AND hangup_cause <> 'NORMAL_CLEARING' \n                AND COALESCE(digits_dialed, 'none') <> 'none' \n           THEN 'NORMAL_CLEARING'\n           ELSE hangup_cause\n       END AS hangup_cause,\n       digits_dialed\nFROM (\n    SELECT id,\n           coral_billaccount AS caller_id_number,\n           id AS tid,\n           cc_side,\n           cc_queue,\n           digits_dialed,\n           start_stamp,\n           destination_number,\n           duration,\n           billsec,\n           hangup_cause\n    FROM pbx.t_cdr\n    WHERE coral_app = 'messageblaster' \n      AND context != 'messageblaster'\n\n    UNION ALL\n\n    SELECT id,\n           destination_number,\n           id AS tid,\n           cc_side,\n           cc_queue,\n           digits_dialed,\n           start_stamp,\n           destination_number,\n           duration,\n           billsec,\n           hangup_cause\n    FROM pbx.t_cdr\n    WHERE context = 'messageblaster' \n      AND cc_side IS NULL \n      AND bridge_uuid IS NULL\n) s")
public class BlasterReportView {
    @Id
    private Long id;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Column(name="start_stamp")
    private LocalDateTime startStamp;
    @Column(name="caller_id_number")
    private String callerIdNumber;
    @Column(name="destination_number")
    private String destinationNumber;
    @Column(name="duration")
    private BigDecimal duration;
    @Column(name="billsec")
    private BigDecimal billSec;
    @Column(name="hangup_cause")
    private String hangupCause;
    @Column(name="digits_dialed")
    private String digitsDialed;

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public LocalDateTime getStartStamp() {
        return this.startStamp;
    }

    @Generated
    public String getCallerIdNumber() {
        return this.callerIdNumber;
    }

    @Generated
    public String getDestinationNumber() {
        return this.destinationNumber;
    }

    @Generated
    public BigDecimal getDuration() {
        return this.duration;
    }

    @Generated
    public BigDecimal getBillSec() {
        return this.billSec;
    }

    @Generated
    public String getHangupCause() {
        return this.hangupCause;
    }

    @Generated
    public String getDigitsDialed() {
        return this.digitsDialed;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public void setStartStamp(LocalDateTime startStamp) {
        this.startStamp = startStamp;
    }

    @Generated
    public void setCallerIdNumber(String callerIdNumber) {
        this.callerIdNumber = callerIdNumber;
    }

    @Generated
    public void setDestinationNumber(String destinationNumber) {
        this.destinationNumber = destinationNumber;
    }

    @Generated
    public void setDuration(BigDecimal duration) {
        this.duration = duration;
    }

    @Generated
    public void setBillSec(BigDecimal billSec) {
        this.billSec = billSec;
    }

    @Generated
    public void setHangupCause(String hangupCause) {
        this.hangupCause = hangupCause;
    }

    @Generated
    public void setDigitsDialed(String digitsDialed) {
        this.digitsDialed = digitsDialed;
    }

    @Generated
    public BlasterReportView() {
    }

    @Generated
    public BlasterReportView(Long id, LocalDateTime startStamp, String callerIdNumber, String destinationNumber, BigDecimal duration, BigDecimal billSec, String hangupCause, String digitsDialed) {
        this.id = id;
        this.startStamp = startStamp;
        this.callerIdNumber = callerIdNumber;
        this.destinationNumber = destinationNumber;
        this.duration = duration;
        this.billSec = billSec;
        this.hangupCause = hangupCause;
        this.digitsDialed = digitsDialed;
    }
}

