/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.task.controller;

import com.coraltele.db.telemetry.main.entity.Task;
import com.coraltele.db.telemetry.main.repository.TaskDetailsRepository;
import com.coraltele.db.telemetry.main.repository.TaskRepository;
import com.coraltele.db.telemetry.main.specification.TaskSpecification;
import com.coraltele.db.users.main.repository.UserGroupMasterRepository;
import com.coraltele.db.users.main.repository.UserGroupRepository;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.telemetry.main.task.model.TaskCreateModel;
import com.coraltele.service.telemetry.main.task.service.TaskService;
import com.coraltele.service.user.service.UserService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@RequestMapping(value={"/api/v2/task"})
public class TaskController {
    private static final Logger logger = LogManager.getLogger(TaskController.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadService;
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    private TaskDetailsRepository taskDetailsRepository;
    @Autowired
    UserService userService;
    @Autowired
    UserGroupRepository userGroupRepository;
    @Autowired
    UserGroupMasterRepository userGroupMasterRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAllTasks(Principal principal) {
        RequestResponse returnValue = this.taskService.getAllTasks(principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createTask(@RequestBody TaskCreateModel data, Principal principal) {
        RequestResponse returnValue = this.taskService.createTask(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateTask(@RequestBody TaskCreateModel data, Principal principal) {
        RequestResponse returnValue = this.taskService.updateTask(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> get(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.taskService.getFilterTasks(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteTask(@RequestBody InputIdModel id, Principal principal) {
        RequestResponse returnValue = this.taskService.deleteTaskById(id, principal);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    private String formatNullableDate(Long epochMillis) {
        return epochMillis != null ? DateFormatUtility.dateAndTimeFormatterForSeconds((LocalDateTime)DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)epochMillis)) : "";
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForCallerCall(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for Task");
            boolean adminUser = false;
            boolean teamLeaderUser = false;
            boolean dispatcher = false;
            if (this.userService.checkAdminUser(principal.getName())) {
                adminUser = true;
            } else if (this.userService.checkRoleDispatcher(principal.getName())) {
                dispatcher = true;
            } else if (this.userService.checkRoleTaskManager(principal.getName())) {
                teamLeaderUser = true;
            }
            Specification filters = TaskSpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (boolean)adminUser, (boolean)dispatcher, (boolean)teamLeaderUser, (UserRepository)this.userRepository, (UserGroupRepository)this.userGroupRepository, (UserGroupMasterRepository)this.userGroupMasterRepository, (TaskRepository)this.taskRepository);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.taskRepository.findAll(filters, sort) : this.taskRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (Task item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValueForCallerCall(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for Task ", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading Task  CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValueForCallerCall(Task task, String columnName) {
        switch (columnName) {
            case "tasksName": {
                return this.checkNull((Object)task.getTasksName());
            }
            case "taskDescription": {
                return this.checkNull((Object)task.getTaskDescription());
            }
            case "taskType": {
                return this.checkNull((Object)task.getTaskType());
            }
            case "taskPriority": {
                return this.checkNull((Object)task.getTaskPriority());
            }
            case "dueDate": {
                if (task.getExpectedCompletionDate() != null) {
                    return this.checkNull((Object)DateFormatUtility.epochToLocalDateTimeAsStringToHandleNull((Long)task.getExpectedCompletionDate()));
                }
            }
            case "assignedGroup": {
                return this.checkNull((Object)task.getAssignedGroup());
            }
            case "assignedUser": {
                return this.checkNull((Object)task.getAssignedUser());
            }
            case "assignedOn": {
                return this.checkNull((Object)DateFormatUtility.epochToLocalDateTimeAsStringToHandleNull((Long)task.getAssignedOn()));
            }
            case "currentStats": {
                return this.checkNull((Object)task.getCurrentStats());
            }
            case "taskCompletedOn": {
                return this.checkNull((Object)DateFormatUtility.epochToLocalDateTimeAsStringToHandleNull((Long)task.getTaskCompletedOn()));
            }
        }
        return null;
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/uploadFile"})
    public ResponseEntity<RequestResponse> uploadFile(@RequestParam(value="file") MultipartFile file) {
        RequestResponse response = this.taskService.saveFile(file);
        if (response.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)response);
        }
        return new ResponseEntity((Object)response, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listWithStatus/{status}"})
    public ResponseEntity<RequestResponse> getFilterListWithStatus(@RequestBody SearchRequest searchRequest, @PathVariable String status, Principal principal) {
        RequestResponse returnValue = this.taskService.getFilterTasksWithStatus(searchRequest, principal, status);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll/{id}"})
    public ResponseEntity<RequestResponse> getByTaskId(@PathVariable(value="id") Integer id) {
        RequestResponse returnValue = this.taskService.getByTaskName(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/userGroup/{username}"})
    public ResponseEntity<RequestResponse> getUserGroupOwnerByUserName(@PathVariable String username) {
        RequestResponse returnValue = this.taskService.getUserGroupOwnerByUserName(username);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/play/{id}"})
    public ResponseEntity<StreamingResponseBody> playFile(@PathVariable(value="id") Integer id) {
        try {
            String path = this.taskService.getFilePath(id);
            if (!StringUtils.hasLength((String)path)) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            Path baseDir = Paths.get(path, new String[0]);
            if (!Files.exists(baseDir, new LinkOption[0]) || !Files.isReadable(baseDir)) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            InputStream inputStream = Files.newInputStream(baseDir, new OpenOption[0]);
            String contentType = Files.probeContentType(baseDir);
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            String filename = baseDir.getFileName().toString();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"inline; filename=\"" + filename + "\""})).body(outputStream -> {
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                    outputStream.flush();
                }
            });
        }
        catch (IOException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/download/{id}"})
    public ResponseEntity<StreamingResponseBody> downloadFile(@PathVariable(value="id") Integer id) {
        try {
            String filePath = this.taskService.getFilePath(id);
            if ("Id doesn't exist".equals(filePath)) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            Path path = Paths.get(filePath, new String[0]);
            if (!Files.exists(path, new LinkOption[0]) || !Files.isReadable(path)) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            String contentType = "application/octet-stream";
            String fileName = path.getFileName().toString();
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            StreamingResponseBody stream = outputStream -> {
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                    outputStream.flush();
                }
                inputStream.close();
            };
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + fileName + "\""})).body((Object)stream);
        }
        catch (IOException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    static {
        columnMappings.put("tasksName", "Tasks Name");
        columnMappings.put("taskDescription", "Task Description");
        columnMappings.put("taskType", "Task Type");
        columnMappings.put("taskPriority", "Task Priority");
        columnMappings.put("expectedCompletionDate", "Due Date");
        columnMappings.put("assignedGroup", "Assigned Group");
        columnMappings.put("assignedUser", "Assigned User");
        columnMappings.put("assignedOn", "Assigned On");
        columnMappings.put("currentStats", "Current Status");
        columnMappings.put("taskCompletedOn", "Task Completed On");
    }
}

