/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.alertHistory.controller;

import com.coraltele.db.telemetry.main.entity.view.AlertHistoryView;
import com.coraltele.db.telemetry.main.repository.AlertHistoryViewRepository;
import com.coraltele.db.telemetry.main.specification.AlertHistoryViewSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.telemetry.main.alertHistory.service.AlertHistoryPDFGenerator;
import com.coraltele.service.telemetry.main.alertHistory.service.AlertHistoryService;
import com.coraltele.service.telemetry.main.alertHistory.service.AlertHistoryViewService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/alertHistory"})
public class AlertHistoryController {
    private static final Logger logger = LogManager.getLogger(AlertHistoryController.class);
    @Autowired
    AlertHistoryViewService alertHistoryViewService;
    @Autowired
    AlertHistoryService alertHistoryService;
    @Autowired
    AlertHistoryPDFGenerator alertHistoryPDFGenerator;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadService;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    AlertHistoryViewRepository alertHistoryViewRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllAlertHistory(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.alertHistoryViewService.getAllAlertHistory(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.alertHistoryService.deleteAlertHistoryById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for alertHistory--");
            Specification filters = AlertHistoryViewSpecification.generateFilters((SearchRequest)searchRequestData, (Boolean)false);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "alertGeneratedOn" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "alertGeneratedOn" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.alertHistoryViewRepository.findAll(filters, sort) : this.alertHistoryViewRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (AlertHistoryView item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for alertHistory", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading alertHistory CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(AlertHistoryView item, String columnName) {
        switch (columnName) {
            case "assetName": {
                return this.checkNull((Object)item.getAssetName());
            }
            case "category": {
                return this.checkNull((Object)item.getCategory());
            }
            case "categoryCode": {
                return this.checkNull((Object)item.getCategoryCode());
            }
            case "ipAddress": {
                return this.checkNull((Object)item.getIpAddress());
            }
            case "name": {
                return this.checkNull((Object)item.getName());
            }
            case "alertClosedOn": {
                return this.formatNullableDate(item.getAlertClosedOn());
            }
            case "alertGeneratedOn": {
                return this.formatNullableDate(item.getAlertGeneratedOn());
            }
            case "severity": {
                return this.checkNull((Object)item.getSeverity());
            }
            case "serviceCode": {
                return this.checkNull((Object)item.getServiceCode());
            }
            case "severityName": {
                return this.checkNull((Object)item.getSeverityName());
            }
            case "status": {
                return this.checkNull((Object)item.getStatus());
            }
            case "assetId": {
                return this.checkNull((Object)item.getAssetId());
            }
            case "alias": {
                return this.checkNull((Object)item.getAlias());
            }
        }
        return null;
    }

    private String formatNullableDate(Long epochMillis) {
        return epochMillis != null ? DateFormatUtility.dateAndTimeFormatter((LocalDateTime)DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)epochMillis)) : "";
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    @PostMapping(value={"/nonWarning/list"})
    public ResponseEntity<RequestResponse> getCriticalAlert(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.alertHistoryViewService.getCriticalAlert(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    static {
        columnMappings.put("alertGeneratedOn", "Alert Generated On");
        columnMappings.put("alertClosedOn", "Alert Closed On ");
        columnMappings.put("serviceCode", "Service Code");
        columnMappings.put("assetId", "AssetId");
        columnMappings.put("assetName", "Asset Name");
        columnMappings.put("categoryCode", "Category Code");
        columnMappings.put("category", "Category");
        columnMappings.put("ipAddress", "IP Address");
        columnMappings.put("name", "Name");
        columnMappings.put("severity", "Severity");
        columnMappings.put("severityName", "Severity Name");
        columnMappings.put("status", "Status");
        columnMappings.put("alias", "Name");
    }
}

