/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.registeredExtension.service;

import com.coraltele.db.telephony.pbx.entity.view.ConfSummary;
import com.coraltele.db.telephony.pbx.entity.view.RegisteredExtension;
import com.coraltele.db.telephony.pbx.repository.ConfSummaryRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.pbx.repository.RegisteredExtensionRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.extension.service.ExtensionsService;
import com.coraltele.service.pbx.registeredExtension.model.ConfSummaryModel;
import com.coraltele.service.pbx.registeredExtension.model.RegisteredExtensionModel;
import com.coraltele.service.pbx.registeredExtension.model.RunningConferenceModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RegisteredExtensionService {
    private static final Logger logger = LogManager.getLogger(RegisteredExtensionService.class);
    @Autowired
    RegisteredExtensionRepository registeredExtensionRepository;
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    ExtensionsService extensionService;
    @Autowired
    ConfSummaryRepository confSummaryRepository;

    public RequestResponse getList(String data) {
        RequestResponse returnValue = new RequestResponse();
        List list = this.registeredExtensionRepository.getNotifiedList(data);
        ArrayList<RegisteredExtensionModel> result = new ArrayList<RegisteredExtensionModel>();
        if (!list.isEmpty()) {
            for (RegisteredExtension row : list) {
                result.add(new RegisteredExtensionModel(row.getParticipantNo(), row.getConferenceNo(), row.getSimulationOn(), row.getConnectedIpAddress(), row.getRegisteredStatus(), row.getTransport(), row.getRegistrationExpiredOn(), row.getConferenceStatus(), row.getUserAgent(), row.getDesignation(), row.getDeviceId(), row.getBatteryPercentage(), row.getRsRpSim1(), row.getRsRpSim2(), row.getDeviceLastUpdated()));
            }
            returnValue.setData(result);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("List of registered extension");
        } else {
            returnValue.setData(Collections.emptyList());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("No Data present");
        }
        return returnValue;
    }

    public RequestResponse getActiveCalls() {
        List list = this.extensionsRepository.findAllByExtensionType("ec");
        HashSet distinctDepartments = new HashSet();
        List addValue = list.stream().filter(extension -> extension.getDepartment() != null && !extension.getDepartment().isEmpty()).filter(extension -> distinctDepartments.add(extension.getDepartment())).map(extension -> {
            ConfSummaryModel data = new ConfSummaryModel();
            data.setId(extension.getId());
            data.setExtension(extension.getExtension());
            data.setName(extension.getName());
            data.setExtensionType(extension.getExtensionType());
            data.setDepartment(extension.getDepartment());
            data.setColor(this.extensionService.getColorOfDepartment(extension.getDepartment()));
            try {
                data.setData(this.getCallData(extension.getExtension()));
            }
            catch (Exception e) {
                logger.error("Unable to conference active data:{}", (Object)e.getMessage());
            }
            return data;
        }).collect(Collectors.toList());
        RequestResponse returnValue = new RequestResponse();
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RunningConferenceModel getCallData(String groupId) {
        RunningConferenceModel data = new RunningConferenceModel();
        List record = this.confSummaryRepository.getSummary(groupId);
        if (!record.isEmpty()) {
            data.setId(Integer.valueOf(1));
            data.setTotalNumber(((ConfSummary)record.get(0)).getTotalNumber());
            data.setAvailable(((ConfSummary)record.get(0)).getAvailable());
            data.setInPtt(((ConfSummary)record.get(0)).getInPtt());
            data.setPrivateCall(((ConfSummary)record.get(0)).getPrivateCall());
            data.setPttControlWith(((ConfSummary)record.get(0)).getPttControlWith());
            data.setVideoStreamId(((ConfSummary)record.get(0)).getVideoStreamId());
            data.setVideoStreamStatus(((ConfSummary)record.get(0)).getVideoStreamStatus());
            data.setVideoStreamBy(((ConfSummary)record.get(0)).getVideoStreamBy());
        } else {
            data.setId(Integer.valueOf(1));
            data.setTotalNumber(Long.valueOf(0L));
            data.setAvailable(Long.valueOf(0L));
            data.setInPtt(Long.valueOf(0L));
            data.setPrivateCall(Long.valueOf(0L));
            data.setPttControlWith("");
            data.setVideoStreamId("");
            data.setVideoStreamStatus("");
            data.setVideoStreamBy("");
        }
        return data;
    }
}

