/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.extensionView.controller;

import com.coraltele.db.telephony.pbx.entity.view.ExtensionPropertiesView;
import com.coraltele.db.telephony.pbx.repository.ExtensionPropertiesViewRepository;
import com.coraltele.db.telephony.pbx.specification.ExtensionPropertiesViewSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.pbx.extensionView.service.ExtensionPropertiesViewService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/extensionView"})
@RestController
public class ExtensionPropertiesViewController {
    private static final Logger logger = LogManager.getLogger(ExtensionPropertiesViewController.class);
    @Autowired
    ExtensionPropertiesViewRepository extensionViewRepository;
    @Autowired
    ExtensionPropertiesViewService extensionViewService;
    @Autowired
    DynamicPdfThreadService generatingReports;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadService;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllExtensionViewByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.extensionViewService.getAllExtensionViewByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for extension properties--");
            Specification filters = ExtensionPropertiesViewSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.extensionViewRepository.findAll(filters, sort) : this.extensionViewRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (ExtensionPropertiesView item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for extension properties", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading extension properties CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(ExtensionPropertiesView item, String columnName) {
        switch (columnName) {
            case "extension": {
                return this.checkNull((Object)item.getExtension());
            }
            case "name": {
                return this.checkNull((Object)item.getName());
            }
            case "extensionType": {
                return this.checkNull((Object)item.getExtensionType());
            }
            case "isd": {
                if (item.getIsd() == 1L) {
                    return "Yes";
                }
                return "No";
            }
            case "std": {
                if (item.getStd() == 1L) {
                    return "Yes";
                }
                return "No";
            }
            case "local": {
                if (item.getLocal() == 1L) {
                    return "Yes";
                }
                return "No";
            }
            case "intercom": {
                if (item.getIntercom() == 1L) {
                    return "Yes";
                }
                return "No";
            }
            case "dnd": {
                if (item.getDnd() == 1L) {
                    return "Yes";
                }
                return "No";
            }
            case "vm": {
                if (item.getVm() == 1L) {
                    return "Yes";
                }
                return "No";
            }
            case "fwdAll": {
                return this.checkNull((Object)item.getFwdAll());
            }
        }
        return null;
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    static {
        columnMappings.put("extension", "Extension No");
        columnMappings.put("name", "Extension Name");
        columnMappings.put("extensionType", "Extension Type");
        columnMappings.put("isd", "ISD");
        columnMappings.put("std", "STD");
        columnMappings.put("local", "Local");
        columnMappings.put("intercom", "Intercom");
        columnMappings.put("dnd", "DND");
        columnMappings.put("vm", "Voice Mail");
        columnMappings.put("fwdAll", "Call Forward All");
    }
}

