/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.denyList.service;

import com.coraltele.db.telephony.pbx.entity.DenyList;
import com.coraltele.db.telephony.pbx.repository.DenyListRepository;
import com.coraltele.db.telephony.pbx.specification.DenyListSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.denyList.model.DenyListModel;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class DenyListService {
    private static final Logger logger = LogManager.getLogger(DenyListService.class);
    @Autowired
    DenyListRepository denyListRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;

    public RequestResponse createDataInDenyList(DenyListModel data, Principal principal) {
        logger.debug("create new DenyList : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            DenyList denyList = new DenyList();
            denyList.setCreatedBy(principal.getName());
            denyList.setCreatedOn(LocalDateTime.now());
            denyList.setNumber(data.getNumber());
            denyList.setDenyTillEpoch(Integer.valueOf(DateFormatUtility.convertToLocalDateTimeToEpoch((LocalDateTime)data.getDenyTillEpoch())));
            this.denyListRepository.save((Object)denyList);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("DenyList Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create DenyList");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(DenyListModel data) {
        logger.debug("Update DenyList {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional denyList = this.denyListRepository.findById((Object)data.getId());
        if (!denyList.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("DenyList not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getDenyTillEpoch() != null) {
            ((DenyList)denyList.get()).setDenyTillEpoch(Integer.valueOf(DateFormatUtility.convertToLocalDateTimeToEpoch((LocalDateTime)data.getDenyTillEpoch())));
        }
        if (data.getNumber() != null) {
            ((DenyList)denyList.get()).setNumber(data.getNumber());
        }
        this.denyListRepository.save(denyList.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("DenyList Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteAgentById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional denyList = this.denyListRepository.findById((Object)ids);
            if (denyList.isPresent()) {
                addValue.add(denyList.get());
                this.denyListRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = DenyListSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.denyListRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.denyListRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<DenyListModel> entityToModelConversion(List<DenyList> denyList) {
        ArrayList<DenyListModel> addValue = new ArrayList<DenyListModel>();
        for (DenyList row : denyList) {
            DenyListModel data = new DenyListModel();
            data.setId(row.getId());
            data.setCreatedBy(row.getCreatedBy());
            data.setCreatedOn(row.getCreatedOn());
            data.setDenyTillEpoch(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getDenyTillEpoch().longValue()));
            data.setCreatedOn(row.getCreatedOn());
            data.setNumber(row.getNumber());
            addValue.add(data);
        }
        return addValue;
    }
}

