/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.blfExtension;

import com.coraltele.db.telephony.pbx.entity.BLFExtension;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.BLFExtRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.helper.Telephony;
import com.coraltele.service.pbx.blfExtension.model.BLFExtListModel;
import com.coraltele.service.pbx.blfExtension.model.BLFModel;
import com.coraltele.service.pbx.extension.service.AuthExtensionService;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class BLFExtService {
    private static final Logger logger = LogManager.getLogger(BLFExtService.class);
    @Autowired
    BLFExtRepository blfExtRepository;
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    AuthExtensionService authExtensionService;

    public RequestResponse getSelectedExtension(String sourceExt) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<BLFExtListModel> addValue = new ArrayList<BLFExtListModel>();
        List getData = this.blfExtRepository.findBySourceExtension(sourceExt);
        if (!getData.isEmpty()) {
            for (BLFExtension row : getData) {
                Optional extensionData = this.extensionsRepository.findByExtension(row.getDestinationExtension());
                if (!extensionData.isPresent()) continue;
                Extension ext = (Extension)extensionData.get();
                BLFExtListModel response = new BLFExtListModel();
                response.setName(ext.getName() != null ? ext.getName() : "");
                response.setSourceExtension(row.getSourceExtension());
                response.setDestinationExtension(row.getDestinationExtension());
                response.setType(ext.getExtensionType() != null ? ext.getExtensionType() : "");
                response.setShuntingMode(Integer.valueOf(ext.getShuntingMode() != null ? ext.getShuntingMode() : 0));
                response.setIsActive(Boolean.valueOf(false));
                Object status = this.fetchStatusFromInternalService(row.getDestinationExtension());
                response.setStatus(status);
                addValue.add(response);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Record of selected extension");
            returnValue.setData(addValue);
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessageDetail("Select existing extension");
            returnValue.setMessage("Invalid extension selected: " + sourceExt);
            logger.info(returnValue.getMessageDetail());
        }
        return returnValue;
    }

    private Object fetchStatusFromInternalService(String destinationExtension) {
        String uri = "http://127.0.0.1:8989/getBLF";
        logger.info("Accessing BLF data from {}", (Object)uri);
        RestTemplate restTemplate = new RestTemplate();
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            map.add((Object)"blfList", (Object)destinationExtension);
            HttpEntity requestEntity = new HttpEntity((Object)map, (MultiValueMap)headers);
            ResponseEntity statusResponse = restTemplate.postForEntity(uri, (Object)requestEntity, Object.class, new Object[0]);
            if (statusResponse.getStatusCode().is2xxSuccessful() && statusResponse.getBody() != null) {
                return statusResponse.getBody();
            }
            logger.error("Failed to fetch status from internal service for extension: {}", (Object)destinationExtension);
            return null;
        }
        catch (Exception e) {
            logger.error("Exception occurred while fetching status from internal service for extension: {}", (Object)destinationExtension, (Object)e);
            return null;
        }
    }

    public RequestResponse getBLFData(String extList) {
        RequestResponse returnValue = new RequestResponse();
        try {
            String uri = "http://127.0.0.1:8989/getBLF";
            logger.info("Accessing blf data from {}", (Object)uri);
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            map.add((Object)"blfList", (Object)extList);
            HttpEntity requestEntity = new HttpEntity((Object)map, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.postForEntity(uri, (Object)requestEntity, Object.class, new Object[0]);
            Object result = response.getBody();
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("record found successfully");
            returnValue.setMessageDetail("blf data ");
            returnValue.setData(result);
            logger.info(returnValue.getMessageDetail());
            return returnValue;
        }
        catch (Exception ex) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("Records not found");
            logger.error(returnValue.getMessageDetail(), (Throwable)ex);
            return returnValue;
        }
    }

    public RequestResponse callDispatcher() {
        RequestResponse returnValue = new RequestResponse();
        String destinationNumber = "";
        String callerNumber = "";
        String sgwip = "";
        try {
            String command = String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,sip_h_X-APICALL=Click2Call,origination_caller_id_number=%s}sofia/internal/%s@%s %s XML calltransfer\"", destinationNumber, callerNumber, sgwip, destinationNumber);
            logger.info("command to execute call is:::{}", (Object)command);
            Telephony.makeCallBackCall((String)command);
            returnValue.setStatus(Constants.Error.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error on making call:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to play file");
        }
        return returnValue;
    }

    public RequestResponse createData(BLFModel data, Principal principal) {
        logger.info((Object)data);
        RequestResponse returnValue = new RequestResponse();
        if (!data.getDestinationExtension().isEmpty() && StringUtils.hasLength((String)data.getSourceExtension())) {
            for (String destExt : data.getDestinationExtension()) {
                if (this.checkExtension(data.getSourceExtension(), destExt)) continue;
                BLFExtension record = new BLFExtension();
                record.setCreatedBy(principal.getName());
                record.setCreatedOn(LocalDateTime.now());
                record.setUuid(UUID.randomUUID().toString());
                record.setSourceExtension(data.getSourceExtension());
                record.setDestinationExtension(destExt);
                this.blfExtRepository.save((Object)record);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Data created");
            returnValue.setMessageDetail("record created successfully");
        } else {
            logger.error("Invalid data:{}", (Object)data);
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid data");
            returnValue.setMessageDetail("unable to create records");
        }
        return returnValue;
    }

    public boolean checkExtension(String src, String dest) {
        List listExt = this.blfExtRepository.findBySourceExtensionAndDestinationExtension(src, dest);
        return !listExt.isEmpty();
    }

    public RequestResponse deleteData(String dest, Principal principal) {
        String src = this.authExtensionService.getExtensionOfUser(principal.getName());
        RequestResponse returnValue = new RequestResponse();
        List blfData = this.blfExtRepository.findBySourceExtensionAndDestinationExtension(src, dest);
        if (!blfData.isEmpty()) {
            this.blfExtRepository.deleteAll((Iterable)blfData);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Data deleted");
            returnValue.setMessageDetail("record deleted successfully");
        }
        return returnValue;
    }
}

