/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.actionCodeList.service;

import com.coraltele.db.telephony.pbx.entity.ActionCodeList;
import com.coraltele.db.telephony.pbx.entity.CodeMaster;
import com.coraltele.db.telephony.pbx.entity.view.ActionCodeMasterView;
import com.coraltele.db.telephony.pbx.repository.ActionCodeListRepository;
import com.coraltele.db.telephony.pbx.repository.ActionCodeMasterViewRepository;
import com.coraltele.db.telephony.pbx.repository.CodeMasterRepository;
import com.coraltele.db.telephony.pbx.specification.ActionCodeMasterViewSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.actionCodeList.model.ActionCodeListModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ActionCodeListService {
    private static final Logger logger = LogManager.getLogger(ActionCodeListService.class);
    @Autowired
    ActionCodeListRepository actionCodeListRepository;
    @Autowired
    CodeMasterRepository codeMasterRepository;
    @Autowired
    ActionCodeMasterViewRepository actionCodeListViewRepository;

    public RequestResponse createData(ActionCodeListModel data) {
        logger.debug("create new actionCode : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            if (data.getCodetype().equalsIgnoreCase("code")) {
                CodeMaster codeMaster = new CodeMaster();
                codeMaster.setDescription(data.getDescription());
                codeMaster.setShortcode(data.getShortcode());
                this.codeMasterRepository.save((Object)codeMaster);
                logger.info(returnValue.getMessage());
            } else {
                ActionCodeList row = new ActionCodeList();
                row.setCodetype(data.getCodetype());
                row.setDescription(data.getDescription());
                row.setShortcode(data.getShortcode());
                this.actionCodeListRepository.save((Object)row);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("ActionCodeMaster Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create ActionCode");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(ActionCodeListModel data) {
        logger.debug("Update ActionCode {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        if (data.getCodetype().equalsIgnoreCase("code")) {
            Optional codeMaster = this.codeMasterRepository.findById((Object)data.getId());
            if (!codeMaster.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("CodeMaster not found");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            ((CodeMaster)codeMaster.get()).setDescription(data.getDescription());
            ((CodeMaster)codeMaster.get()).setShortcode(data.getShortcode());
            this.codeMasterRepository.save(codeMaster.get());
        } else {
            Optional actionCodeList = this.actionCodeListRepository.findById((Object)data.getId());
            if (!actionCodeList.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("ActionCode not found");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            ((ActionCodeList)actionCodeList.get()).setCodetype(data.getCodetype());
            ((ActionCodeList)actionCodeList.get()).setDescription(data.getDescription());
            ((ActionCodeList)actionCodeList.get()).setShortcode(data.getShortcode());
            this.actionCodeListRepository.save(actionCodeList.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("ActionCodeMaster Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteAgentById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        ArrayList addValueCodeMaster = new ArrayList();
        if (data.getCodeType().equalsIgnoreCase("code")) {
            for (Integer ids : data.getIntId()) {
                Optional codeMaster = this.codeMasterRepository.findById((Object)ids);
                if (codeMaster.isPresent()) {
                    addValueCodeMaster.add(codeMaster.get());
                    this.codeMasterRepository.deleteAll(addValueCodeMaster);
                    continue;
                }
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Records not found ");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
        } else {
            for (Integer ids : data.getIntId()) {
                Optional actionCodeList = this.actionCodeListRepository.findById((Object)ids);
                if (actionCodeList.isPresent()) {
                    addValue.add(actionCodeList.get());
                    this.actionCodeListRepository.deleteAll(addValue);
                    continue;
                }
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Records not found ");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ActionCodeMasterViewSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.actionCodeListViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.actionCodeListViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<ActionCodeListModel> entityToModelConversion(List<ActionCodeMasterView> actionCodeList) {
        ArrayList<ActionCodeListModel> addValue = new ArrayList<ActionCodeListModel>();
        for (ActionCodeMasterView row : actionCodeList) {
            ActionCodeListModel data = new ActionCodeListModel();
            data.setCodetype(row.getCodetype());
            data.setDescription(row.getDescription());
            data.setId(row.getId());
            data.setShortcode(row.getShortcode());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse getAllByCodetype(String codeType) {
        List list = (List)this.actionCodeListRepository.findAll();
        ArrayList<ActionCodeListModel> addValue = new ArrayList<ActionCodeListModel>();
        RequestResponse returnValue = new RequestResponse();
        for (ActionCodeList row : list) {
            if (row.getCodetype() == null || !row.getCodetype().equals(codeType)) continue;
            ActionCodeListModel data = new ActionCodeListModel();
            data.setId(row.getId());
            data.setCodetype(codeType);
            data.setDescription(row.getDescription());
            data.setShortcode(row.getShortcode());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("OK" + addValue.size());
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

