/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.main.messageDetail.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.billing.main.messageDetail.service.MessageDetailService;
import com.coraltele.service.billing.main.notification.service.NotificationService;
import com.coraltele.service.uc.service.UCService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/messageDetail"})
@RestController
public class MessageDetailController {
    @Autowired
    UCService ucService;
    @Autowired
    MessageDetailService service;
    @Autowired
    NotificationService notificationService;

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllMessages(@RequestBody SearchRequest searchRequest, Authentication authentication) {
        RequestResponse returnValue = this.service.getList(searchRequest, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateNotification(@RequestBody InputIdModel data) {
        RequestResponse returnValue = this.notificationService.bulkUpdateNotification(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteData(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.notificationService.deleteNotification(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

