/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.uc.service;

import com.coraltele.db.billing.main.repository.ViewChannelUCRepository;
import com.coraltele.db.billing.main.specification.ViewChannelUCSpecification;
import com.coraltele.db.telemetry.main.entity.UCDetails;
import com.coraltele.db.telemetry.main.repository.UCDetailsRepository;
import com.coraltele.db.telemetry.main.specification.UCDetailsSpecification;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.uc.model.UCDetailsModel;
import com.coraltele.service.uc.service.UCConfigurationModel;
import com.coraltele.service.user.service.UserService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ViewChannelUCService {
    private static final Logger logger = LogManager.getLogger(ViewChannelUCService.class);
    @Autowired
    ViewChannelUCRepository vChannelRepository;
    @Autowired
    UCDetailsRepository ucDetailsRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    UserService userService;

    public RequestResponse getAllHistory(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        boolean adminUser = false;
        if (this.userService.checkAdminUser(principal.getName())) {
            adminUser = true;
        }
        if (this.readConfigureUc().equalsIgnoreCase("true")) {
            Specification filters = UCDetailsSpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (boolean)adminUser);
            Sort sort = null;
            if (searchRequestData.getSortDirection().equals("asc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "callReceivedOn" : searchRequestData.getSortBy()}).ascending();
            } else if (searchRequestData.getSortDirection().equals("desc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "callReceivedOn" : searchRequestData.getSortBy()}).descending();
            }
            Page page = null;
            page = sort == null ? this.ucDetailsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.ucDetailsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
            SearchResponse responseData = new SearchResponse();
            responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
            responseData.setPageSize((long)page.getSize());
            responseData.setTotalPages((long)page.getTotalPages());
            responseData.setTotalRecords(page.getTotalElements());
            responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
            returnValue.setData((Object)responseData);
            returnValue.setMessageDetail("filtered list");
            logger.info(returnValue.getMessageDetail());
            return returnValue;
        }
        Specification filters = ViewChannelUCSpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (boolean)adminUser);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startStamp" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "startStamp" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.vChannelRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.vChannelRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessageDetail("filtered list");
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public List<UCDetailsModel> entityToModelConversion(List<UCDetails> list) {
        ArrayList<UCDetailsModel> addValue = new ArrayList<UCDetailsModel>();
        for (UCDetails row : list) {
            UCDetailsModel data = new UCDetailsModel();
            if (row.getCallDirection().equalsIgnoreCase("IN")) {
                data.setUcNumber(row.getUcDialedTo());
                data.setUcDialedTo(row.getUcNumber());
            } else {
                data.setUcNumber(row.getUcNumber());
                data.setUcDialedTo(row.getUcDialedTo());
            }
            if (row.getIsMissed() != null) {
                data.setIsMissed(row.getIsMissed());
            } else {
                data.setIsMissed(Boolean.valueOf(false));
            }
            data.setUcUserId(row.getUcUserId());
            data.setCallDirection(row.getCallDirection());
            data.setCallDuration(row.getCallDuration());
            data.setCallReceivedOn(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getCallReceivedOn()));
            data.setId(row.getId());
            addValue.add(data);
        }
        return addValue;
    }

    public String readConfigureUc() {
        UCConfigurationModel coralFileModel = new UCConfigurationModel();
        try {
            File file = new File("/var/www/html/config.js");
            if (file.exists()) {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                String configureUcValue = "false";
                while ((line = reader.readLine()) != null) {
                    if (!line.trim().startsWith("var configureuc")) continue;
                    configureUcValue = line.split("=")[1].trim().replace(";", "");
                    break;
                }
                reader.close();
                coralFileModel.setConfigureUc(configureUcValue != null ? configureUcValue : "false");
            } else {
                coralFileModel.setConfigureUc("false");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            coralFileModel.setConfigureUc("false");
        }
        return coralFileModel.getConfigureUc();
    }
}

