/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.monitorService.service;

import com.coraltele.db.telemetry.main.entity.MonitorService;
import com.coraltele.db.telemetry.main.repository.MonitorServiceRepository;
import com.coraltele.db.telemetry.main.specification.MonitorServiceSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.monitorService.model.MonitorServiceModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class MonitorServiceService {
    private static final Logger logger = LogManager.getLogger(MonitorServiceService.class);
    @Autowired
    MonitorServiceRepository monitorServiceRepository;

    public RequestResponse createMonitorService(MonitorServiceModel data) {
        logger.debug("create new monitorService : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            MonitorService monitorService = new MonitorService();
            monitorService.setCode(data.getCode());
            monitorService.setData(data.getData());
            monitorService.setDuration(data.getDuration());
            monitorService.setMethod(data.getMethod());
            monitorService.setPortNumber(data.getPortNumber());
            monitorService.setServiceName(data.getServiceName());
            monitorService.setUrl(data.getUrl());
            this.monitorServiceRepository.save((Object)monitorService);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("monitorService created successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to create monitorService");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(MonitorServiceModel data) {
        logger.debug("Update monitorService {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional monitorService = this.monitorServiceRepository.findById(data.getId());
        if (!monitorService.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("monitorService not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getCode() != null) {
            ((MonitorService)monitorService.get()).setCode(data.getCode());
        }
        if (data.getDuration() != null) {
            ((MonitorService)monitorService.get()).setDuration(data.getDuration());
        }
        if (data.getPortNumber() != null) {
            ((MonitorService)monitorService.get()).setPortNumber(data.getPortNumber());
        }
        if (data.getServiceName() != null) {
            ((MonitorService)monitorService.get()).setServiceName(data.getServiceName());
        }
        if (data.getUrl() != null) {
            ((MonitorService)monitorService.get()).setUrl(data.getUrl());
        }
        if (data.getData() != null) {
            ((MonitorService)monitorService.get()).setData(data.getData());
        }
        if (data.getMethod() != null) {
            ((MonitorService)monitorService.get()).setMethod(data.getMethod());
        }
        this.monitorServiceRepository.save(monitorService.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("monitorService Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteMonitorServiceById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Long ids : data.getId()) {
            Optional inboundCos = this.monitorServiceRepository.findById(Long.valueOf(ids));
            if (inboundCos.isPresent()) {
                addValue.add(inboundCos.get());
                this.monitorServiceRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getMonitorServiceByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = MonitorServiceSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.monitorServiceRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.monitorServiceRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAll() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<MonitorServiceModel> addValue = new ArrayList<MonitorServiceModel>();
        List list = this.monitorServiceRepository.findAll();
        for (MonitorService row : list) {
            MonitorServiceModel data = new MonitorServiceModel();
            data.setId(row.getId());
            data.setCode(row.getCode());
            data.setData(row.getData());
            data.setDuration(row.getDuration());
            data.setMethod(row.getMethod());
            data.setPortNumber(row.getPortNumber());
            data.setServiceName(row.getServiceName());
            data.setUrl(row.getUrl());
            addValue.add(data);
        }
        returnValue.setData(addValue);
        returnValue.setMessage("List of MonitorService");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

