/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.locationCategoryService.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.telemetry.main.locationCategoryService.model.LocationCategoryServiceModel;
import com.coraltele.service.telemetry.main.locationCategoryService.service.LocationCategoryServiceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/locationCategoryService"})
@RestController
public class LocationCategoryServiceController {
    @Autowired
    LocationCategoryServiceService locationCategoryServiceService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody LocationCategoryServiceModel data) {
        RequestResponse returnValue = this.locationCategoryServiceService.createCategoryService(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody LocationCategoryServiceModel data) {
        RequestResponse returnValue = this.locationCategoryServiceService.updateById(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.locationCategoryServiceService.deleteCategoryServiceById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getCategoryServiceByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.locationCategoryServiceService.getCategoryServiceByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

