/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.maskedNumber.service;

import com.coraltele.db.telephony.pbx.entity.MaskedNumber;
import com.coraltele.db.telephony.pbx.repository.MaskedNumberRepository;
import com.coraltele.db.telephony.pbx.specification.MaskedNumberSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.maskedNumber.model.MaskedNumberModel;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class MaskedNumberService {
    private static final Logger logger = LogManager.getLogger(MaskedNumberService.class);
    @Autowired
    private MaskedNumberRepository maskedNumberRepository;

    public RequestResponse addMaskedNumber(MaskedNumberModel data) {
        RequestResponse response = new RequestResponse();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String loggedInUser = authentication.getName();
        try {
            MaskedNumber entity = new MaskedNumber();
            entity.setCreatedBy(loggedInUser);
            entity.setPhoneNumber(data.getPhoneNumber());
            entity.setNumberStrip(data.getNumberStrip());
            this.maskedNumberRepository.save((Object)entity);
            response.setStatus(Constants.Error.OK);
            response.setMessage("Masked number added successfully");
        }
        catch (Exception e) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Failed to add masked number: " + e.getMessage());
        }
        return response;
    }

    public RequestResponse updateMaskedNumber(MaskedNumberModel data) {
        RequestResponse response = new RequestResponse();
        try {
            Optional optional = this.maskedNumberRepository.findById((Object)data.getId());
            if (optional.isPresent()) {
                MaskedNumber entity = (MaskedNumber)optional.get();
                entity.setPhoneNumber(data.getPhoneNumber());
                entity.setNumberStrip(data.getNumberStrip());
                this.maskedNumberRepository.save((Object)entity);
                response.setStatus(Constants.Error.OK);
                response.setMessage("Masked number updated successfully");
            } else {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Masked number not found with ID: " + data.getId());
            }
        }
        catch (Exception e) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Failed to update masked number: " + e.getMessage());
        }
        return response;
    }

    public RequestResponse deleteById(InputIdModel id) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : id.getIntId()) {
            Optional notification = this.maskedNumberRepository.findById((Object)ids);
            if (!notification.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Records Not Found ");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            addValue.add(notification.get());
            this.maskedNumberRepository.deleteAll(addValue);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("message deleted");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = MaskedNumberSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.maskedNumberRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.maskedNumberRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

