/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.extension.service;

import com.coraltele.db.telephony.main.entity.Channels;
import com.coraltele.db.telephony.main.repository.ChannelsRepository;
import com.coraltele.db.telephony.pbx.entity.CodeMaster;
import com.coraltele.db.telephony.pbx.entity.DidMapping;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.entity.view.ActionCodeListView;
import com.coraltele.db.telephony.pbx.entity.view.FXOCodeMasterView;
import com.coraltele.db.telephony.pbx.entity.view.PBXServicesView;
import com.coraltele.db.telephony.pbx.entity.view.TrunkAccessCodeView;
import com.coraltele.db.telephony.pbx.entity.view.VoiceGuidanceView;
import com.coraltele.db.telephony.pbx.repository.ActionCodeListViewRepository;
import com.coraltele.db.telephony.pbx.repository.CodeMasterRepository;
import com.coraltele.db.telephony.pbx.repository.DidMappingRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.pbx.repository.FXOCodeMasterViewRepository;
import com.coraltele.db.telephony.pbx.repository.PBXServicesViewRepository;
import com.coraltele.db.telephony.pbx.repository.TrunkAccessCodeViewRepository;
import com.coraltele.db.telephony.pbx.repository.VoiceGuidanceViewRepository;
import com.coraltele.db.telephony.pbx.specification.ActionCodeListViewSpecification;
import com.coraltele.db.telephony.pbx.specification.ExtensionZoneDepartmentSpecification;
import com.coraltele.db.telephony.pbx.specification.FXOCodeMasterViewSpecification;
import com.coraltele.db.telephony.pbx.specification.PBXServicesViewSpecification;
import com.coraltele.db.telephony.pbx.specification.TrunkAccessCodeViewSpecification;
import com.coraltele.db.telephony.pbx.specification.VoiceGuidanceViewSpecification;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DecryptCredential;
import com.coraltele.helper.PasswordConversion;
import com.coraltele.helper.RequestResponse;
import com.coraltele.helper.Telephony;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.externalApi.model.ClickToCall;
import com.coraltele.service.pbx.cos.service.InboundCosService;
import com.coraltele.service.pbx.cos.service.OutboundCosService;
import com.coraltele.service.pbx.extension.model.CodeMasterModel;
import com.coraltele.service.pbx.extension.model.ExtensionCreateModel;
import com.coraltele.service.pbx.extension.model.ExtensionModelCreate;
import com.coraltele.service.pbx.extension.model.ExtensionNewModel;
import com.coraltele.service.pbx.extension.model.ExtensionNumberModel;
import com.coraltele.service.pbx.extension.model.ExtensionPhoneModel;
import com.coraltele.service.pbx.extension.model.ExtensionZoneModel;
import com.coraltele.service.pbx.extension.model.FXOCodeModel;
import com.coraltele.service.pbx.extension.model.ShuntingResponseModel;
import com.coraltele.service.pbx.extension.model.ShuntingStatusModel;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.ExtensionCosMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.ExtensionFeatureMultipleUpdate;
import com.coraltele.service.pbx.extension.service.AuthExtensionService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ExtensionSecondaryService {
    private static final Logger logger = LogManager.getLogger(ExtensionSecondaryService.class);
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    private InboundCosService inBoundCosService;
    @Autowired
    private OutboundCosService outBoundCosService;
    @Autowired
    DecryptCredential encryption;
    @Autowired
    PasswordConversion sipPasswordConversion;
    @Autowired
    ChannelsRepository channelsRepository;
    @Autowired
    AuthExtensionService authExtensionService;
    @Autowired
    ActionCodeListViewRepository actionCodeListViewRepository;
    @Autowired
    FXOCodeMasterViewRepository fxoCodeMasterViewRepository;
    @Autowired
    VoiceGuidanceViewRepository voiceGuidanceViewRepository;
    @Autowired
    PBXServicesViewRepository pbxServicesViewRepository;
    @Autowired
    CodeMasterRepository codeMasterRepository;
    @Autowired
    TrunkAccessCodeViewRepository trunkAccessCodeViewRepository;
    @Autowired
    DidMappingRepository didMappingRepository;

    public RequestResponse getAllExtensionOfPhoneType() {
        List list = this.extensionsRepository.findAll();
        ArrayList<ExtensionPhoneModel> addValue = new ArrayList<ExtensionPhoneModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Extension extension : list) {
            if (extension.getExtensionType() == null || !extension.getExtensionType().equals("phone") || extension.getExtensionSubtype() != null && !extension.getExtensionSubtype().equals("")) continue;
            ExtensionPhoneModel data = new ExtensionPhoneModel();
            data.setId(extension.getId());
            data.setAssignedUser(extension.getAssignedUser());
            data.setExtension(extension.getExtension());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Size of List: " + addValue.size());
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateAssignedUser(ExtensionPhoneModel data) {
        logger.debug("Update Extension {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional id = this.extensionsRepository.findById((Object)data.getId());
        Optional extension = this.extensionsRepository.findByExtension(data.getExtension());
        List list = this.extensionsRepository.findAll();
        ((Extension)extension.get()).setAssignedUser(((Extension)id.get()).getAssignedUser());
        Optional user = this.userRepository.findByUsername(((Extension)id.get()).getAssignedUser());
        ((User)user.get()).setContactNo(data.getExtension());
        for (Extension ext : list) {
            if (ext.getExtensionType() == null || !ext.getExtensionType().equals("phone") || ext.getExtensionSubtype() != null && !ext.getExtensionSubtype().equals("") || !ext.getAssignedUser().equals(((Extension)id.get()).getAssignedUser()) || ext.getExtension() == data.getExtension()) continue;
            ext.setAssignedUser("");
            this.extensionsRepository.save((Object)ext);
        }
        this.extensionsRepository.save(extension.get());
        this.userRepository.save(user.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Extension Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getShuntingOfDepartmentGroup(String extension) {
        Optional extensionData = this.extensionsRepository.findByExtension(extension);
        RequestResponse returnValue = new RequestResponse();
        if (extension != null && !extension.equals("")) {
            if (extensionData.isPresent()) {
                List typeExtension = this.extensionsRepository.findByExtensionTypeAndDepartment("ec", ((Extension)extensionData.get()).getDepartment());
                if (!typeExtension.isEmpty()) {
                    Extension result = (Extension)typeExtension.get(0);
                    ShuntingResponseModel response = new ShuntingResponseModel();
                    response.setExtension(result.getExtension());
                    response.setExtensionType(result.getExtensionType());
                    response.setDepartment(result.getDepartment());
                    response.setShuntingMode(Integer.valueOf(result.getShuntingMode() != null ? result.getShuntingMode() : 0));
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("data found successfully");
                    returnValue.setMessageDetail("data of selected extension");
                    returnValue.setData((Object)response);
                } else {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Not any department exist of selecting extension");
                    returnValue.setMessageDetail("Improper data");
                }
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Input valid extension");
                returnValue.setMessageDetail("Extension not exist");
            }
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Input valid extension");
            returnValue.setMessageDetail("Extension either blank or null");
        }
        return returnValue;
    }

    public RequestResponse getShuntingStatus(String extension) {
        RequestResponse returnValue = new RequestResponse();
        if (extension != null && !extension.equals("")) {
            Optional extensionData = this.extensionsRepository.findByExtension(extension);
            if (extensionData.isPresent()) {
                ShuntingStatusModel response = new ShuntingStatusModel();
                response.setExtension(((Extension)extensionData.get()).getExtension());
                response.setShuntingMode(Integer.valueOf(((Extension)extensionData.get()).getShuntingMode() != null ? ((Extension)extensionData.get()).getShuntingMode() : 0));
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Status of Shunting Mode");
                returnValue.setData((Object)response);
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Select Different Extension");
                returnValue.setMessageDetail("Extension not exist");
                logger.error(returnValue.getMessageDetail());
            }
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Input valid extension");
            returnValue.setMessageDetail("Extension either blank or null");
            logger.error(returnValue.getMessageDetail());
        }
        return returnValue;
    }

    public RequestResponse updateShuntingStatus(ShuntingStatusModel data) {
        Optional extensionData = this.extensionsRepository.findByExtension(data.getExtension());
        RequestResponse returnValue = new RequestResponse();
        if (data.getExtension() != null && !data.getExtension().equals("")) {
            if (extensionData.isPresent()) {
                ((Extension)extensionData.get()).setShuntingMode(data.getShuntingMode());
                this.extensionsRepository.save(extensionData.get());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Status Updated Successfully");
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Select Different Extension");
                returnValue.setMessageDetail("Extension not exist");
                logger.error(returnValue.getMessageDetail());
            }
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Input valid extension");
            returnValue.setMessageDetail("Extension either blank or null");
            logger.error(returnValue.getMessageDetail());
        }
        return returnValue;
    }

    public RequestResponse createExtensionByGivenRange(ExtensionNewModel extensionRange) {
        logger.info("create new extension : {} ==> {}", (Object)extensionRange.getFrom(), (Object)extensionRange.getTo());
        RequestResponse returnValue = new RequestResponse();
        if (!this.validateExtensionRange(extensionRange)) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid range");
            returnValue.setMessageDetail("The 'from' value must be less than or equal to the 'to' value.");
            logger.error(returnValue.getMessageDetail());
            return returnValue;
        }
        boolean checkOutbound = this.outBoundCosService.checkOutboundCosWithZerosCos();
        boolean checkInbound = this.inBoundCosService.checkInboundCosWithZerosCos();
        List existingExtensions = this.checkExtensionsFromGivenRange(extensionRange);
        try {
            if (existingExtensions.size() < Integer.parseInt(extensionRange.getTo()) - Integer.parseInt(extensionRange.getFrom()) + 1) {
                if (!checkOutbound) {
                    this.outBoundCosService.createOutboundCoswithZerosCos();
                }
                if (!checkInbound) {
                    this.inBoundCosService.createInboundCosWithZerosCos();
                }
                for (int i = Integer.parseInt(extensionRange.getFrom()); i <= Integer.parseInt(extensionRange.getTo()); ++i) {
                    if (existingExtensions.contains(i)) continue;
                    Extension extensions = new Extension();
                    extensions.setExtension(String.valueOf(i));
                    if (extensionRange.getPrefix() != null) {
                        extensions.setName(extensionRange.getPrefix() + i);
                    } else {
                        extensions.setName(String.valueOf(i));
                    }
                    extensions.setExtensionType(extensionRange.getType());
                    extensions.setDayOutboundCos("0");
                    extensions.setDayInboundCos("0");
                    extensions.setNightOutboundCos("0");
                    extensions.setNightInboundCos("0");
                    this.extensionsRepository.save((Object)extensions);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Extensions created");
                returnValue.setMessageDetail("All extensions have created successfully");
                logger.info("Extension saved : {}", (Object)returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Can't create,EXTENSION_RANGE_ALREADY_EXISTS");
                returnValue.setMessageDetail("All selected extensions already exist. Select a different range.");
                logger.error(returnValue.getMessageDetail());
            }
        }
        catch (Exception ex) {
            returnValue.setStatus(Constants.Error.EXTENSION_RANGE_ALREADY_EXISTS);
            returnValue.setMessage("Can't Create ");
            returnValue.setMessageDetail("An error occurred while creating extensions");
            logger.error(returnValue.getMessageDetail(), (Throwable)ex);
        }
        return returnValue;
    }

    public List<Integer> checkExtensionsFromGivenRange(ExtensionNewModel range) {
        ArrayList<Integer> existingExtensions = new ArrayList<Integer>();
        for (int i = Integer.parseInt(range.getFrom()); i <= Integer.parseInt(range.getTo()); ++i) {
            Optional extension = this.extensionsRepository.findByExtension(String.valueOf(i));
            if (!extension.isPresent()) continue;
            existingExtensions.add(i);
        }
        return existingExtensions;
    }

    public boolean validateExtensionRange(ExtensionNewModel extensionRange) {
        int to;
        int from = Integer.parseInt(extensionRange.getFrom());
        return from <= (to = Integer.parseInt(extensionRange.getTo()));
    }

    public boolean checkExtensionExistOrNot(String ext) {
        Optional extension = this.extensionsRepository.findByExtension(ext);
        return extension.isPresent();
    }

    public void createDefaultExtensionWithType(String extension, String extType) {
        Extension data = new Extension();
        data.setExtension(extension);
        data.setExtensionType(extType);
        data.setVideoCall(Boolean.valueOf(false));
        data.setPCMA(Boolean.valueOf(false));
        data.setPCMA(Boolean.valueOf(false));
        data.setG722(Boolean.valueOf(false));
        data.setG723(Boolean.valueOf(false));
        data.setG726(Boolean.valueOf(false));
        data.setG729(Boolean.valueOf(false));
        data.setColumn16(Boolean.valueOf(false));
        data.setParkExpiryInterval(Integer.valueOf(0));
        data.setRecord(Boolean.valueOf(false));
        data.setBrowserExt(Boolean.valueOf(false));
        data.setAutoLift(Boolean.valueOf(false));
        data.setCallerIdStatus(Integer.valueOf(0));
        data.setCallWaitingStatus(Integer.valueOf(0));
        data.setIsCallCenterBased(Boolean.valueOf(false));
        data.setCollaboration(Boolean.valueOf(false));
        data.setRestrictFeatureAccess(Boolean.valueOf(false));
        data.setVoicemail(Boolean.valueOf(false));
        data.setRingTime(Integer.valueOf(0));
        data.setIsFeedBack(Boolean.valueOf(false));
        data.setFlexibleTimings(Boolean.valueOf(false));
        data.setDenyPwdPrompt(Boolean.valueOf(false));
        data.setTpi(Boolean.valueOf(false));
        data.setRingReady(Boolean.valueOf(false));
        data.setOpus(Boolean.valueOf(false));
        data.setVp8(Boolean.valueOf(false));
        data.setChimeInterval(Integer.valueOf(0));
        data.setIsExtensionBasedAcd(Boolean.valueOf(false));
        data.setDniBasedRouting(Boolean.valueOf(false));
        data.setCanMulticast(Boolean.valueOf(false));
        data.setCanBroadcast(Boolean.valueOf(false));
        data.setSide(Integer.valueOf(0));
        data.setH264(Boolean.valueOf(false));
        data.setH263(Boolean.valueOf(false));
        data.setCampOnRetryInterval(Integer.valueOf(0));
        data.setABarTimeout(Integer.valueOf(0));
        data.setIsCampOnMode(Boolean.valueOf(false));
        data.setHandleIsDnCause(Boolean.valueOf(false));
        data.setCallerOverrideToHoldParty(Boolean.valueOf(false));
        data.setConferenceMode(Boolean.valueOf(false));
        data.setCallTransferToVm(Integer.valueOf(0));
        data.setSplitRecordingFileInMinutes(Integer.valueOf(60));
        data.setSgwUser(Boolean.valueOf(false));
        data.setRegisterState(Boolean.valueOf(false));
        data.setPremiumCustomer(Boolean.valueOf(false));
        data.setSrtP(Boolean.valueOf(false));
        data.setZrtP(Boolean.valueOf(false));
        data.setDSun(Integer.valueOf(0));
        data.setDMon(Integer.valueOf(0));
        data.setDThu(Integer.valueOf(0));
        data.setDTue(Integer.valueOf(0));
        data.setDWed(Integer.valueOf(0));
        data.setDFri(Integer.valueOf(0));
        data.setDSat(Integer.valueOf(0));
        this.extensionsRepository.save((Object)data);
    }

    public String getSipPassword(String extension) {
        Optional extensionData = this.extensionsRepository.findByExtension(extension);
        if (extensionData.isPresent()) {
            return this.getEncryptSipPassword(((Extension)extensionData.get()).getSipPassword());
        }
        return "";
    }

    public String getEncryptSipPassword(String actualSipPasswd) {
        if (actualSipPasswd != null && StringUtils.hasText((String)actualSipPasswd)) {
            String data = this.sipPasswordConversion.decryptContains(actualSipPasswd);
            String encryptData = this.encryption.encryptData(data);
            return encryptData;
        }
        return "";
    }

    public RequestResponse getAllExtensionPhone() {
        List list = this.extensionsRepository.findAll();
        ArrayList<ExtensionPhoneModel> addValue = new ArrayList<ExtensionPhoneModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Extension row : list) {
            if (row.getExtensionType() == null || !row.getExtensionType().equalsIgnoreCase("phone")) continue;
            ExtensionPhoneModel data = new ExtensionPhoneModel();
            data.setExtension(row.getExtension());
            data.setId(row.getId());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse makeCallTransfer(ClickToCall data) {
        RequestResponse returnValue = new RequestResponse();
        if (StringUtils.hasText((String)data.getCallee()) && StringUtils.hasText((String)data.getCaller())) {
            List channelData1 = this.channelsRepository.findByCoralOriginalNum(data.getCaller());
            if (!channelData1.isEmpty()) {
                Channels channelData = (Channels)channelData1.get(0);
                String command = String.format("fs_cli -x \"uuid_transfer %s %s XML calltransfer\"", channelData.getCallUuid(), data.getCallee());
                logger.info("command to execute call is:::{}", (Object)command);
                Telephony.makeCallBackCall((String)command);
                logger.error("call executed successfully");
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Call transfer successfully");
            } else {
                logger.error("Not any record exist in channels for CORAL_ORIGINAL_NUM:{}", (Object)data.getCaller());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No data present to make call");
            }
        } else {
            logger.error("Invalid Data input to process request:{},{}", (Object)data.getCaller(), (Object)data.getCallee());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid data");
            returnValue.setMessageDetail("caller or callee may be incorrect");
        }
        return returnValue;
    }

    public RequestResponse getAllExtensionType() {
        List list = this.extensionsRepository.findAll();
        HashSet<String> extensionType = new HashSet<String>();
        RequestResponse returnValue = new RequestResponse();
        for (Extension extension : list) {
            extensionType.add(extension.getExtensionType());
        }
        ArrayList<ExtensionNumberModel> addValue = new ArrayList<ExtensionNumberModel>();
        for (String type : extensionType) {
            if (type == null) continue;
            ExtensionNumberModel data = new ExtensionNumberModel();
            data.setExtensionType(type);
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllExtensionsByExtensionType(String extensionType) {
        List list = this.extensionsRepository.findByExtensionType(extensionType);
        ArrayList<ExtensionNumberModel> addValue = new ArrayList<ExtensionNumberModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Extension extension : list) {
            if (extension.getZone() != null && !extension.getZone().equals("") || extension.getDepartment() != null && !extension.getDepartment().equals("")) continue;
            ExtensionNumberModel data = new ExtensionNumberModel();
            data.setExtension(extension.getExtension());
            data.setExtensionType(extension.getExtensionType());
            data.setName(extension.getName());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateExtension(ExtensionZoneModel data) {
        logger.debug("Update Extension {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional extension = this.extensionsRepository.findByExtension(data.getExtension());
        if (!extension.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("Extension Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getExtensionType() != null) {
            ((Extension)extension.get()).setExtensionType(data.getExtensionType());
        }
        if (data.getDepartment() != null) {
            ((Extension)extension.get()).setDepartment(data.getDepartment());
        }
        if (data.getZone() != null) {
            ((Extension)extension.get()).setZone(data.getZone());
        }
        if (data.getName() != null) {
            ((Extension)extension.get()).setName(data.getName());
        }
        if (data.getDesignation() != null) {
            ((Extension)extension.get()).setDesignation(data.getDesignation());
        }
        this.extensionsRepository.save(extension.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Extension Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateZoneAndDepartmentByExtension(ExtensionFeatureMultipleUpdate data) {
        logger.debug("Update Extension {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        for (String extensionNumber : data.getExtensions()) {
            Optional extension = this.extensionsRepository.findByExtension(extensionNumber);
            if (!extension.isPresent()) continue;
            ((Extension)extension.get()).setZone("");
            ((Extension)extension.get()).setDepartment("");
            this.extensionsRepository.save(extension.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Extension Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getFilteredExtensions(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ExtensionZoneDepartmentSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.extensionsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.extensionsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<ExtensionZoneModel> entityToModelConversion(List<Extension> extensions) {
        ArrayList<ExtensionZoneModel> addValue = new ArrayList<ExtensionZoneModel>();
        for (Extension row : extensions) {
            ExtensionZoneModel data = new ExtensionZoneModel();
            data.setDepartment(row.getDepartment());
            data.setExtension(row.getExtension());
            data.setExtensionType(row.getExtensionType());
            data.setDesignation(row.getDesignation());
            data.setZone(row.getZone());
            addValue.add(data);
        }
        return addValue;
    }

    public String getZoneOfUser(String username) {
        Optional extensionData;
        String extension = this.authExtensionService.getExtensionOfUser(username);
        if (extension != null && StringUtils.hasText((String)extension) && (extensionData = this.extensionsRepository.findByExtension(extension)).isPresent()) {
            return ((Extension)extensionData.get()).getZone();
        }
        return "";
    }

    public String getDepartmentOfUser(String username) {
        Optional extensionData;
        String extension = this.authExtensionService.getExtensionOfUser(username);
        if (extension != null && StringUtils.hasText((String)extension) && (extensionData = this.extensionsRepository.findByExtension(extension)).isPresent()) {
            return ((Extension)extensionData.get()).getDepartment();
        }
        return "";
    }

    public RequestResponse getNameByPhoneStatus() {
        List list = this.extensionsRepository.findByExtensionType("phonestatus");
        ArrayList<ExtensionZoneModel> addValue = new ArrayList<ExtensionZoneModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Extension row : list) {
            ExtensionZoneModel data = new ExtensionZoneModel();
            data.setId(row.getId());
            data.setName(row.getName());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getExtensionByAcdGroup() {
        List list = this.extensionsRepository.findAll();
        ArrayList<ExtensionZoneModel> addValue = new ArrayList<ExtensionZoneModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Extension row : list) {
            if (row.getExtensionType() == null || row.getExtensionType().equals("") || !row.getExtensionType().equals("acd") && !row.getExtensionType().equals("ocgroup")) continue;
            ExtensionZoneModel data = new ExtensionZoneModel();
            data.setId(row.getId());
            data.setExtension(row.getExtension());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteByExtension(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (String ids : data.getStringId()) {
            Optional extensionOptional = this.extensionsRepository.findByExtension(ids);
            if (extensionOptional.isPresent()) {
                addValue.add(extensionOptional.get());
                this.extensionsRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public void updateDepartment(String extension, String emergencyExtension) {
        try {
            Optional phoneExtension;
            Optional getEcExtension;
            if (extension == null || extension.isEmpty() || emergencyExtension == null || emergencyExtension.isEmpty()) {
                logger.error("Extension or Emergency Extension cannot be null or empty.");
            }
            if ((getEcExtension = this.extensionsRepository.findByExtension(emergencyExtension)).isPresent()) {
                phoneExtension = this.extensionsRepository.findByExtension(extension);
                if (!phoneExtension.isPresent()) {
                    throw new IllegalStateException("Phone extension not found: " + extension);
                }
            } else {
                throw new IllegalStateException("Emergency extension not found: " + emergencyExtension);
            }
            Extension phoneExt = (Extension)phoneExtension.get();
            phoneExt.setDepartment(((Extension)getEcExtension.get()).getDepartment());
            this.extensionsRepository.save((Object)phoneExt);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            logger.error("Error updating department: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred while updating department.", (Throwable)e);
        }
    }

    public RequestResponse updateMultipleInboundOutboundCosByExtension(ExtensionCosMultipleUpdate modeMultipleUpdate) {
        RequestResponse returnValue = new RequestResponse();
        for (String extension : modeMultipleUpdate.getExtensions()) {
            Optional extensions = this.extensionsRepository.findByExtension(extension);
            if (!extensions.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Records not found ");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            if (modeMultipleUpdate.getType().equalsIgnoreCase("inboundcos")) {
                if (modeMultipleUpdate.getInboundCos() != null) {
                    ((Extension)extensions.get()).setDayInboundCos(modeMultipleUpdate.getInboundCos());
                    ((Extension)extensions.get()).setNightInboundCos(modeMultipleUpdate.getInboundCos());
                }
            } else if (modeMultipleUpdate.getOutboundCos() != null) {
                ((Extension)extensions.get()).setDayOutboundCos(modeMultipleUpdate.getOutboundCos());
                ((Extension)extensions.get()).setNightOutboundCos(modeMultipleUpdate.getOutboundCos());
            }
            this.extensionsRepository.save(extensions.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse createDataActionCodeList(ExtensionCreateModel data) {
        logger.debug("create new ActionCodeList : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional ext = this.extensionsRepository.findByExtension(data.getExtension());
            if (ext.isPresent()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Code is already present");
                returnValue.setMessageDetail("Please enter different code");
                return returnValue;
            }
            Extension extension = new Extension();
            extension.setExtension(data.getExtension());
            extension.setExtensionType(data.getExtensionType());
            this.extensionsRepository.save((Object)extension);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("ActionCodeList Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create Disposition");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ActionCodeListViewSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.actionCodeListViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.actionCodeListViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversionForActionCodeList(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<ActionCodeListView> entityToModelConversionForActionCodeList(List<ActionCodeListView> actionCodeList) {
        ArrayList<ActionCodeListView> addValue = new ArrayList<ActionCodeListView>();
        for (ActionCodeListView row : actionCodeList) {
            ActionCodeListView data = new ActionCodeListView();
            data.setDescription(row.getDescription());
            data.setExtensionType(row.getExtensionType());
            data.setExtension(row.getExtension());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse deleteExtension(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (String ids : data.getStringId()) {
            Optional extension = this.extensionsRepository.findByExtension(ids);
            if (extension.isPresent()) {
                addValue.add(extension.get());
                this.extensionsRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Extensions Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse createDataInExtensionForFxoCode(ExtensionModelCreate data) {
        logger.debug("create new extension : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional info = this.extensionsRepository.findByExtension(data.getExtension());
            if (info.isPresent()) {
                returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                returnValue.setMessage("Extension already exists");
                returnValue.setMessageDetail("Please enter different extension");
                return returnValue;
            }
            Extension extension = new Extension();
            extension.setExtension(data.getExtension());
            extension.setExtensionType("dropcode");
            if (data.getDSun() != null && data.getDSun().booleanValue()) {
                extension.setDSun(Integer.valueOf(1));
            } else {
                extension.setDSun(Integer.valueOf(0));
            }
            if (data.getDMon() != null && data.getDMon().booleanValue()) {
                extension.setDMon(Integer.valueOf(2));
            } else {
                extension.setDMon(Integer.valueOf(0));
            }
            if (data.getDTue() != null && data.getDTue().booleanValue()) {
                extension.setDTue(Integer.valueOf(3));
            } else {
                extension.setDTue(Integer.valueOf(0));
            }
            if (data.getDWed() != null && data.getDWed().booleanValue()) {
                extension.setDWed(Integer.valueOf(4));
            } else {
                extension.setDWed(Integer.valueOf(0));
            }
            if (data.getDThu() != null && data.getDThu().booleanValue()) {
                extension.setDThu(Integer.valueOf(5));
            } else {
                extension.setDThu(Integer.valueOf(0));
            }
            if (data.getDFri() != null && data.getDFri().booleanValue()) {
                extension.setDFri(Integer.valueOf(6));
            } else {
                extension.setDFri(Integer.valueOf(0));
            }
            if (data.getDSat() != null && data.getDSat().booleanValue()) {
                extension.setDSat(Integer.valueOf(7));
            } else {
                extension.setDSat(Integer.valueOf(0));
            }
            extension.setFromTime(data.getFromTime());
            extension.setToTime(data.getToTime());
            extension.setTimezone(data.getTimezone());
            extension.setNonworkingApp(data.getNonworkingApp());
            extension.setNonworkingData(data.getNonworkingData());
            extension.setDayInboundCos(data.getDayInboundCos());
            extension.setNightInboundCos(data.getNightInboundCos());
            extension.setDayOutboundCos(data.getDayOutboundCos());
            extension.setNightOutboundCos(data.getNightOutboundCos());
            extension.setData(data.getData());
            if (data.getTpi() != null && data.getTpi().booleanValue()) {
                extension.setTpi(Boolean.valueOf(true));
            } else {
                extension.setTpi(Boolean.valueOf(false));
            }
            this.extensionsRepository.save((Object)extension);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("FXO Code Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create Extension");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateDataInExtensionForFxoCode(ExtensionModelCreate data) {
        logger.debug("create new extension : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional extension = this.extensionsRepository.findByExtension(data.getExtension());
            if (!extension.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Record not found");
                return returnValue;
            }
            if (data.getDSun() != null && data.getDSun().booleanValue()) {
                ((Extension)extension.get()).setDSun(Integer.valueOf(1));
            } else {
                ((Extension)extension.get()).setDSun(Integer.valueOf(0));
            }
            if (data.getDMon() != null && data.getDMon().booleanValue()) {
                ((Extension)extension.get()).setDMon(Integer.valueOf(2));
            } else {
                ((Extension)extension.get()).setDMon(Integer.valueOf(0));
            }
            if (data.getDTue() != null && data.getDTue().booleanValue()) {
                ((Extension)extension.get()).setDTue(Integer.valueOf(3));
            } else {
                ((Extension)extension.get()).setDTue(Integer.valueOf(0));
            }
            if (data.getDWed() != null && data.getDWed().booleanValue()) {
                ((Extension)extension.get()).setDWed(Integer.valueOf(4));
            } else {
                ((Extension)extension.get()).setDWed(Integer.valueOf(0));
            }
            if (data.getDThu() != null && data.getDThu().booleanValue()) {
                ((Extension)extension.get()).setDThu(Integer.valueOf(5));
            } else {
                ((Extension)extension.get()).setDThu(Integer.valueOf(0));
            }
            if (data.getDFri() != null && data.getDFri().booleanValue()) {
                ((Extension)extension.get()).setDFri(Integer.valueOf(6));
            } else {
                ((Extension)extension.get()).setDFri(Integer.valueOf(0));
            }
            if (data.getDSat() != null && data.getDSat().booleanValue()) {
                ((Extension)extension.get()).setDSat(Integer.valueOf(7));
            } else {
                ((Extension)extension.get()).setDSat(Integer.valueOf(0));
            }
            ((Extension)extension.get()).setFromTime(data.getFromTime());
            ((Extension)extension.get()).setToTime(data.getToTime());
            ((Extension)extension.get()).setTimezone(data.getTimezone());
            ((Extension)extension.get()).setNonworkingApp(data.getNonworkingApp());
            ((Extension)extension.get()).setNonworkingData(data.getNonworkingData());
            ((Extension)extension.get()).setDayInboundCos(data.getDayInboundCos());
            ((Extension)extension.get()).setNightInboundCos(data.getNightInboundCos());
            ((Extension)extension.get()).setDayOutboundCos(data.getDayOutboundCos());
            ((Extension)extension.get()).setNightOutboundCos(data.getNightOutboundCos());
            ((Extension)extension.get()).setData(data.getData());
            if (data.getTpi() != null && data.getTpi().booleanValue()) {
                ((Extension)extension.get()).setTpi(Boolean.valueOf(true));
            } else {
                ((Extension)extension.get()).setTpi(Boolean.valueOf(false));
            }
            this.extensionsRepository.save(extension.get());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("FXO Code Updated Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Update");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAllByFilterForFXOCode(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = FXOCodeMasterViewSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.fxoCodeMasterViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.fxoCodeMasterViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversionForFxoCode(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<FXOCodeModel> entityToModelConversionForFxoCode(List<FXOCodeMasterView> actionCodeList) {
        ArrayList<FXOCodeModel> addValue = new ArrayList<FXOCodeModel>();
        for (FXOCodeMasterView row : actionCodeList) {
            FXOCodeModel data = new FXOCodeModel();
            data.setId(row.getId());
            data.setExtension(row.getExtension());
            if (row.getDSun() != null && row.getDSun() != 0) {
                data.setDSun(Boolean.valueOf(true));
            } else {
                data.setDSun(Boolean.valueOf(false));
            }
            if (row.getDMon() != null && row.getDMon() != 0) {
                data.setDMon(Boolean.valueOf(true));
            } else {
                data.setDMon(Boolean.valueOf(false));
            }
            if (row.getDTue() != null && row.getDTue() != 0) {
                data.setDTue(Boolean.valueOf(true));
            } else {
                data.setDTue(Boolean.valueOf(false));
            }
            if (row.getDWed() != null && row.getDWed() != 0) {
                data.setDWed(Boolean.valueOf(true));
            } else {
                data.setDWed(Boolean.valueOf(false));
            }
            if (row.getDThu() != null && row.getDThu() != 0) {
                data.setDThu(Boolean.valueOf(true));
            } else {
                data.setDThu(Boolean.valueOf(false));
            }
            if (row.getDFri() != null && row.getDFri() != 0) {
                data.setDFri(Boolean.valueOf(true));
            } else {
                data.setDFri(Boolean.valueOf(false));
            }
            if (row.getDSat() != null && row.getDSat() != 0) {
                data.setDSat(Boolean.valueOf(true));
            } else {
                data.setDSat(Boolean.valueOf(false));
            }
            data.setFromTime(row.getFromTime());
            data.setToTime(row.getToTime());
            data.setTimezone(row.getTimezone());
            data.setNonworkingApp(row.getNonworkingApp());
            data.setNonworkingData(row.getNonworkingData());
            data.setDayInboundCos(row.getDayInboundCos());
            data.setNightInboundCos(row.getNightInboundCos());
            data.setDayOutboundCos(row.getDayOutboundCos());
            data.setNightOutboundCos(row.getNightOutboundCos());
            data.setData(row.getData());
            if (row.getTpi() != null && row.getTpi().equalsIgnoreCase("Yes")) {
                data.setTpi(Boolean.valueOf(true));
            } else {
                data.setTpi(Boolean.valueOf(false));
            }
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse createDataForVoiceGuidance(ExtensionCreateModel data) {
        logger.debug("create new Voice Guidance : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional ext = this.extensionsRepository.findByExtension(data.getExtension());
            if (ext.isPresent()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Code is already present");
                returnValue.setMessageDetail("Please enter different code");
                return returnValue;
            }
            Extension extension = new Extension();
            extension.setExtension(data.getExtension());
            extension.setExtensionType(data.getExtensionType());
            this.extensionsRepository.save((Object)extension);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Voice Guidance Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create Voice Guidance");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAllByFilterForVoiceGuidance(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = VoiceGuidanceViewSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.voiceGuidanceViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.voiceGuidanceViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversionForVoiceGuidance(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<VoiceGuidanceView> entityToModelConversionForVoiceGuidance(List<VoiceGuidanceView> actionCodeList) {
        ArrayList<VoiceGuidanceView> addValue = new ArrayList<VoiceGuidanceView>();
        for (VoiceGuidanceView row : actionCodeList) {
            VoiceGuidanceView data = new VoiceGuidanceView();
            data.setDescription(row.getDescription());
            data.setExtensionType(row.getExtensionType());
            data.setExtension(row.getExtension());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse getAllByFilterForPbxService(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = PBXServicesViewSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.pbxServicesViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.pbxServicesViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversionForPbxService(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<PBXServicesView> entityToModelConversionForPbxService(List<PBXServicesView> actionCodeList) {
        ArrayList<PBXServicesView> addValue = new ArrayList<PBXServicesView>();
        for (PBXServicesView row : actionCodeList) {
            PBXServicesView data = new PBXServicesView();
            data.setDescription(row.getDescription());
            data.setExtensionType(row.getExtensionType());
            data.setExtension(row.getExtension());
            data.setDenyPwdPrompt(row.getDenyPwdPrompt());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse createDataForPbxService(ExtensionCreateModel data) {
        logger.debug("create new pbx: {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional ext = this.extensionsRepository.findByExtension(data.getExtension());
            if (ext.isPresent()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Code is already present");
                returnValue.setMessageDetail("Please enter different code");
                return returnValue;
            }
            Extension extension = new Extension();
            extension.setExtension(data.getExtension());
            extension.setExtensionType(data.getExtensionType());
            extension.setData("pbxservice");
            this.extensionsRepository.save((Object)extension);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Pbx Service Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create Pbx Service");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAllCodeMaster() {
        List list = (List)this.codeMasterRepository.findAll();
        ArrayList<CodeMasterModel> addValue = new ArrayList<CodeMasterModel>();
        RequestResponse returnValue = new RequestResponse();
        for (CodeMaster row : list) {
            CodeMasterModel data = new CodeMasterModel();
            data.setId(row.getId());
            data.setDescription(row.getDescription());
            data.setShortcode(row.getShortcode());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("OK" + addValue.size());
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilterForTrunkAccessCode(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = TrunkAccessCodeViewSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "code" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "code" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.trunkAccessCodeViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.trunkAccessCodeViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversionForTrunkAccessCode(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<TrunkAccessCodeView> entityToModelConversionForTrunkAccessCode(List<TrunkAccessCodeView> actionCodeList) {
        ArrayList<TrunkAccessCodeView> addValue = new ArrayList<TrunkAccessCodeView>();
        for (TrunkAccessCodeView row : actionCodeList) {
            TrunkAccessCodeView data = new TrunkAccessCodeView();
            data.setExtension(row.getExtension());
            data.setData(row.getData());
            data.setDid(row.getDid());
            data.setExtensionType(row.getExtensionType());
            data.setId(row.getId());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse createDataForTrunkAccessCode(ExtensionCreateModel data) {
        logger.debug("create new Trunk: {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional ext = this.extensionsRepository.findByExtension(data.getExtension());
            Optional didMapping = this.didMappingRepository.findByExtNumber(data.getExtension());
            if (ext.isPresent() || didMapping.isPresent()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Code is already present");
                returnValue.setMessageDetail("Please enter different code");
                return returnValue;
            }
            Extension extension = new Extension();
            extension.setExtension(data.getExtension());
            extension.setExtensionType(data.getExtensionType());
            extension.setData(data.getData());
            this.extensionsRepository.save((Object)extension);
            DidMapping mapping = new DidMapping();
            mapping.setExtNumber(data.getExtension());
            this.didMappingRepository.save((Object)mapping);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Trunk Access Code Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create Trunk Access Code");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateDidMapping(ExtensionCreateModel data) {
        logger.debug("Update Extension {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional ext = this.extensionsRepository.findByExtension(data.getExtension());
        Optional didMapping = this.didMappingRepository.findByExtNumber(data.getExtension());
        if (!ext.isPresent() || !didMapping.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("Extension or DID mapping not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        Extension extension = (Extension)ext.get();
        extension.setDidNumber(data.getDid());
        extension.setData(data.getData());
        this.extensionsRepository.save((Object)extension);
        DidMapping mapping = (DidMapping)didMapping.get();
        mapping.setDidNumber(data.getDid());
        this.didMappingRepository.save((Object)mapping);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Trunk Access Code updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

