/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.leadUpload.controller;

import com.coraltele.db.coralapps.callcenter.repository.LeadMasterRepository;
import com.coraltele.db.coralapps.callcenter.repository.UploadLeadDataRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.coralApps.callcenter.leadUpload.model.PopUpRequestModel;
import com.coraltele.service.coralApps.callcenter.leadUpload.service.LeadUploadService;
import java.security.Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/api/v2/leadUpload"})
@RestController
public class LeadUploadController {
    private static final Logger logger = LogManager.getLogger(LeadUploadController.class);
    @Autowired
    LeadUploadService leadUploadService;
    @Autowired
    UploadLeadDataRepository uploadLeadDataRepository;
    @Autowired
    LeadMasterRepository leadMasterRepository;

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.leadUploadService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> getData(Principal principal, @RequestBody PopUpRequestModel data) {
        RequestResponse returnValue = this.leadUploadService.getDataOnCall(principal, data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/onAnswer/{id}"})
    public ResponseEntity<RequestResponse> updateOnAnswer(@PathVariable(value="id") Long id) {
        RequestResponse returnValue = this.leadUploadService.updateAnswerCall(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/upload"})
    public ResponseEntity<RequestResponse> uploadLead(@RequestParam(value="file") MultipartFile file, Principal principal, @RequestParam(value="campaignId", required=true) Long campaignId) {
        RequestResponse returnValue = this.leadUploadService.handleFileUpload(file, principal, campaignId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

