/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.FileModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class IVRUtility {
    private static final Logger logger = LogManager.getLogger(IVRUtility.class);
    private Path foundFile;
    String message = null;

    public List<FileModel> getFileList(String filePath) {
        File[] fileList;
        ArrayList<FileModel> addValue = new ArrayList<FileModel>();
        File f = new File(filePath);
        for (File row : fileList = f.listFiles()) {
            if (!row.isFile()) continue;
            FileModel data = new FileModel();
            data.setFileName(row.getName());
            addValue.add(data);
        }
        return addValue;
    }

    public boolean getFileToUpload(MultipartFile multipartFile, String language, String filename, String contentType) {
        String path = "/usr/local/freeswitch/sounds/" + language + "/ivr";
        boolean uploaded = false;
        try {
            InputStream inputStream = multipartFile.getInputStream();
            byte[] data = new byte[inputStream.available()];
            inputStream.read();
            FileOutputStream fileOutputStream = new FileOutputStream(path + File.separator + filename + contentType);
            fileOutputStream.write(data);
            fileOutputStream.flush();
            fileOutputStream.close();
            File uploadedFile = new File(path + File.separator + filename + contentType);
            uploadedFile.setWritable(false, false);
            uploaded = true;
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return uploaded;
    }

    public List<Object> getCustomFiles(String filePath) {
        ArrayList<Object> addValue = new ArrayList<Object>();
        File f = new File(filePath);
        if (!f.exists()) {
            return null;
        }
        File[] fileList = f.listFiles();
        if (fileList.length == 0) {
            return null;
        }
        for (File row : fileList) {
            if (!row.isFile()) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            String filename = row.getName().replace(".json", "");
            map.put("file", filename);
            addValue.add(map);
        }
        return addValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RequestResponse uploadImage(MultipartFile fileName, String pathToUpload) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        Path uploadPath = Paths.get(pathToUpload, new String[0]);
        if (!Files.exists(uploadPath, new LinkOption[0])) {
            try {
                Files.createDirectories(uploadPath, new FileAttribute[0]);
            }
            catch (Exception e) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Not Found ");
                returnValue.setMessageDetail("Path Does Not Exist, Where File Has To Be Uploaded");
                this.message = MessageFormat.format(" Path Does Not Exist, Where File Has To Be Uploaded : {0}", pathToUpload);
                logger.error(this.message);
                return returnValue;
            }
        }
        try (InputStream inputStream = fileName.getInputStream();){
            String filename = UUID.randomUUID().toString().trim() + ".tif";
            Path filePath = uploadPath.resolve(filename.trim());
            Files.copy(inputStream, filePath, StandardCopyOption.REPLACE_EXISTING);
            returnValue.setData((Object)filename);
            RequestResponse requestResponse = returnValue;
            return requestResponse;
        }
        catch (IOException ioe) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found ");
            returnValue.setMessageDetail("Path Does Not Exist, Where File Has To Be Uploaded");
            this.message = MessageFormat.format(" Path Does Not Exist, Where File Has To Be Uploaded : {0}", pathToUpload);
            logger.error(this.message);
            return returnValue;
        }
    }

    public Resource sourceToDownload(String fileName) throws IOException {
        int lastIndex = fileName.lastIndexOf("/");
        String path = fileName.substring(0, lastIndex) + "/";
        String actualFile = fileName.substring(lastIndex + 1, fileName.length());
        Path dirPath = Paths.get(path.trim(), new String[0]);
        Files.list(dirPath).forEach(file -> {
            if (file.getFileName().toString().startsWith(actualFile.trim())) {
                this.foundFile = file;
                return;
            }
        });
        if (this.foundFile != null) {
            return new UrlResource(this.foundFile.toUri());
        }
        return null;
    }

    public Resource sourceToDownloadMp3Resource(String filename) {
        File mp3File = new File(filename);
        if (mp3File.exists() && mp3File.isFile()) {
            return new FileSystemResource(mp3File);
        }
        return null;
    }
}

