/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.telephony.pbx.entity.view;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import lombok.Generated;
import org.hibernate.annotations.Subselect;

@Entity
@Subselect(value="SELECT row_number() OVER () AS id, *\nFROM (\n    SELECT \n        a.ani AS caller_id_number,\n        a.userremarks AS codebluetype,\n        a.coral_featurecode AS accesscode,\n        a.destination_number AS dialnumber,\n        a.start_stamp AS starttime,\n        a.answer_stamp AS answertime,\n        a.end_stamp::timestamp(0) AS endtime,\n        a.billsec AS duration,\n        a.hangup_cause AS hangupcause,\n        b.start_stamp AS ivrstarttime,\n        b.end_stamp::timestamp(0) AS ivrendtime,\n        b.duration AS ivrduration,\n        a.coral_dialid,\n        c.smstext,\n        c.status,\n        c.executiontime\n    FROM pbx.t_cdr a\n    LEFT OUTER JOIN pbx.t_cdr b \n        ON a.coral_dialid = b.coral_dialid AND b.coral_app = 'codeblueivr'\n    LEFT OUTER JOIN pbx.smsdetails c \n        ON a.coral_featurecode = c.accesscode \n        AND a.destination_number = c.destination \n        AND a.coral_dialid = c.dial_refid\n    WHERE a.coral_app = 'codeblue'\n) AS final_result\n")
public class CodeBlueReportView {
    @Id
    private Long id;
    @Column(name="caller_id_number")
    private String callerIdNumber;
    @Column(name="codebluetype")
    private String codeBlueType;
    @Column(name="accesscode")
    private String accessCode;
    @Column(name="dialnumber")
    private String dialNumber;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Column(name="starttime")
    private LocalDateTime startTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Column(name="answertime")
    private LocalDateTime answerTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Column(name="endtime")
    private LocalDateTime endtime;
    @Column(name="duration")
    private BigDecimal duration;
    @Column(name="hangupcause")
    private String hangupCause;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Column(name="ivrstarttime")
    private LocalDateTime ivrStarttime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Column(name="ivrendtime")
    private LocalDateTime ivrEndtime;
    @Column(name="ivrduration")
    private BigDecimal ivrDuration;
    @Column(name="coral_dialid")
    private Long coralDialId;
    @Column(name="smstext")
    private String smsText;
    @Column(name="status")
    private String status;
    @Column(name="executiontime")
    private String executionTime;

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getCallerIdNumber() {
        return this.callerIdNumber;
    }

    @Generated
    public String getCodeBlueType() {
        return this.codeBlueType;
    }

    @Generated
    public String getAccessCode() {
        return this.accessCode;
    }

    @Generated
    public String getDialNumber() {
        return this.dialNumber;
    }

    @Generated
    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    @Generated
    public LocalDateTime getAnswerTime() {
        return this.answerTime;
    }

    @Generated
    public LocalDateTime getEndtime() {
        return this.endtime;
    }

    @Generated
    public BigDecimal getDuration() {
        return this.duration;
    }

    @Generated
    public String getHangupCause() {
        return this.hangupCause;
    }

    @Generated
    public LocalDateTime getIvrStarttime() {
        return this.ivrStarttime;
    }

    @Generated
    public LocalDateTime getIvrEndtime() {
        return this.ivrEndtime;
    }

    @Generated
    public BigDecimal getIvrDuration() {
        return this.ivrDuration;
    }

    @Generated
    public Long getCoralDialId() {
        return this.coralDialId;
    }

    @Generated
    public String getSmsText() {
        return this.smsText;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getExecutionTime() {
        return this.executionTime;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCallerIdNumber(String callerIdNumber) {
        this.callerIdNumber = callerIdNumber;
    }

    @Generated
    public void setCodeBlueType(String codeBlueType) {
        this.codeBlueType = codeBlueType;
    }

    @Generated
    public void setAccessCode(String accessCode) {
        this.accessCode = accessCode;
    }

    @Generated
    public void setDialNumber(String dialNumber) {
        this.dialNumber = dialNumber;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public void setAnswerTime(LocalDateTime answerTime) {
        this.answerTime = answerTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public void setEndtime(LocalDateTime endtime) {
        this.endtime = endtime;
    }

    @Generated
    public void setDuration(BigDecimal duration) {
        this.duration = duration;
    }

    @Generated
    public void setHangupCause(String hangupCause) {
        this.hangupCause = hangupCause;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public void setIvrStarttime(LocalDateTime ivrStarttime) {
        this.ivrStarttime = ivrStarttime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public void setIvrEndtime(LocalDateTime ivrEndtime) {
        this.ivrEndtime = ivrEndtime;
    }

    @Generated
    public void setIvrDuration(BigDecimal ivrDuration) {
        this.ivrDuration = ivrDuration;
    }

    @Generated
    public void setCoralDialId(Long coralDialId) {
        this.coralDialId = coralDialId;
    }

    @Generated
    public void setSmsText(String smsText) {
        this.smsText = smsText;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setExecutionTime(String executionTime) {
        this.executionTime = executionTime;
    }

    @Generated
    public CodeBlueReportView() {
    }

    @Generated
    public CodeBlueReportView(Long id, String callerIdNumber, String codeBlueType, String accessCode, String dialNumber, LocalDateTime startTime, LocalDateTime answerTime, LocalDateTime endtime, BigDecimal duration, String hangupCause, LocalDateTime ivrStarttime, LocalDateTime ivrEndtime, BigDecimal ivrDuration, Long coralDialId, String smsText, String status, String executionTime) {
        this.id = id;
        this.callerIdNumber = callerIdNumber;
        this.codeBlueType = codeBlueType;
        this.accessCode = accessCode;
        this.dialNumber = dialNumber;
        this.startTime = startTime;
        this.answerTime = answerTime;
        this.endtime = endtime;
        this.duration = duration;
        this.hangupCause = hangupCause;
        this.ivrStarttime = ivrStarttime;
        this.ivrEndtime = ivrEndtime;
        this.ivrDuration = ivrDuration;
        this.coralDialId = coralDialId;
        this.smsText = smsText;
        this.status = status;
        this.executionTime = executionTime;
    }
}

