/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.userRouteShift.shiftTime.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.user.userRouteShift.shiftTime.model.ShiftTimeModel;
import com.coraltele.service.user.userRouteShift.shiftTime.service.ShiftTimeService;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v2/shiftTime"})
public class ShiftTimeController {
    @Autowired
    ShiftTimeService shiftTimeService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createShiftTime(@RequestBody ShiftTimeModel userShiftModel) {
        RequestResponse returnValue = this.shiftTimeService.createShiftTime(userShiftModel);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAllShiftTime() {
        RequestResponse returnValue = this.shiftTimeService.getAllShiftTime();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateShiftTime(@RequestBody ShiftTimeModel userShiftModel) {
        RequestResponse returnValue = this.shiftTimeService.updateShiftTime(userShiftModel);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteShiftTime(@RequestBody InputIdModel id, Principal principal) {
        RequestResponse returnValue = this.shiftTimeService.deleteShiftTime(id, principal);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.shiftTimeService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

