/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.uc.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.billing.main.uc_notification.service.UcNotificationService;
import com.coraltele.service.uc.service.ChannelService;
import com.coraltele.service.uc.service.PhoneBookService;
import com.coraltele.service.uc.service.UCService;
import com.coraltele.service.uc.service.ViewChannelUCService;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/uc"})
@RestController
public class UCController {
    @Autowired
    UCService ucService;
    @Autowired
    PhoneBookService phoneBookService;
    @Autowired
    ChannelService channelService;
    @Autowired
    ViewChannelUCService vChannelUCService;
    @Autowired
    private UcNotificationService notificationService;

    @PostMapping(value={"/cdr"})
    public ResponseEntity<RequestResponse> currentStatus() {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.ucService.getCDR(""));
        return ResponseEntity.ok((Object)returnValue);
    }

    @PostMapping(value={"/vm"})
    public ResponseEntity<RequestResponse> getVoiceMails(Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.ucService.getVoiceMails(principal.getName()));
        return ResponseEntity.ok((Object)returnValue);
    }

    @PostMapping(value={"/fax"})
    public ResponseEntity<RequestResponse> getFax(Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.ucService.getFax(principal.getName()));
        return ResponseEntity.ok((Object)returnValue);
    }

    @PostMapping(value={"/phoneBook/list"})
    public ResponseEntity<RequestResponse> getAllPhoneBook(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.phoneBookService.getAll(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/phoneBook/listAll"})
    public ResponseEntity<RequestResponse> getAllPhoneBookContact(Principal principal) {
        RequestResponse returnValue = this.phoneBookService.getAllData(principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/missedCall/list"})
    public ResponseEntity<RequestResponse> getAllMissedCall(@RequestBody SearchRequest extensionSearchRequest, Authentication authentication) {
        RequestResponse returnValue = this.channelService.getAllChannel(extensionSearchRequest, (Principal)authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/callHistory/list"})
    public ResponseEntity<RequestResponse> getAllCallHistory(@RequestBody SearchRequest vChannelSearchRequest, Principal principal) {
        RequestResponse returnValue = this.vChannelUCService.getAllHistory(vChannelSearchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/{messageType}"})
    private ResponseEntity<RequestResponse> updateNotification(@RequestBody InputIdModel rowId, Authentication authentication, @PathVariable(value="messageType") String messageType) {
        RequestResponse returnValue = this.ucService.updateNotification(rowId, authentication, messageType);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/countNotification/list"})
    public ResponseEntity<RequestResponse> getAllMessage(Authentication authentication) {
        RequestResponse returnValue = new RequestResponse();
        returnValue = this.notificationService.getCountNotification(authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/deleteMissedCall"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.ucService.deleteMissedCall(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

