/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.telephonyDeployment.service;

import com.coraltele.db.telemetry.main.entity.TelephonyDeployment;
import com.coraltele.db.telemetry.main.repository.TelephonyDeploymentRepository;
import com.coraltele.db.telemetry.main.specification.TelephonyDeploymentSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.telephonyDeployment.model.TelephonyDeploymentModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class TelephonyDeploymentService {
    private static final Logger logger = LogManager.getLogger(TelephonyDeploymentService.class);
    @Autowired
    TelephonyDeploymentRepository telephonyDeploymentRepository;

    public RequestResponse createData(TelephonyDeploymentModel data) {
        logger.debug("create new telephonyDeploymentModel : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            TelephonyDeployment telephonyDeployment = new TelephonyDeployment();
            telephonyDeployment.setNodeIp(data.getNodeIp());
            telephonyDeployment.setPriority(data.getPriority());
            telephonyDeployment.setRluCode(data.getRluCode());
            telephonyDeployment.setServerCode(data.getServerCode());
            telephonyDeployment.setVirtualIp(data.getVirtualIp());
            this.telephonyDeploymentRepository.save((Object)telephonyDeployment);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("TelephonyDeployment Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create TelephonyDeployment");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(TelephonyDeploymentModel data) {
        logger.debug("Update TelephonyDeploymentModel {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional telephonyDeployment = this.telephonyDeploymentRepository.findById(data.getId());
        if (!telephonyDeployment.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("TelephonyDeploymentModel Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getNodeIp() != null) {
            ((TelephonyDeployment)telephonyDeployment.get()).setNodeIp(data.getNodeIp());
        }
        if (data.getPriority() != null) {
            ((TelephonyDeployment)telephonyDeployment.get()).setPriority(data.getPriority());
        }
        if (data.getRluCode() != null) {
            ((TelephonyDeployment)telephonyDeployment.get()).setRluCode(data.getRluCode());
        }
        if (data.getServerCode() != null) {
            ((TelephonyDeployment)telephonyDeployment.get()).setServerCode(data.getServerCode());
        }
        if (data.getVirtualIp() != null) {
            ((TelephonyDeployment)telephonyDeployment.get()).setVirtualIp(data.getVirtualIp());
        }
        this.telephonyDeploymentRepository.save(telephonyDeployment.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("TelephonyDeployment Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteTelephonyDeploymentById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Long ids : data.getId()) {
            Optional telephonyDeployment = this.telephonyDeploymentRepository.findById(Long.valueOf(ids));
            if (telephonyDeployment.isPresent()) {
                addValue.add(telephonyDeployment.get());
                this.telephonyDeploymentRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = (List)this.telephonyDeploymentRepository.findAll();
        ArrayList<TelephonyDeploymentModel> addValue = new ArrayList<TelephonyDeploymentModel>();
        RequestResponse returnValue = new RequestResponse();
        for (TelephonyDeployment telephonyDeployment : list) {
            TelephonyDeploymentModel data = new TelephonyDeploymentModel();
            data.setId(telephonyDeployment.getId());
            data.setNodeIp(telephonyDeployment.getNodeIp());
            data.setPriority(telephonyDeployment.getPriority());
            data.setRluCode(telephonyDeployment.getRluCode());
            data.setServerCode(telephonyDeployment.getServerCode());
            data.setVirtualIp(telephonyDeployment.getVirtualIp());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllTelephonyDeploymentByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = TelephonyDeploymentSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.telephonyDeploymentRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.telephonyDeploymentRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

