/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.eventActivityLogs.service;

import com.coraltele.db.telemetry.main.entity.EventActivityLogs;
import com.coraltele.db.telemetry.main.repository.EventActivityLogsRepository;
import com.coraltele.db.telemetry.main.specification.EventActivityLogSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.eventActivityLogs.model.EventActivityLogModel;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class EventActivityLogService {
    private static final Logger logger = LogManager.getLogger(EventActivityLogService.class);
    @Autowired
    EventActivityLogsRepository eventActivityLogsRepository;

    public RequestResponse createData(EventActivityLogModel data, Principal principal) {
        logger.debug("Create new ActivityLog: {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            EventActivityLogs eventActivityLogs = new EventActivityLogs();
            eventActivityLogs.setCallType(data.getCallType());
            eventActivityLogs.setCallingGroup(data.getCallingGroup());
            eventActivityLogs.setCallerNumber(data.getCallerNumber());
            eventActivityLogs.setDestinationNumber(data.getDestinationNumber());
            eventActivityLogs.setCreatedBy(principal.getName());
            eventActivityLogs.setCreatedOn(LocalDateTime.now());
            this.eventActivityLogsRepository.save((Object)eventActivityLogs);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Data Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create activityLogs");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse last50Records(Principal principal) {
        logger.debug("list of 50 ActivityLog");
        RequestResponse returnValue = new RequestResponse();
        try {
            List list = this.eventActivityLogsRepository.findTop50ByCreatedByOrderByCreatedOnDesc(principal.getName());
            if (!list.isEmpty()) {
                ArrayList<EventActivityLogModel> addValue = new ArrayList<EventActivityLogModel>();
                for (EventActivityLogs data : list) {
                    EventActivityLogModel activityLogs = new EventActivityLogModel();
                    activityLogs.setId(data.getId());
                    activityLogs.setCreatedBy(data.getCreatedBy());
                    activityLogs.setCreatedOn(data.getCreatedOn());
                    activityLogs.setCallType(data.getCallType());
                    activityLogs.setCallingGroup(data.getCallingGroup());
                    activityLogs.setCallerNumber(data.getCallerNumber());
                    activityLogs.setDestinationNumber(data.getDestinationNumber());
                    activityLogs.setCreatedOn(data.getCreatedOn());
                    addValue.add(activityLogs);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK");
                returnValue.setMessageDetail("List fetched Successfully");
                returnValue.setData(addValue);
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("No Record found");
                returnValue.setMessageDetail("Empty list exist of current user");
                logger.error(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create activityLogs");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getALLLogs(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = EventActivityLogSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.eventActivityLogsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.eventActivityLogsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

