/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.billingCDR.service;

import com.coraltele.db.telemetry.main.repository.BillingCDRRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.billingCDR.model.DepartmentSummaryModel;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DepartmentSummaryService {
    private static final Logger logger = LogManager.getLogger(DepartmentSummaryService.class);
    @Autowired
    BillingCDRRepository billingCDRRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;

    public RequestResponse getAllByFilter(SearchRequest req) {
        RequestResponse res = new RequestResponse();
        try {
            ArrayList<DepartmentSummaryModel> list = this.getSummaryList(req);
            if (req.getSearch() != null && !req.getSearch().trim().isEmpty()) {
                String key = req.getSearch().trim().toLowerCase();
                ArrayList<DepartmentSummaryModel> filtered = new ArrayList<DepartmentSummaryModel>();
                for (DepartmentSummaryModel d : list) {
                    if (!(d.getDepartmentCode() != null && d.getDepartmentCode().toLowerCase().contains(key) || d.getDepartmentName() != null && d.getDepartmentName().toLowerCase().contains(key)) && (d.getCallerIdNumber() == null || !d.getCallerIdNumber().toLowerCase().contains(key))) continue;
                    filtered.add(d);
                }
                list = filtered;
            }
            int page = req.getCurrentPage() == null ? 0 : req.getCurrentPage();
            int size = req.getPageSize() == null ? list.size() : req.getPageSize().intValue();
            int total = list.size();
            int from = page * size;
            int to = Math.min(from + size, total);
            List pageData = from >= total ? new ArrayList() : list.subList(from, to);
            SearchResponse response = new SearchResponse();
            response.setCurrentPage((long)page);
            response.setPageSize((long)size);
            response.setTotalRecords((long)total);
            response.setTotalPages((long)((int)Math.ceil((double)total / (double)size)));
            response.setCurrentPageData(pageData);
            res.setStatus(Constants.Error.OK);
            res.setMessage("Department Summary Report");
            res.setData((Object)response);
            logger.info("Department Summary fetched successfully");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error("Failed loading Department Summary", (Throwable)ex);
            res.setStatus(Constants.Error.ERROR);
            res.setMessage("Something went wrong while fetching department summary");
        }
        return res;
    }

    public List<DepartmentSummaryModel> getSummaryList(SearchRequest request) {
        String deptCode = null;
        String deptName = null;
        LocalDate fromDate = null;
        LocalDate toDate = null;
        if (request.getAdvancedFilters() != null) {
            for (AdvanceFilter f : request.getAdvancedFilters()) {
                if ("departmentCode".equalsIgnoreCase(f.getFieldName())) {
                    deptCode = f.getValue();
                }
                if ("departmentName".equalsIgnoreCase(f.getFieldName())) {
                    deptName = f.getValue();
                }
                if (!"callDate".equalsIgnoreCase(f.getFieldName())) continue;
                if ("from".equalsIgnoreCase(f.getDirection())) {
                    fromDate = LocalDate.parse(f.getValue());
                }
                if (!"to".equalsIgnoreCase(f.getDirection())) continue;
                toDate = LocalDate.parse(f.getValue());
            }
        }
        List rows = this.billingCDRRepository.getDepartmentSummaryReport(deptCode, deptName, fromDate, toDate);
        ArrayList<DepartmentSummaryModel> list = new ArrayList<DepartmentSummaryModel>();
        System.out.println("Rows Department: " + rows);
        for (Object[] r : rows) {
            DepartmentSummaryModel m = new DepartmentSummaryModel();
            m.setDepartmentCode((String)r[0]);
            m.setDepartmentName((String)r[1]);
            m.setCallerIdNumber((String)r[2]);
            m.setIntercomCall(String.valueOf(r[3]));
            m.setIntercomCost(this.formatINR(this.toDouble(r[4])));
            m.setLocalCall(String.valueOf(r[5]));
            m.setLocalCost(this.formatINR(this.toDouble(r[6])));
            m.setStdCall(String.valueOf(r[7]));
            m.setStdCost(this.formatINR(this.toDouble(r[8])));
            m.setIsdCall(String.valueOf(r[9]));
            m.setIsdCost(this.formatINR(this.toDouble(r[10])));
            m.setTotalCall(String.valueOf(r[11]));
            m.setTotalCost(this.formatINR(this.toDouble(r[12])));
            list.add(m);
        }
        return list;
    }

    private Double toDouble(Object o) {
        return o == null ? 0.0 : ((Number)o).doubleValue();
    }

    private String formatINR(Double amount) {
        amount = amount == null ? Double.valueOf(0.0) : Double.valueOf((double)Math.round(amount) / 100.0);
        NumberFormat nf = NumberFormat.getCurrencyInstance(new Locale("en", "IN"));
        return nf.format(amount);
    }
}

