/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.billingCDR.service;

import com.coraltele.db.telemetry.main.repository.BillingCDRRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.billingCDR.model.DepartmentDetailsModel;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DepartmentDetailsService {
    @Autowired
    private BillingCDRRepository billingCDRRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;

    public RequestResponse getAllByFilter(SearchRequest req) {
        RequestResponse res = new RequestResponse();
        try {
            ArrayList<DepartmentDetailsModel> list = this.getList(req);
            if (req.getSearch() != null && !req.getSearch().trim().isEmpty()) {
                String key = req.getSearch().trim().toLowerCase();
                ArrayList<DepartmentDetailsModel> filtered = new ArrayList<DepartmentDetailsModel>();
                for (DepartmentDetailsModel d : list) {
                    if (!(d.getDepartmentCode() != null && d.getDepartmentCode().toLowerCase().contains(key) || d.getDepartmentName() != null && d.getDepartmentName().toLowerCase().contains(key) || d.getCallerIdNumber() != null && d.getCallerIdNumber().toLowerCase().contains(key) || d.getDestinationNumber() != null && d.getDestinationNumber().toLowerCase().contains(key) || d.getCallType() != null && d.getCallType().toLowerCase().contains(key)) && (d.getCoralCallDirection() == null || !d.getCoralCallDirection().toLowerCase().contains(key))) continue;
                    filtered.add(d);
                }
                list = filtered;
            }
            int page = req.getCurrentPage() == null ? 0 : req.getCurrentPage();
            int size = req.getPageSize() == null ? list.size() : req.getPageSize().intValue();
            int total = list.size();
            int from = page * size;
            int to = Math.min(from + size, total);
            List pageData = from >= total ? new ArrayList() : list.subList(from, to);
            SearchResponse response = new SearchResponse();
            response.setCurrentPage((long)page);
            response.setPageSize((long)size);
            response.setTotalRecords((long)total);
            response.setTotalPages((long)((int)Math.ceil((double)total / (double)size)));
            response.setCurrentPageData(pageData);
            res.setStatus(Constants.Error.OK);
            res.setMessage("Department Details Report");
            res.setData((Object)response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            res.setStatus(Constants.Error.ERROR);
            res.setMessage("Something went wrong while loading department details");
        }
        return res;
    }

    public List<DepartmentDetailsModel> getList(SearchRequest req) {
        String deptCode = null;
        String deptName = null;
        String callerId = null;
        String callType = null;
        String callDirection = null;
        LocalDate fromDate = null;
        LocalDate toDate = null;
        if (req.getAdvancedFilters() != null) {
            for (AdvanceFilter f : req.getAdvancedFilters()) {
                if ("departmentCode".equalsIgnoreCase(f.getFieldName())) {
                    deptCode = f.getValue();
                }
                if ("departmentName".equalsIgnoreCase(f.getFieldName())) {
                    deptName = f.getValue();
                }
                if ("callerIdNumber".equalsIgnoreCase(f.getFieldName())) {
                    callerId = f.getValue();
                }
                if ("callType".equalsIgnoreCase(f.getFieldName())) {
                    callType = f.getValue();
                }
                if ("callDirection".equalsIgnoreCase(f.getFieldName())) {
                    callDirection = f.getValue();
                }
                if (!"startEpoch".equalsIgnoreCase(f.getFieldName()) || f.getValue() == null || f.getValue().trim().isEmpty()) continue;
                if ("from".equalsIgnoreCase(f.getDirection())) {
                    fromDate = LocalDate.parse(f.getValue());
                }
                if (!"to".equalsIgnoreCase(f.getDirection())) continue;
                toDate = LocalDate.parse(f.getValue());
            }
        }
        List rows = this.billingCDRRepository.getDepartmentDetailsReport(deptCode, deptName, callerId, callType, callDirection, fromDate, toDate);
        ArrayList<DepartmentDetailsModel> list = new ArrayList<DepartmentDetailsModel>();
        for (Object[] r : rows) {
            DepartmentDetailsModel m = new DepartmentDetailsModel();
            m.setId(Long.valueOf(((Number)r[0]).longValue()));
            m.setDepartmentCode((String)r[1]);
            m.setDepartmentName((String)r[2]);
            m.setCallerIdNumber((String)r[3]);
            m.setDestinationNumber((String)r[5]);
            m.setCallType((String)r[6]);
            m.setCoralCallDirection((String)r[7]);
            Long duration = r[8] == null ? 0L : ((Number)r[8]).longValue();
            Double cost = r[10] == null ? 0.0 : ((Number)r[10]).doubleValue();
            m.setTalkDuration(this.formatDuration(duration));
            m.setPulse(Long.valueOf(r[9] == null ? 0L : ((Number)r[9]).longValue()));
            m.setCost(this.formatINR(cost));
            m.setStartEpoch(r[4] == null ? null : r[4].toString());
            list.add(m);
        }
        return list;
    }

    private String formatINR(Double amount) {
        amount = amount == null ? Double.valueOf(0.0) : Double.valueOf((double)Math.round(amount) / 100.0);
        NumberFormat nf = NumberFormat.getCurrencyInstance(new Locale("en", "IN"));
        return nf.format(amount);
    }

    private String formatDuration(Long seconds) {
        if (seconds == null) {
            seconds = 0L;
        }
        long totalSeconds = seconds;
        long hh = totalSeconds / 3600L;
        long mm = totalSeconds % 3600L / 60L;
        long ss = totalSeconds % 60L;
        return String.format("%02d:%02d:%02d", hh, mm, ss);
    }
}

