/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.taxonomy.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.pbx.taxonomy.model.TaxonomyModel;
import com.coraltele.service.pbx.taxonomy.service.TaxonomyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/taxonomy"})
@RestController
public class TaxonomyController {
    @Autowired
    TaxonomyService taxonomyService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody TaxonomyModel data) {
        RequestResponse returnValue = this.taxonomyService.createData(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody TaxonomyModel data) {
        RequestResponse returnValue = this.taxonomyService.updateById(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.taxonomyService.deleteById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.taxonomyService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAll() {
        RequestResponse returnValue = this.taxonomyService.getAll();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/{category}/list"})
    public ResponseEntity<RequestResponse> getListByCategory(@PathVariable(value="category") String category) {
        RequestResponse returnValue = this.taxonomyService.getByCategory(category);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

