/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.taskPriority.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.pbx.taskPriority.model.TaskPriorityModel;
import com.coraltele.service.pbx.taskPriority.service.TaskPriorityService;
import java.security.Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/taskPriority"})
public class TaskPriorityController {
    private static final Logger logger = LogManager.getLogger(TaskPriorityController.class);
    @Autowired
    private TaskPriorityService taskPriorityService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createTaskPriority(@RequestBody TaskPriorityModel taskPriorityModel, Principal principal) {
        RequestResponse returnValue = this.taskPriorityService.createTaskPriority(taskPriorityModel, principal);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAllTaskPriorities() {
        RequestResponse returnValue = this.taskPriorityService.getAllTaskPriorities();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateTaskPriority(@RequestBody TaskPriorityModel taskPriorityModel, Principal principal) {
        RequestResponse returnValue = this.taskPriorityService.updateTaskPriority(taskPriorityModel, principal);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteTaskPriority(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.taskPriorityService.deleteTaskPriority(id);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getFilterTaskPriorities(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.taskPriorityService.getFilterTaskPriority(searchRequest);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

