/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.systemConfig.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.systemConfig.model.SystemConfigModel;
import com.coraltele.service.pbx.systemConfig.service.SystemConfigService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/systemConfig"})
@RestController
public class SystemConfigController {
    private static final Logger logger = LogManager.getLogger(SystemConfigController.class);
    private static final String CONTROLLER_NAME = "SystemConfig";
    @Autowired
    SystemConfigService systemConfigService;

    @GetMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getData() {
        RequestResponse returnValue = this.systemConfigService.getData();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            String message = MessageFormat.format("{1} data processed successfully for listing", CONTROLLER_NAME);
            logger.info(message);
            return ResponseEntity.ok((Object)returnValue);
        }
        String message = MessageFormat.format("{1} unable to process data for listing", CONTROLLER_NAME);
        logger.info(message);
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateSystemConfig(@RequestBody SystemConfigModel data, Authentication authentication) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String dataReceived = objectMapper.writeValueAsString((Object)data);
            String message = MessageFormat.format("{1} received for update : {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            RequestResponse returnValue = this.systemConfigService.update(data, authentication);
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                message = MessageFormat.format("{1} data processed successfully for update : {0}", CONTROLLER_NAME, dataReceived);
                logger.info(message);
                return ResponseEntity.ok((Object)returnValue);
            }
            message = MessageFormat.format("{1} unable to process data for update: {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (JsonProcessingException e) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Invalid json data");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/getUpdatedId"})
    public ResponseEntity<RequestResponse> getUpdatedId() {
        RequestResponse returnValue = this.systemConfigService.getUpdatedId();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

