/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.pulseMaster.service;

import com.coraltele.db.telephony.pbx.entity.PulseMaster;
import com.coraltele.db.telephony.pbx.repository.PulseMasterRepository;
import com.coraltele.db.telephony.pbx.specification.PulseMasterSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.pulseMaster.model.PulseMasterModel;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class PulseMasterService {
    private static final Logger logger = LogManager.getLogger(PulseMasterService.class);
    @Autowired
    private PulseMasterRepository pulseMasterRepository;

    public RequestResponse addPulseMaster(PulseMasterModel data) {
        RequestResponse response = new RequestResponse();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String loggedInUser = authentication.getName();
        try {
            if (this.pulseMasterRepository.existsByPulseCode(data.getPulseCode())) {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Pulse code already exists: " + data.getPulseCode());
                return response;
            }
            PulseMaster entity = new PulseMaster();
            entity.setCreatedBy(loggedInUser);
            entity.setGateway(data.getGateway());
            entity.setFromTime(DateFormatUtility.stringToLocalTime((String)data.getFromTime()));
            entity.setToTime(DateFormatUtility.stringToLocalTime((String)data.getToTime()));
            entity.setPulse(Integer.valueOf(data.getPulse() != null ? data.getPulse() : 0));
            entity.setPulseCode(data.getPulseCode());
            entity.setRange(data.getRange());
            entity.setRate(data.getRate());
            this.pulseMasterRepository.save((Object)entity);
            response.setStatus(Constants.Error.OK);
            response.setMessage("Pulse master record added successfully");
        }
        catch (Exception e) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Failed to add pulse master: " + e.getMessage());
        }
        return response;
    }

    public RequestResponse updatePulseMaster(PulseMasterModel data) {
        RequestResponse response = new RequestResponse();
        try {
            Optional optional = this.pulseMasterRepository.findById((Object)data.getId());
            if (optional.isPresent()) {
                if (this.pulseMasterRepository.existsByPulseCodeAndIdNot(data.getPulseCode(), data.getId())) {
                    response.setStatus(Constants.Error.ERROR);
                    response.setMessage("Pulse code already exists: " + data.getPulseCode());
                    return response;
                }
                PulseMaster entity = (PulseMaster)optional.get();
                entity.setGateway(data.getGateway());
                entity.setFromTime(DateFormatUtility.stringToLocalTime((String)data.getFromTime()));
                entity.setToTime(DateFormatUtility.stringToLocalTime((String)data.getToTime()));
                entity.setPulse(data.getPulse());
                entity.setPulseCode(data.getPulseCode());
                entity.setRange(data.getRange());
                entity.setRate(data.getRate());
                this.pulseMasterRepository.save((Object)entity);
                response.setStatus(Constants.Error.OK);
                response.setMessage("Pulse master record updated successfully");
            } else {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Pulse master record not found with ID: " + data.getId());
            }
        }
        catch (Exception e) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Failed to update pulse master: " + e.getMessage());
        }
        return response;
    }

    public RequestResponse deletePulseMasterById(InputIdModel id) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : id.getIntId()) {
            Optional record = this.pulseMasterRepository.findById((Object)ids);
            if (record.isPresent()) {
                addValue.add(record.get());
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.pulseMasterRepository.deleteAll(addValue);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Pulse master records deleted");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllPulseMasterByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = PulseMasterSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if ("asc".equalsIgnoreCase(searchRequestData.getSortDirection())) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy() == null || searchRequestData.getSortBy().isEmpty() ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if ("desc".equalsIgnoreCase(searchRequestData.getSortDirection())) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy() == null || searchRequestData.getSortBy().isEmpty() ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = sort == null ? this.pulseMasterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.pulseMasterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered PulseMaster Records");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<PulseMasterModel> entityToModelConversion(List<PulseMaster> pulseMasters) {
        ArrayList<PulseMasterModel> models = new ArrayList<PulseMasterModel>();
        if (pulseMasters == null || pulseMasters.isEmpty()) {
            return models;
        }
        for (PulseMaster pulseMaster : pulseMasters) {
            if (pulseMaster == null) continue;
            PulseMasterModel model = new PulseMasterModel();
            model.setId(pulseMaster.getId());
            model.setGateway(pulseMaster.getGateway());
            model.setFromTime(DateFormatUtility.localTimeToString((LocalTime)pulseMaster.getFromTime()));
            model.setToTime(DateFormatUtility.localTimeToString((LocalTime)pulseMaster.getToTime()));
            model.setPulse(pulseMaster.getPulse());
            model.setPulseCode(pulseMaster.getPulseCode());
            model.setRange(pulseMaster.getRange());
            model.setRate(pulseMaster.getRate());
            models.add(model);
        }
        return models;
    }
}

