/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.emailDetail.service;

import com.coraltele.db.telephony.pbx.entity.EmailDetail;
import com.coraltele.db.telephony.pbx.repository.EmailDetailRepository;
import com.coraltele.db.telephony.uc.entity.CustomerAccount;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.emailDetail.model.CustomEmailDetailModel;
import com.coraltele.service.pbx.sendfaxprogress.service.SendFaxProgressService;
import com.coraltele.service.uc.service.CustomerAccountService;
import com.coraltele.service.uc.service.VoicemailService;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class EmailDetailService {
    private static final Logger logger = LogManager.getLogger(EmailDetailService.class);
    @Autowired
    EmailDetailRepository emailDetailRepository;
    @Autowired
    CustomerAccountService customerAccountService;
    @Autowired
    SendFaxProgressService sendFaxProgressService;
    @Autowired
    VoicemailService voicemailService;
    String message = null;

    public RequestResponse getCustomData(CustomEmailDetailModel attachment, Authentication authentication) {
        logger.debug("Basic Details {}", (Object)attachment);
        RequestResponse returnValue = new RequestResponse();
        ArrayList<CustomEmailDetailModel> addValue = new ArrayList<CustomEmailDetailModel>();
        try {
            int lastIndex = attachment.getFilePath().lastIndexOf("/");
            String actualFile = attachment.getFilePath().substring(lastIndex + 1, attachment.getFilePath().length());
            CustomerAccount customAccount = this.customerAccountService.getCustomData(authentication);
            if (customAccount.getEmailId() == null) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Firstly Set Your EmailId ");
                return returnValue;
            }
            CustomEmailDetailModel dataToShow = CustomEmailDetailModel.builder().loggedUserEmail(customAccount.getEmailId()).subject(attachment.getSubject()).fileName(actualFile).filePath(attachment.getFilePath()).build();
            addValue.add(dataToShow);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Mail Id Returned Successfully: " + customAccount.getEmailId());
            returnValue.setData(addValue);
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return returnValue;
    }

    public RequestResponse createEmailDetail(CustomEmailDetailModel attachment, String fileId, String type, Authentication authentication) {
        logger.debug("Create EmailDetails {}", (Object)attachment);
        RequestResponse returnValue = new RequestResponse();
        ArrayList<String> toUser = new ArrayList<String>();
        String destinationUser = null;
        String destinationTo = null;
        String destinationBCc = "";
        String destinationCc = "";
        try {
            if (attachment.getTo().isEmpty()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Empty EmailId, ");
                returnValue.setMessageDetail("To Can Not Be Empty.");
                logger.error("To Can Not Be Empty: ");
                return returnValue;
            }
            for (String email : attachment.getTo()) {
                destinationTo = this.customerAccountService.getEmail(email);
                if (destinationTo == null || destinationTo.equals("")) {
                    this.message = MessageFormat.format(" Email Id => {0} Does Not Exist, ", email);
                    returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                    returnValue.setMessage(this.message);
                    returnValue.setMessageDetail("Kindly Enter Valid EmailId.");
                    logger.error(this.message);
                    continue;
                }
                toUser.add(this.customerAccountService.getProfileId(email));
            }
            if (!attachment.getCc().isEmpty()) {
                for (String cc : attachment.getCc()) {
                    destinationCc = this.customerAccountService.getEmail(cc);
                    if (destinationCc != null && !destinationCc.equals("")) continue;
                    this.message = MessageFormat.format(" Email Id => {0} Does Not Exist, ", cc);
                    returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                    returnValue.setMessage(this.message);
                    returnValue.setMessageDetail("Kindly Enter Valid EmailId.");
                    logger.error(this.message);
                }
            }
            if (!attachment.getBcc().isEmpty()) {
                for (String bcc : attachment.getBcc()) {
                    destinationBCc = this.customerAccountService.getEmail(bcc);
                    if (destinationBCc != null && !destinationBCc.equals("")) continue;
                    this.message = MessageFormat.format(" Email Id => {0} Does Not Exist, ", bcc);
                    returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                    returnValue.setMessage(this.message);
                    returnValue.setMessageDetail("Kindly Enter Valid EmailId.");
                    logger.error(this.message);
                }
            }
            String delimiter = ", ";
            destinationTo = String.join((CharSequence)delimiter, attachment.getTo());
            destinationCc = String.join((CharSequence)delimiter, attachment.getCc());
            destinationBCc = String.join((CharSequence)delimiter, attachment.getBcc());
            destinationUser = String.join((CharSequence)delimiter, toUser);
            EmailDetail data = EmailDetail.builder().isSent(Boolean.valueOf(false)).type(type).cli("").emailId(destinationTo).cidName("").location("").executionTime("").status("").uuid(fileId).codeType("").fromUser(authentication.getName()).toUser(destinationUser).emailCc(destinationCc).emailBcc(destinationBCc).attachmentPath(attachment.getFilePath()).attachmentName(attachment.getFileName()).participant("").accessCode("").conferencePassword("").mailSubject(attachment.getSubject()).remarks(attachment.getRemark()).createdTime(LocalDateTime.now()).build();
            this.emailDetailRepository.save((Object)data);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Mail Initiated Successfully, ");
            returnValue.setMessageDetail("To All Users.");
            logger.info(returnValue.getMessage() + returnValue.getMessageDetail());
        }
        catch (NullPointerException n) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Null Data Ocurred, ");
            returnValue.setMessageDetail(" Kindly Fullfil The Requirements.");
            logger.error(returnValue.getMessage() + returnValue.getMessageDetail());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return returnValue;
    }
}

