/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.hotel.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.hotel.model.AlarmDetailModel;
import com.coraltele.service.hotel.model.DirtyCleanModel;
import com.coraltele.service.hotel.model.HotelModel;
import com.coraltele.service.hotel.model.RoomShiftModel;
import com.coraltele.service.hotel.model.UpdateServiceModel;
import com.coraltele.service.hotel.model.ViewChannelsModel;
import com.coraltele.service.hotel.service.AlarmDetailService;
import com.coraltele.service.hotel.service.HotelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/hms"})
@RestController
public class HotelController {
    @Autowired
    private HotelService service;
    @Autowired
    private AlarmDetailService alarmDetailService;

    @PostMapping(value={"/checkIn"})
    public ResponseEntity<RequestResponse> checkIn(@RequestBody HotelModel data) {
        RequestResponse returnValue = this.service.checkedIn(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/tempCheckOut"})
    public ResponseEntity<RequestResponse> tempCheckOut(@RequestBody HotelModel data) {
        RequestResponse returnValue = this.service.tempCheckedOut(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/tempCheckIn"})
    public ResponseEntity<RequestResponse> tempCheckIn(@RequestBody HotelModel data) {
        RequestResponse returnValue = this.service.tempCheckedIn(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/checkOut"})
    public ResponseEntity<RequestResponse> checkedOut(@RequestBody HotelModel data) {
        RequestResponse returnValue = this.service.checkedOut(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateService(@RequestBody UpdateServiceModel data) {
        RequestResponse returnValue = this.service.updateByExtension(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/id"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody UpdateServiceModel data) {
        RequestResponse returnValue = this.service.updateById(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllExtensionView(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.service.getAllRoomExtension(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/roomShift"})
    public ResponseEntity<RequestResponse> roomShift(@RequestBody RoomShiftModel data) {
        RequestResponse returnValue = this.service.roomShift(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/alarm"})
    public ResponseEntity<RequestResponse> alarmProvEntity(@RequestBody AlarmDetailModel data) {
        RequestResponse returnValue = this.alarmDetailService.alarmProvision(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/cleanDirty"})
    public ResponseEntity<RequestResponse> dirtyClean(@RequestBody DirtyCleanModel data) {
        RequestResponse returnValue = this.service.dirtyCleanServices(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/cdr"})
    public ResponseEntity<RequestResponse> getByBillingUuId(@RequestBody ViewChannelsModel billingUuid) {
        RequestResponse returnValue = this.service.getByBillingUuid(billingUuid);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

