/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.pbx.service;

import com.coraltele.db.coralapps.callcenter.entity.Queue;
import com.coraltele.db.coralapps.callcenter.repository.QueueRepository;
import com.coraltele.db.coralapps.pbx.repository.CDRRepository;
import com.coraltele.db.coralapps.pbx.view.CDR;
import com.coraltele.db.telephony.pbx.entity.GatewayMaster;
import com.coraltele.db.telephony.pbx.repository.GatewayMasterRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.helper.Telephony;
import com.coraltele.service.coralApps.pbx.model.CDRModel;
import com.coraltele.service.coralApps.pbx.model.CDRRequestModel;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CDRService {
    private static final Logger logger = LogManager.getLogger(CDRService.class);
    @Autowired
    CDRRepository cdrRepository;
    @Autowired
    QueueRepository queueRepository;
    @Autowired
    GatewayMasterRepository gatewayMasterRepository;

    public RequestResponse getAbandonedCall(CDRRequestModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            ArrayList<CDRModel> result = new ArrayList<CDRModel>();
            List records = this.cdrRepository.findByStartStampBetweenAndDurationGreaterThanAndHangupCauseNotAndTalkTimeEquals(data.getFromTime(), data.getToTime(), Integer.valueOf(0), "ATTENDED_TRANSFER", null);
            for (CDR row : records) {
                CDRModel currentRow = new CDRModel();
                currentRow.setDialNumber(row.getCallerIdNumber());
                currentRow.setId(row.getId());
                currentRow.setQueueName(row.getSystemName());
                currentRow.setQueueDescription(row.getQueueName());
                currentRow.setConnectingNumber(row.getDestinationNumber());
                currentRow.setCallStatus("Abandoned");
                result.add(currentRow);
            }
            logger.info("data fetched successfully for CDR");
            returnValue.setData(result);
            returnValue.setMessage("Data Fetch Successfully");
        }
        catch (Exception e) {
            logger.error("Error" + e.getMessage());
            returnValue.setMessage("Error while fetching records");
            returnValue.setMessageDetail("Something went wrong");
        }
        return returnValue;
    }

    public RequestResponse clickToCall(CDRModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            String queueCallerID = this.getQueueCallerID(data);
            String callerNumber = data.getDialNumber();
            String sgwip = this.getIpFeatureServer();
            String queueSystemName = data.getQueueName();
            String destinationNumber = data.getConnectingNumber();
            if (data.getDialNumber().isEmpty()) {
                logger.error("data is empty", (Object)data);
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Unable to make call due to inValid data");
                return returnValue;
            }
            if (StringUtils.hasLength((String)callerNumber) && StringUtils.hasLength((String)queueSystemName) && !StringUtils.hasLength((String)destinationNumber)) {
                logger.info("data required for making call is: queueCallerID:{},Number:{},sgwip:{},queueSystemName:{}", (Object)queueCallerID, (Object)callerNumber, (Object)sgwip, (Object)queueSystemName);
                String command = String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,sip_h_X-APICALL=Click2Call,origination_caller_id_number=%s}sofia/internal/%s@%s &callcenter(%s)\"", queueCallerID, callerNumber, sgwip, queueSystemName);
                logger.info("command to execute call is:::{}", (Object)command);
                Telephony.makeCallBackCall((String)command);
            } else if (StringUtils.hasLength((String)callerNumber) && StringUtils.hasLength((String)destinationNumber)) {
                if (StringUtils.hasLength((String)queueSystemName)) {
                    logger.info("data required for making call is: queueCallerID:{},Number:{},queueSystemName:{},destinationNumber:{}", (Object)queueCallerID, (Object)callerNumber, (Object)queueSystemName, (Object)destinationNumber);
                    String gatewayCode = this.getGatewayCode(queueSystemName);
                    logger.info("Gateway Code is:{}", (Object)gatewayCode);
                    if (StringUtils.hasLength((String)gatewayCode)) {
                        String command = String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,sip_h_X-APICALL=Click2Call,origination_caller_id_number=%s,sip_h_X-PREFERGATEWAY=%s}sofia/internal/%s@%s %s XML calltransfer\"", destinationNumber, gatewayCode, callerNumber, sgwip, destinationNumber);
                        logger.info("command to execute call is:::{}", (Object)command);
                        Telephony.makeCallBackCall((String)command);
                    } else {
                        String command = String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,sip_h_X-APICALL=Click2Call,origination_caller_id_number=%s}sofia/internal/%s@%s %s XML calltransfer\"", destinationNumber, callerNumber, sgwip, destinationNumber);
                        logger.info("command to execute call is:::{}", (Object)command);
                        Telephony.makeCallBackCall((String)command);
                    }
                } else {
                    logger.info("data required for making call is: queueCallerID:{},CallerNumber:{},destinationNumber:{}", (Object)queueCallerID, (Object)callerNumber, (Object)destinationNumber);
                    String command = String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,sip_h_X-APICALL=Click2Call,origination_caller_id_number=%s}sofia/internal/%s@%s %s XML calltransfer\"", destinationNumber, callerNumber, sgwip, destinationNumber);
                    logger.info("command to execute call is:::{}", (Object)command);
                    Telephony.makeCallBackCall((String)command);
                }
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Call execute successfully");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error during call initiation:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable");
        }
        return returnValue;
    }

    public String getQueueCallerID(CDRModel data) {
        Optional queueData = this.queueRepository.findBySystemName(data.getQueueName());
        String number = "";
        if (queueData.isPresent() && ((number = ((Queue)queueData.get()).getCliDialOut()) == null || number.isEmpty())) {
            number = "0000";
        }
        return number;
    }

    public String getIpProxyServer() {
        if (StringUtils.hasText((String)Constants.DISPATCHER_CALL_IP)) {
            return Constants.DISPATCHER_CALL_IP;
        }
        String coralFilePath = "/etc/default/coral";
        String ipFeatureServer = "";
        try {
            Profile.Section cscfSection;
            Ini ini;
            File file = new File(coralFilePath);
            if (file.exists() && (ini = new Ini(file)).containsKey((Object)"CSCF-1") && (cscfSection = (Profile.Section)ini.get((Object)"CSCF-1")).containsKey((Object)"IP-FEATURE-SERVER")) {
                ipFeatureServer = (String)cscfSection.get((Object)"IP-FEATURE-SERVER");
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return ipFeatureServer;
    }

    public String getIpFeatureServer() {
        String coralFilePath = "/etc/default/coral";
        String ipFeatureServer = "";
        try {
            Profile.Section cscfSection;
            Ini ini;
            File file = new File(coralFilePath);
            if (file.exists() && (ini = new Ini(file)).containsKey((Object)"CSCF-1") && (cscfSection = (Profile.Section)ini.get((Object)"CSCF-1")).containsKey((Object)"IP-FEATURE-SERVER")) {
                ipFeatureServer = (String)cscfSection.get((Object)"IP-FEATURE-SERVER");
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return ipFeatureServer;
    }

    public String getGatewayCode(String queueName) {
        return this.queueRepository.findBySystemName(queueName).map(Queue::getGatewayId).flatMap(arg_0 -> ((GatewayMasterRepository)this.gatewayMasterRepository).findById(arg_0)).map(GatewayMaster::getGwCode).orElse("");
    }
}

