/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.complaint.CallDispositionQueueView.service;

import com.coraltele.db.coralapps.callcenter.entity.view.CallDispositionQueueNew;
import com.coraltele.db.coralapps.callcenter.repository.CallDispositionQueueRepository;
import com.coraltele.db.coralapps.callcenter.specification.CallDispositionQueueSpecification;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.complaint.CallDispositionQueueView.model.CallDispositionQueueModel;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.user.service.UserService;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class CallDispositionQueueService {
    private static final Logger logger = LogManager.getLogger(CallDispositionQueueService.class);
    @Autowired
    CallDispositionQueueRepository callDispositionQueueRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;

    public RequestResponse getAllCallDispositionQueue(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        boolean teamLeaderUser = false;
        boolean adminUser = false;
        boolean managerUser = false;
        if (this.userService.checkRoleTL(principal.getName())) {
            teamLeaderUser = true;
        }
        List queueId = null;
        if (teamLeaderUser) {
            queueId = this.queueTLService.getQueueListByTeamLeaderInt(principal.getName());
        } else if (this.userService.checkManagerUser(principal.getName())) {
            managerUser = true;
        } else if (this.userService.checkAdminUser(principal.getName())) {
            adminUser = true;
        }
        Specification filters = CallDispositionQueueSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, (boolean)adminUser, (boolean)managerUser, (List)queueId);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "recordCreatedOn" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "recordCreatedOn" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.callDispositionQueueRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.callDispositionQueueRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<CallDispositionQueueModel> entityToModelConversion(List<CallDispositionQueueNew> callDispositionQueues) {
        ArrayList<CallDispositionQueueModel> addValue = new ArrayList<CallDispositionQueueModel>();
        for (CallDispositionQueueNew row : callDispositionQueues) {
            CallDispositionQueueModel data = new CallDispositionQueueModel();
            Optional user = this.userRepository.findByUsername(row.getAgentId());
            data.setAgentId(row.getAgentId());
            if (user.isPresent()) {
                data.setAgentName(((User)user.get()).getDescription());
            } else {
                data.setAgentName("");
            }
            data.setCustomerStatus(row.getCustomerStatus());
            data.setCustomerStatus(row.getCustomerStatus());
            data.setPhoneNumber(row.getPhoneNumber());
            data.setQueueId(row.getQueueId());
            data.setQueueName(row.getQueueName());
            data.setRecordCreatedOn(row.getRecordCreatedOn());
            data.setRecordLastModifiedOn(row.getRecordLastModifiedOn());
            addValue.add(data);
        }
        return addValue;
    }
}

