/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.main.voiceLogger.service;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.entity.VoiceLogger;
import com.coraltele.db.billing.main.entity.view.VoiceLoggerView;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.coraltele.db.billing.main.repository.VoiceLoggerRepository;
import com.coraltele.db.billing.main.repository.VoiceLoggerRepositoryView;
import com.coraltele.db.billing.main.specification.VoiceLoggerViewSpecification;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.helper.BashCmd;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.billing.main.voiceLogger.model.VoiceLoggerDeleteModel;
import com.coraltele.service.billing.main.voiceLogger.model.VoiceLoggerModel;
import com.coraltele.service.billing.main.voiceLogger.model.VoiceLoggerZipModel;
import java.io.BufferedWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class VoiceLoggerService {
    private ExecutorService executorService = Executors.newFixedThreadPool(5);
    private static final Logger logger = LogManager.getLogger(VoiceLoggerService.class);
    private static final String BACKUP_STATUS_IN_PROGRESS = "in progress";
    private static final String BACKUP_STATUS_SUCCESS = "success";
    private static final String BACKUP_STATUS_FAILURE = "failure";
    private static final double TAR_OVERHEAD_FACTOR = 1.02;
    private static final double TEMP_SPACE_FACTOR = 1.5;
    private static final String DEFAULT_FOLDER_PATTERN = "/backup/yyyy/MM/dd";
    @Autowired
    VoiceLoggerRepositoryView repository;
    @Autowired
    BashCmd executer;
    @Autowired
    PdfReportRepository pdfReportRepository;
    @Autowired
    VoiceLoggerRepository voiceLoggerRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Value(value="${freeSpace.size}")
    private Integer freeSpace;
    private static final String tmpFolder = "/tmp/";
    private static final String txtFile = "backupFile.txt";
    private static final String backupFilePath = "/mnt/backupfiles/";

    public RequestResponse getVoiceLogger(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = VoiceLoggerViewSpecification.generateFilters((SearchRequest)searchRequestData, (Principal)principal);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.repository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.repository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getVoiceLoggerRecordingTypeList() {
        RequestResponse returnValue = new RequestResponse();
        List types = this.voiceLoggerRepository.findDistinctRecordingFileTypes();
        ArrayList formattedList = new ArrayList();
        if (types != null) {
            for (String t : types) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("recordingType", t);
                formattedList.add(map);
            }
        }
        returnValue.setData(formattedList);
        returnValue.setMessage("List of Recording File Types");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<VoiceLoggerModel> entityToModelConversion(List<VoiceLoggerView> report) {
        ArrayList<VoiceLoggerModel> addValue = new ArrayList<VoiceLoggerModel>();
        for (VoiceLoggerView row : report) {
            VoiceLoggerModel data = new VoiceLoggerModel();
            data.setId(row.getId());
            if (row.getStartTime() != null) {
                data.setStartTime(DateFormatUtility.epochToLocalDateTimeAsStringToHandleNull((Long)row.getStartTime()));
            }
            data.setLocation(row.getLocation());
            data.setDirection(row.getDirection());
            data.setCoralApp(row.getCoralApp());
            data.setCallerName(row.getCallerName());
            data.setDestName(row.getDestName());
            if (row.getAnswerTime() != null) {
                data.setAnswerTime(DateFormatUtility.epochToLocalDateTimeAsStringToHandleNull((Long)row.getAnswerTime()));
            }
            if (row.getEndTime() != null) {
                data.setEndTime(DateFormatUtility.epochToLocalDateTimeAsStringToHandleNull((Long)row.getEndTime()));
            }
            data.setDuration(row.getDuration());
            data.setBillsec(row.getBillsec());
            if (row.getFileTime() != null) {
                data.setFileTime(DateFormatUtility.epochToLocalDateTimeAsStringToHandleNull((Long)row.getFileTime()));
            }
            data.setCallerIdNumber(row.getCallerIdNumber());
            data.setDestinationNumber(row.getDestinationNumber());
            data.setRecordFilename(row.getRecordFilename());
            data.setStatus(row.getStatus());
            if (row.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                data.setMos(BigDecimal.valueOf(4.3));
            } else {
                data.setMos(row.getMos());
            }
            data.setRtpJitterMinVariance(row.getRtpJitterMinVariance());
            data.setRtpJitterMaxVariance(row.getRtpJitterMaxVariance());
            data.setRtpJitterLossRate(row.getRtpJitterLossRate());
            addValue.add(data);
        }
        return addValue;
    }

    public String generateArchiveFilename(VoiceLogger voiceLogger, Boolean includeFolderName) {
        String recordFilename = voiceLogger.getRecordFilename();
        String fileExtension = "wav";
        if (recordFilename != null && recordFilename.contains(".")) {
            fileExtension = recordFilename.substring(recordFilename.lastIndexOf(".") + 1);
        }
        Boolean isCallerExtension = this.extensionsRepository.findByExtension(voiceLogger.getCallerIdNumber()).isPresent();
        Boolean isDestinationExtension = this.extensionsRepository.findByExtension(voiceLogger.getDestinationNumber()).isPresent();
        String extension = "";
        extension = isCallerExtension != false ? voiceLogger.getCallerIdNumber() : (isDestinationExtension != false ? voiceLogger.getDestinationNumber() : voiceLogger.getCallerIdNumber());
        String pathFormat = "";
        pathFormat = includeFolderName != false ? (StringUtils.hasText((String)Constants.RECORDING_FOLDERNAME_FORMAT) ? Constants.RECORDING_FOLDERNAME_FORMAT : "/backup/{yyyy}/{MM}/{dd}/{extension}/{direction}") + "/" : "";
        pathFormat = pathFormat + (StringUtils.hasText((String)Constants.RECORDING_FILENAME_FORMAT) ? Constants.RECORDING_FILENAME_FORMAT : "{callerIdNumber}-{destinationNumber}-{queueName}-{agent}-{timestamp}_{direction}");
        ZonedDateTime zonedDateTime = voiceLogger.getStartTime() != null ? Instant.ofEpochSecond(voiceLogger.getStartTime()).atZone(ZoneId.of("Asia/Kolkata")) : ZonedDateTime.now(ZoneId.of("Asia/Kolkata"));
        String timestamp = zonedDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss"));
        String queueName = StringUtils.hasText((String)voiceLogger.getQueueName()) ? voiceLogger.getQueueName().trim() : (StringUtils.hasText((String)voiceLogger.getQueue()) ? voiceLogger.getQueue().trim() : "");
        queueName = queueName.trim().replace(" ", "_");
        String fullPath = pathFormat.replace("{yyyy}", zonedDateTime.format(DateTimeFormatter.ofPattern("yyyy"))).replace("{yy}", zonedDateTime.format(DateTimeFormatter.ofPattern("yy"))).replace("{MM}", zonedDateTime.format(DateTimeFormatter.ofPattern("MM"))).replace("{dd}", zonedDateTime.format(DateTimeFormatter.ofPattern("dd"))).replace("{HH}", zonedDateTime.format(DateTimeFormatter.ofPattern("HH"))).replace("{mm}", zonedDateTime.format(DateTimeFormatter.ofPattern("mm"))).replace("{ss}", zonedDateTime.format(DateTimeFormatter.ofPattern("ss"))).replace("{extension}", extension).replace("{callerIdNumber}", voiceLogger.getCallerIdNumber()).replace("{destinationNumber}", voiceLogger.getDestinationNumber()).replace("{queueName}", StringUtils.hasText((String)queueName) ? queueName : "").replace("{queueCode}", StringUtils.hasText((String)voiceLogger.getQueue()) ? voiceLogger.getQueue() : "").replace("{agent}", StringUtils.hasText((String)voiceLogger.getAgentName()) ? voiceLogger.getAgentName() : "").replace("{timestamp}", timestamp).replace("{direction}", voiceLogger.getDirection()) + "-" + voiceLogger.getId();
        CharSequence[] pathParts = fullPath.split("/");
        for (int i = 0; i < pathParts.length; ++i) {
            if (pathParts[i].isEmpty()) continue;
            pathParts[i] = this.sanitize((String)pathParts[i]);
        }
        fullPath = String.join((CharSequence)"/", pathParts);
        while (fullPath.contains("--")) {
            fullPath = fullPath.replace("--", "-");
        }
        return fullPath + "." + fileExtension;
    }

    public String sanitize(String input) {
        if (input == null || input.isEmpty()) {
            return "unknown";
        }
        return input.replaceAll("[^a-zA-Z0-9._-]", "_");
    }

    private long calculateRequiredSpace(long fileSizes) {
        long tarSize = (long)((double)fileSizes * 1.02);
        long tempFileSize = 0x100000L;
        long totalRequired = (long)((double)(tarSize + tempFileSize) * 1.5);
        logger.debug("Space calculation - Files: {} bytes, TAR (with overhead): {} bytes, Total required: {} bytes", (Object)fileSizes, (Object)tarSize, (Object)totalRequired);
        return totalRequired;
    }

    private boolean verifyTarArchive(String tarFilePath, int expectedFileCount) {
        logger.info("Verifying tar archive: {}", (Object)tarFilePath);
        logger.info("Expected file count: {}", (Object)expectedFileCount);
        try {
            String verifyCommand = String.format("tar -tf %s > /dev/null 2>&1; echo $?", tarFilePath);
            String exitCode = this.executer.executeCommand(verifyCommand);
            if (!exitCode.trim().startsWith("0")) {
                logger.error("TAR integrity check failed with exit code: {}", (Object)exitCode);
                return false;
            }
            String countCommand = String.format("tar -tf %s | grep -v '/$' | wc -l", tarFilePath);
            String countResult = this.executer.executeCommand(countCommand);
            int actualFileCount = Integer.parseInt(countResult.trim());
            logger.info("Actual file count in archive: {}", (Object)actualFileCount);
            if (actualFileCount != expectedFileCount) {
                logger.error("File count mismatch! Expected: {}, Actual: {}", (Object)expectedFileCount, (Object)actualFileCount);
                return false;
            }
            logger.info("Archive verification successful - all {} files present", (Object)actualFileCount);
            return true;
        }
        catch (Exception e) {
            logger.error("Error during archive verification", (Throwable)e);
            return false;
        }
    }

    private void createTextFile(List<String> recordFilenames) throws IOException {
        Path textFilePath = Paths.get(tmpFolder, txtFile);
        if (!Files.exists(textFilePath.getParent(), new LinkOption[0])) {
            Files.createDirectories(textFilePath.getParent(), new FileAttribute[0]);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(textFilePath, new OpenOption[0]);){
            for (String filename : recordFilenames) {
                writer.write(filename);
                writer.newLine();
            }
        }
    }

    public RequestResponse createBackupFile(VoiceLoggerZipModel data, List<VoiceLogger> selectedData) {
        RequestResponse returnValue = new RequestResponse();
        String tarFilePath = backupFilePath + data.getBackupFilename() + ".tar";
        try {
            Long totalFileSize = 0L;
            ArrayList<String> validFileList = new ArrayList<String>();
            ArrayList<VoiceLogger> validVoiceLoggers = new ArrayList<VoiceLogger>();
            ArrayList<String> validFileId = new ArrayList<String>();
            int totalFiles = selectedData.size();
            int existingFiles = 0;
            logger.info("Starting backup validation for {} files", (Object)totalFiles);
            for (VoiceLogger voiceLogger : selectedData) {
                String recordFilename = voiceLogger.getRecordFilename();
                if (recordFilename != null && !recordFilename.isEmpty()) {
                    Path filePath = Paths.get(recordFilename, new String[0]);
                    if (Files.exists(filePath, new LinkOption[0])) {
                        validFileList.add(recordFilename);
                        validVoiceLoggers.add(voiceLogger);
                        validFileId.add(voiceLogger.getId());
                        ++existingFiles;
                        long fileSize = Files.size(filePath);
                        totalFileSize = totalFileSize + fileSize;
                        voiceLogger.setIsFileExist(Boolean.valueOf(true));
                        this.voiceLoggerRepository.save((Object)voiceLogger);
                        continue;
                    }
                    logger.warn("File not found: {}", (Object)recordFilename);
                    voiceLogger.setIsFileExist(Boolean.valueOf(false));
                    this.voiceLoggerRepository.save((Object)voiceLogger);
                    continue;
                }
                voiceLogger.setIsFileExist(Boolean.valueOf(false));
                this.voiceLoggerRepository.save((Object)voiceLogger);
            }
            if (existingFiles == 0) {
                logger.error("No valid files found for backup");
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No valid files for backup");
                returnValue.setMessageDetail("All files are missing or invalid");
                this.updateBackupStatus(returnValue, data);
                return returnValue;
            }
            logger.info("Validation complete - Total files: {}, Existing: {}, Missing: {}", (Object)totalFiles, (Object)existingFiles, (Object)(totalFiles - existingFiles));
            logger.info("Total file size: {} bytes ({} MB)", (Object)totalFileSize, (Object)(totalFileSize / 0x100000L));
            FileStore fileStore = Files.getFileStore(Paths.get(backupFilePath, new String[0]));
            long usableSpace = fileStore.getUsableSpace();
            long requiredSpace = this.calculateRequiredSpace(totalFileSize.longValue());
            double usableSpaceMB = (double)usableSpace / 1048576.0;
            double requiredSpaceMB = (double)requiredSpace / 1048576.0;
            logger.info("Space check - Available: {:.2f} MB, Required: {:.2f} MB", (Object)usableSpaceMB, (Object)requiredSpaceMB);
            if (usableSpace < requiredSpace) {
                logger.error("Insufficient disk space! Available: {:.2f} MB, Required: {:.2f} MB", (Object)usableSpaceMB, (Object)requiredSpaceMB);
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Insufficient disk space for backup");
                returnValue.setMessageDetail(String.format("Required: %.2f MB, Available: %.2f MB", requiredSpaceMB, usableSpaceMB));
                this.updateBackupStatus(returnValue, data);
                return returnValue;
            }
            this.createTextFile(validFileList);
            logger.info("File list created at: {}", (Object)"/tmp/backupFile.txt");
            String folderPattern = StringUtils.hasText((String)Constants.RECORDING_FOLDERNAME_FORMAT) ? Constants.RECORDING_FOLDERNAME_FORMAT : DEFAULT_FOLDER_PATTERN;
            logger.info("Creating tar archive with folder structure '{}' and renamed files: {}", (Object)folderPattern, (Object)tarFilePath);
            Path stagingDir = Paths.get(tmpFolder, "backup_staging", data.getStatusId());
            Files.createDirectories(stagingDir, new FileAttribute[0]);
            logger.info("Created staging directory: {}", (Object)stagingDir);
            Path mappingFile = Paths.get(tmpFolder, "filename_mapping.txt");
            try (BufferedWriter writer = Files.newBufferedWriter(mappingFile, new OpenOption[0]);){
                writer.write("# Backup File Mapping\n");
                writer.write("# Folder Pattern: " + folderPattern + "\n");
                writer.write("# Format: Original Path => Archive Path\n\n");
                for (int i = 0; i < validFileList.size(); ++i) {
                    String originalPath = (String)validFileList.get(i);
                    VoiceLogger voiceLogger = (VoiceLogger)validVoiceLoggers.get(i);
                    String archivePath = this.generateArchiveFilename(voiceLogger, Boolean.valueOf(true));
                    String relativeArchivePath = archivePath.startsWith("/") ? archivePath.substring(1) : archivePath;
                    Path linkPath = stagingDir.resolve(relativeArchivePath);
                    Files.createDirectories(linkPath.getParent(), new FileAttribute[0]);
                    Path originalFilePath = Paths.get(originalPath, new String[0]);
                    Files.createSymbolicLink(linkPath, originalFilePath, new FileAttribute[0]);
                    writer.write(originalPath + " => " + archivePath);
                    writer.newLine();
                }
            }
            logger.info("Created {} symbolic links in staging directory", (Object)existingFiles);
            logger.info("Created file mapping at: {}", (Object)mappingFile);
            String tarCommand = String.format("tar -chvf %s -C %s .", tarFilePath, stagingDir.toString());
            logger.info("Executing tar command (file count: {})", (Object)existingFiles);
            logger.debug("TAR command: {}", (Object)tarCommand);
            this.executer.executeCommand(tarCommand);
            logger.debug("TAR execution completed");
            logger.info("Cleaning up staging directory...");
            String cleanupCommand = String.format("rm -rf %s", stagingDir.toString());
            this.executer.executeCommand(cleanupCommand);
            logger.info("Staging directory cleaned up");
            logger.info("Verifying tar archive...");
            boolean verificationPassed = this.verifyTarArchive(tarFilePath, existingFiles);
            if (!verificationPassed) {
                logger.error("Archive verification failed!");
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Backup archive verification failed");
                returnValue.setMessageDetail("Not all files were added to archive correctly");
                this.updateBackupStatus(returnValue, data);
                try {
                    Files.deleteIfExists(Paths.get(tarFilePath, new String[0]));
                    logger.info("Cleaned up failed archive file");
                }
                catch (IOException e) {
                    logger.warn("Failed to clean up archive file: {}", (Object)e.getMessage());
                }
                return returnValue;
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Backup completed successfully");
            returnValue.setMessageDetail(String.format("Backed up %d files (%.2f MB)", existingFiles, (double)totalFileSize.longValue() / 1048576.0));
            logger.info("Backup successful: {}", (Object)returnValue.getMessageDetail());
            this.updateBackupStatus(returnValue, data);
            if (Boolean.TRUE.equals(data.getIsDelete())) {
                logger.info("Deleting original files after successful backup...");
                String deleteCommand = String.format("xargs rm < %s", "/tmp/backupFile.txt");
                this.executer.executeCommand(deleteCommand);
                String commandToVerifyStatus = "echo $?";
                String deleteExitCode = this.executer.executeCommand(commandToVerifyStatus);
                if (deleteExitCode.trim().startsWith("0")) {
                    logger.info("Successfully deleted {} original files", (Object)existingFiles);
                    for (String id : validFileId) {
                        this.voiceLoggerRepository.updateStatusD("D", id);
                    }
                    logger.info("Updated {} records with delete status", (Object)validFileId.size());
                } else {
                    logger.error("Error occurred while deleting original files");
                }
            } else {
                logger.info("Updating records with backup path...");
                for (String id : validFileId) {
                    this.voiceLoggerRepository.updateStatusB(tarFilePath, "B", id);
                }
                logger.info("Updated {} records with backup status", (Object)validFileId.size());
            }
            return returnValue;
        }
        catch (Exception e) {
            logger.error("Error during backup process", (Throwable)e);
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error while creating backup");
            returnValue.setMessageDetail(e.getMessage());
            this.updateBackupStatus(returnValue, data);
            return returnValue;
        }
    }

    public RequestResponse createBackupFileAsync(VoiceLoggerZipModel data) {
        RequestResponse returnValue = new RequestResponse();
        Long from = DateFormatUtility.convertToEpochSeconds((LocalDateTime)data.getFrom());
        Long to = DateFormatUtility.convertToEpochSeconds((LocalDateTime)data.getTo()) + 59L;
        String fromCallerIdNumber = data.getFromCallerIdNumber();
        String toCallerIdNumber = data.getToCallerIdNumber();
        String fromDestinationNumber = data.getFromDestinationNumber();
        String toDestinationNumber = data.getToDestinationNumber();
        logger.info("Fetching recordings from {} to {}", (Object)from, (Object)to);
        List listOfRecording = this.voiceLoggerRepository.findByStartTimeBetween(from, to);
        if (fromCallerIdNumber != null && toCallerIdNumber != null) {
            listOfRecording.removeIf(v -> {
                String callerId = v.getCallerIdNumber();
                return callerId == null || callerId.compareTo(fromCallerIdNumber) < 0 || callerId.compareTo(toCallerIdNumber) > 0;
            });
        }
        if (fromDestinationNumber != null && toDestinationNumber != null) {
            listOfRecording.removeIf(v -> {
                String destNumber = v.getDestinationNumber();
                return destNumber == null || destNumber.compareTo(fromDestinationNumber) < 0 || destNumber.compareTo(toDestinationNumber) > 0;
            });
        }
        logger.info("Number of records after filtering: {}", (Object)listOfRecording.size());
        listOfRecording.removeIf(v -> {
            String recordFilename = v.getRecordFilename();
            return recordFilename == null || recordFilename.isEmpty() || !Files.exists(Paths.get(recordFilename, new String[0]), new LinkOption[0]);
        });
        if (listOfRecording.isEmpty()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("No recordings found");
            returnValue.setMessageDetail("Selected date range and filters have no matching recordings");
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Backup started");
        returnValue.setMessageDetail(String.format("Processing %d recordings", listOfRecording.size()));
        String uuid = UUID.randomUUID().toString();
        logger.info("Backup job ID: {}", (Object)uuid);
        data.setStatusId(uuid);
        PdfReportFilters pdfReportFilters = new PdfReportFilters();
        pdfReportFilters.setId(data.getStatusId());
        pdfReportFilters.setCreatedOnDate(LocalDateTime.now());
        pdfReportFilters.setPdfLocation(backupFilePath + data.getBackupFilename() + ".tar");
        pdfReportFilters.setReportName("Voice Logger");
        pdfReportFilters.setStatus(BACKUP_STATUS_IN_PROGRESS);
        pdfReportFilters.setStartEpoch(Long.valueOf(System.currentTimeMillis() / 1000L));
        this.pdfReportRepository.save((Object)pdfReportFilters);
        this.executorService.submit(() -> {
            try {
                logger.info("Starting async backup job: {}", (Object)uuid);
                RequestResponse response = this.createBackupFile(data, listOfRecording);
                this.updateBackupStatus(response, data);
                logger.info("Backup job {} completed with status: {}", (Object)uuid, (Object)response.getStatus());
            }
            catch (Exception e) {
                logger.error("Backup job {} failed with exception", (Object)uuid, (Object)e);
                RequestResponse errorResponse = new RequestResponse();
                errorResponse.setStatus(Constants.Error.ERROR);
                errorResponse.setMessage("Data backup failed");
                errorResponse.setMessageDetail(e.getMessage());
                this.updateBackupStatus(errorResponse, data);
            }
        });
        return returnValue;
    }

    public void updateBackupStatus(RequestResponse response, VoiceLoggerZipModel data) {
        String status = response.getStatus() == Constants.Error.OK ? BACKUP_STATUS_SUCCESS : BACKUP_STATUS_FAILURE;
        Optional pdfReportOptional = this.pdfReportRepository.findById((Object)data.getStatusId());
        if (pdfReportOptional.isPresent()) {
            PdfReportFilters pdfReportFilters = (PdfReportFilters)pdfReportOptional.get();
            pdfReportFilters.setStatus(status);
            pdfReportFilters.setEndEpoch(Long.valueOf(System.currentTimeMillis() / 1000L));
            this.pdfReportRepository.save((Object)pdfReportFilters);
            logger.info("Updated backup status for job {} to: {}", (Object)data.getStatusId(), (Object)status);
        } else {
            logger.warn("Could not find backup tracking record for job: {}", (Object)data.getStatusId());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void shutdownExecutorService() {
        this.executorService.shutdown();
        try {
            if (this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) return;
            this.executorService.shutdownNow();
            if (this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) return;
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public RequestResponse deleteFiles(VoiceLoggerDeleteModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Integer existingFile = 0;
            ArrayList<String> validFileList = new ArrayList<String>();
            ArrayList<String> validFileId = new ArrayList<String>();
            for (String id : data.getId()) {
                Path filePath;
                Optional voiceOptional = this.voiceLoggerRepository.findById((Object)id);
                if (!voiceOptional.isPresent() || !Files.exists(filePath = Paths.get(((VoiceLogger)voiceOptional.get()).getRecordFilename(), new String[0]), new LinkOption[0])) continue;
                validFileList.add(((VoiceLogger)voiceOptional.get()).getRecordFilename());
                validFileId.add(((VoiceLogger)voiceOptional.get()).getId());
                Integer n = existingFile;
                Integer n2 = existingFile = Integer.valueOf(existingFile + 1);
            }
            this.createTextFile(validFileList);
            String deleteCommand = String.format("xargs rm -rf < %s", "/tmp/backupFile.txt");
            String status = this.executer.executeCommand(deleteCommand);
            String commandToVerifyStatus = String.format("echo $?", new Object[0]);
            String exitCode = this.executer.executeCommand(commandToVerifyStatus);
            if (exitCode.startsWith("0")) {
                for (String id : data.getId()) {
                    Optional info = this.voiceLoggerRepository.findById((Object)id);
                    if (!info.isPresent()) continue;
                    ((VoiceLogger)info.get()).setStatus("D");
                    this.voiceLoggerRepository.save(info.get());
                }
                logger.info("Files deleted successfully");
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Files deleted successfully");
            } else {
                logger.error("Error occurred while deleting files");
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Error occurred while deleting files");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public String getFile(String id) {
        Optional list = this.voiceLoggerRepository.findById((Object)id);
        if (list.isPresent()) {
            return ((VoiceLogger)list.get()).getRecordFilename();
        }
        return null;
    }

    public String getRecordingFileType(String id) {
        Optional list = this.voiceLoggerRepository.findById((Object)id);
        if (list.isPresent()) {
            return ((VoiceLogger)list.get()).getRecordingFileType();
        }
        return null;
    }
}

