/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.userRouteShift.userShift.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.user.userRouteShift.userShift.model.RouteServiceModel3;
import com.coraltele.service.user.userRouteShift.userShift.model.UserShiftModel;
import com.coraltele.service.user.userRouteShift.userShift.service.UserShiftService;
import java.security.Principal;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/v2/userShift"})
public class UserShiftController {
    @Autowired
    UserShiftService userShiftService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createShift(@RequestBody UserShiftModel userShiftModel, Principal principal) {
        RequestResponse returnValue = this.userShiftService.createUserShift(userShiftModel, principal);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAllShift() {
        RequestResponse returnValue = this.userShiftService.getAllUserShift();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateShift(@RequestBody UserShiftModel userShiftModel, Principal principal) {
        RequestResponse returnValue = this.userShiftService.updateUserShift(userShiftModel, principal);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteShift(@RequestBody InputIdModel id, Principal principal) {
        RequestResponse returnValue = this.userShiftService.deleteUserShift(id, principal);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/user/{username}"})
    public ResponseEntity<RequestResponse> getUserData(@PathVariable(value="username") String username, Principal principal) {
        RequestResponse returnValue = this.userShiftService.getLoggedUserShift(username, principal, true);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/loggedUserInfo"})
    public ResponseEntity<RequestResponse> getLoggedUserData(Principal principal) {
        RequestResponse returnValue = this.userShiftService.getLoggedUserShift("", principal, false);
        return returnValue.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)returnValue) : new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.userShiftService.getAllByFilter(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/routeFilter"})
    public ResponseEntity<RequestResponse> getFilterList(@RequestBody RouteServiceModel3 routeServiceModel) {
        RequestResponse returnValue = this.userShiftService.getFilterList(routeServiceModel);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/unAssignRoute"})
    public ResponseEntity<RequestResponse> unAssignRoute(@RequestBody UserShiftModel username) {
        RequestResponse returnValue = this.userShiftService.unAssignRoute(username);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/unAssignZone"})
    public ResponseEntity<RequestResponse> unAssignZone(@RequestBody UserShiftModel username) {
        RequestResponse returnValue = this.userShiftService.unAssignZone(username);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @Generated
    public UserShiftController() {
    }
}

