/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.userLocation.service;

import com.coraltele.db.users.main.entity.UserLocation;
import com.coraltele.db.users.main.repository.UserLocationRepository;
import com.coraltele.db.users.main.specification.UserLocationSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.coralnms.location.service.LocationService;
import com.coraltele.service.user.userLocation.model.LocationAssignedModel;
import com.coraltele.service.user.userLocation.model.UserLocationCodesModel;
import com.coraltele.service.user.userLocation.model.UserLocationModel;
import com.coraltele.service.user.userLocation.model.UserLocationNameModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class UserLocationService {
    private static final Logger logger = LogManager.getLogger(UserLocationService.class);
    @Autowired
    UserLocationRepository userLocationRepository;
    @Autowired
    LocationService locationService;

    public RequestResponse createData(UserLocationCodesModel data) {
        logger.debug("Create new UserLocation : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            String username = data.getUsername();
            List locationCodes = data.getLocationCodes();
            for (String locationCode : locationCodes) {
                UserLocation userLocation = new UserLocation();
                userLocation.setLocationCode(locationCode);
                userLocation.setUsername(username);
                this.userLocationRepository.save((Object)userLocation);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("UserLocations Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create UserLocation");
            returnValue.setMessageDetail("Contact With administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(UserLocationModel data) {
        logger.debug("Update UserLocation {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional userLocation = this.userLocationRepository.findById(data.getId());
        if (!userLocation.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("UserLocation Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getLocationCode() != null) {
            ((UserLocation)userLocation.get()).setLocationCode(data.getLocationCode());
        }
        if (data.getUsername() != null) {
            ((UserLocation)userLocation.get()).setUsername(data.getUsername());
        }
        this.userLocationRepository.save(userLocation.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("UserLocation Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteUserLocationById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (String ids : data.getStringId()) {
            Optional userLocation = this.userLocationRepository.findById(ids);
            if (userLocation.isPresent()) {
                addValue.add(userLocation.get());
                this.userLocationRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = UserLocationSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.userLocationRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.userLocationRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<UserLocationNameModel> entityToModelConversion(List<UserLocation> userLocation) {
        ArrayList<UserLocationNameModel> addValue = new ArrayList<UserLocationNameModel>();
        for (UserLocation row : userLocation) {
            UserLocationNameModel data = new UserLocationNameModel();
            data.setId(row.getId());
            data.setLocationCode(row.getLocationCode());
            data.setUsername(row.getUsername());
            data.setLocationName(this.locationService.getLocationName(row.getLocationCode()));
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse getAllLocations(UserLocationModel userLocationModel) {
        List list = this.userLocationRepository.findByUsername(userLocationModel.getUsername());
        ArrayList<LocationAssignedModel> addValue = new ArrayList<LocationAssignedModel>();
        RequestResponse returnValue = new RequestResponse();
        for (UserLocation userLocation : list) {
            LocationAssignedModel data = new LocationAssignedModel();
            data.setLocationCode(userLocation.getLocationCode());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateByUserName(UserLocationCodesModel data) {
        logger.debug("Update Location {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            String username = data.getUsername();
            List newLocationCodes = data.getLocationCodes();
            List existingLocationCodes = this.userLocationRepository.findByUsername(username);
            if (existingLocationCodes.isEmpty()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Not Found");
                returnValue.setMessageDetail("Username Not Found");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            this.userLocationRepository.deleteAll((Iterable)existingLocationCodes);
            for (String locationCode : newLocationCodes) {
                UserLocation userLocation = new UserLocation();
                userLocation.setLocationCode(locationCode);
                userLocation.setUsername(username);
                this.userLocationRepository.save((Object)userLocation);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Updated");
            returnValue.setMessageDetail("Location Updated Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Update UserLocationModel");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }
}

