/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.billingCDRSummary.service;

import com.coraltele.db.telemetry.main.entity.BillingCDRSummary;
import com.coraltele.db.telemetry.main.repository.BillingCDRSummaryRepository;
import com.coraltele.db.telemetry.main.specification.BillingCDRSummarySpecification;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.billingCDRSummary.model.BillingCDRSummaryModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class BillingCDRSummaryService {
    private static final Logger logger = LogManager.getLogger(BillingCDRSummaryService.class);
    @Autowired
    BillingCDRSummaryRepository billingCDRSummaryRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = BillingCDRSummarySpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = "asc".equalsIgnoreCase(searchRequestData.getSortDirection()) ? Sort.by((String[])new String[]{searchRequestData.getSortBy() == null || searchRequestData.getSortBy().isEmpty() ? "startDayEpoch" : searchRequestData.getSortBy()}).ascending() : ("desc".equalsIgnoreCase(searchRequestData.getSortDirection()) ? Sort.by((String[])new String[]{searchRequestData.getSortBy() == null || searchRequestData.getSortBy().isEmpty() ? "startDayEpoch" : searchRequestData.getSortBy()}).descending() : Sort.by((String[])new String[]{searchRequestData.getSortBy() == null || searchRequestData.getSortBy().isEmpty() ? "startDayEpoch" : searchRequestData.getSortBy()}).ascending());
        List allFilteredData = this.billingCDRSummaryRepository.findAll(filters, sort);
        List allUniqueRecords = this.entityToModelConversion(allFilteredData, searchRequestData.getSortDirection());
        int totalUniqueRecords = allUniqueRecords.size();
        int pageSize = searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize();
        int currentPage = searchRequestData.getCurrentPage();
        int startItem = currentPage * pageSize;
        int toIndex = Math.min(startItem + pageSize, totalUniqueRecords);
        List paginatedList = startItem < totalUniqueRecords ? allUniqueRecords.subList(startItem, toIndex) : new ArrayList();
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(currentPage > totalUniqueRecords / pageSize ? 0L : (long)currentPage);
        responseData.setPageSize((long)pageSize);
        responseData.setTotalPages((long)((int)Math.ceil((double)totalUniqueRecords / (double)pageSize)));
        responseData.setTotalRecords((long)totalUniqueRecords);
        responseData.setCurrentPageData(paginatedList);
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<BillingCDRSummaryModel> entityToModelConversion(List<BillingCDRSummary> billingCDRSummaries, String direction) {
        BillingCDRSummaryModel model;
        String extension;
        HashMap<String, BillingCDRSummaryModel> extensionMap = new HashMap<String, BillingCDRSummaryModel>();
        for (BillingCDRSummary row : billingCDRSummaries) {
            extension = row.getExtension();
            if (extensionMap.containsKey(extension)) continue;
            model = new BillingCDRSummaryModel();
            model.setExtension(extension);
            extensionMap.put(extension, model);
        }
        for (BillingCDRSummary row : billingCDRSummaries) {
            extension = row.getExtension();
            model = (BillingCDRSummaryModel)extensionMap.get(extension);
            model.setExternalDialed(model.getExternalDialed() + row.getExternalDialed());
            model.setExternalReceived(model.getExternalReceived() + row.getExternalReceived());
            model.setExternalReceivedAbandoned(model.getExternalReceivedAbandoned() + row.getExternalReceivedAbandoned());
            model.setExternalReceivedAnswered(model.getExternalReceivedAnswered() + row.getExternalReceivedAnswered());
            model.setInternalDialed(model.getInternalDialed() + row.getInternalDialed());
            model.setInternalReceived(model.getInternalReceived() + row.getInternalReceived());
            model.setInternalReceivedAbandoned(model.getInternalReceivedAbandoned() + row.getInternalReceivedAbandoned());
            model.setInternalReceivedAnswered(model.getInternalReceivedAnswered() + row.getInternalReceivedAnswered());
        }
        ArrayList<BillingCDRSummaryModel> resultList = new ArrayList<BillingCDRSummaryModel>(extensionMap.values());
        if (direction != null && !direction.isEmpty()) {
            if ("asc".equalsIgnoreCase(direction)) {
                resultList.sort(Comparator.comparing(BillingCDRSummaryModel::getExtension));
            } else if ("desc".equalsIgnoreCase(direction)) {
                resultList.sort(Comparator.comparing(BillingCDRSummaryModel::getExtension).reversed());
            } else {
                resultList.sort(Comparator.comparing(BillingCDRSummaryModel::getExtension));
            }
        } else {
            resultList.sort(Comparator.comparing(BillingCDRSummaryModel::getExtension));
        }
        return resultList;
    }
}

