/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.agentPerformanceSummary.controller;

import com.coraltele.db.telemetry.main.entity.AgentPerformanceSummary;
import com.coraltele.db.telemetry.main.repository.AgentPerformanceSummaryRepository;
import com.coraltele.db.telemetry.main.specification.AgentPerformanceSummarySpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.telemetry.main.agentPerformanceSummary.service.AgentPerformanceService;
import com.coraltele.service.telemetry.main.agentPerformanceSummary.service.AgentPerformanceSummaryService;
import com.coraltele.service.telemetry.main.agentPerformanceSummary.service.DailyReportPDF;
import com.coraltele.service.user.service.UserService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/agentSummary"})
public class AgentPerformanceController {
    private static final Logger logger = LogManager.getLogger(DailyReportPDF.class);
    @Autowired
    DailyReportPDF agentPerformanceSummaryPDF;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadService;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    AgentPerformanceService agentPerformanceSummary;
    @Autowired
    AgentPerformanceSummaryRepository agentPerformanceSummaryRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    UserService userService;
    @Autowired
    AgentPerformanceSummaryService agentPerformanceSummaryService;
    @Autowired
    QueueTLService queueTLService;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();
    private static final String NET_LOGIN_TIME_COLUMN = "netLoginTime";
    private static final ConcurrentHashMap<String, String> columnMappingsForDailyPerformance;

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/dailyReportList"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.agentPerformanceSummary.getAllByFilterForDailyReport(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/dailyReportDownloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for daily report--");
            boolean adminUser = false;
            boolean teamLeaderUser = false;
            boolean managerUser = false;
            if (this.userService.checkAdminUser(principal.getName())) {
                adminUser = true;
            } else if (this.userService.checkRoleTL(principal.getName())) {
                teamLeaderUser = true;
            } else if (this.userService.checkManagerUser(principal.getName())) {
                managerUser = true;
            }
            Specification filters = AgentPerformanceSummarySpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (boolean)adminUser, (boolean)teamLeaderUser, (boolean)managerUser, (List)this.queueTLService.getAgentListByTL(principal.getName()));
            Sort sort = null;
            if (searchRequestData.sortDirection.equals("asc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
            } else if (searchRequestData.sortDirection.equals("desc")) {
                sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
            }
            List filteredData = sort != null ? this.agentPerformanceSummaryRepository.findAll(filters, sort) : this.agentPerformanceSummaryRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (AgentPerformanceSummary item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName123 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName123));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for daily report cdr", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading daily report CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(AgentPerformanceSummary item, String columnName) {
        Duration totalLoginDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(item.getTotalLoginDuration().longValue())));
        Duration totalUnServiceDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(item.getUnServiceDuration().longValue())));
        Duration totalBreakDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(item.getTotalBreakDuration().longValue())));
        Duration totalRingDuration = Duration.ofSeconds(this.getDurationOrZero(item.getTotalRingDuration()));
        Duration totalDialedDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(item.getTotalDialedDuration().longValue())));
        Duration netRingDuration = totalRingDuration.plus(totalDialedDuration);
        switch (columnName) {
            case "fullname": {
                return this.checkNull((Object)item.getFullname());
            }
            case "agentName": {
                return this.checkNull((Object)item.getAgentName());
            }
            case "totalOffered": {
                return this.checkNull((Object)item.getTotalOffered());
            }
            case "totalNoAnswered": {
                return this.checkNull((Object)item.getTotalNoAnswered());
            }
            case "totalAnswered": {
                return this.checkNull((Object)item.getTotalAnswered());
            }
            case "inAnswered": {
                return this.checkNull((Object)item.getTotalAnswered());
            }
            case "outAnswered": {
                return this.checkNull((Object)item.getTotalConnected());
            }
            case "inNoAnswered": {
                return this.checkNull((Object)item.getTotalNoAnswered());
            }
            case "outNoAnswered": {
                return this.checkNull((Object)item.getTotalNotConnected());
            }
            case "inTalkDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getTotalOfferedTalkDuration()));
            }
            case "outTalkDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getTotalDialedTalkDuration()));
            }
            case "totalLoginDuration": {
                Duration unServiceDuration;
                Duration netLoginTime;
                if (item.getLogoutTime() != null) {
                    netLoginTime = totalLoginDuration;
                } else {
                    netLoginTime = Duration.between(item.getLoginTime(), LocalDateTime.now());
                    netLoginTime = netLoginTime.plus(totalLoginDuration);
                }
                if (item.getStartCallTime() == null && item.getUnLoginTime() != null) {
                    unServiceDuration = Duration.between(item.getUnLoginTime(), LocalDateTime.now());
                    unServiceDuration = unServiceDuration.plus(totalUnServiceDuration);
                } else {
                    unServiceDuration = totalUnServiceDuration;
                }
                Duration totalTime = netLoginTime.minus(totalBreakDuration).minus(unServiceDuration);
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)totalTime.getSeconds()));
            }
            case "totalBreakDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getTotalBreakDuration().longValue()));
            }
            case "netLoginTime": {
                Duration netLoginTime;
                if (item.getLogoutTime() != null) {
                    netLoginTime = totalLoginDuration;
                } else {
                    netLoginTime = Duration.between(item.getLoginTime(), LocalDateTime.now());
                    netLoginTime = netLoginTime.plus(totalLoginDuration);
                }
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)netLoginTime.getSeconds()));
            }
            case "totalRingDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)netRingDuration.getSeconds()));
            }
            case "totalTalkDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getTotalTalkDuration()));
            }
            case "averageTalkDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getAverageTalkDuration()));
            }
            case "totalAcwDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getTotalAcwDuration().longValue()));
            }
            case "totalIdleDuration": {
                Duration unServiceDuration;
                Duration netLoginTime;
                if (item.getLogoutTime() != null) {
                    netLoginTime = totalLoginDuration;
                } else {
                    netLoginTime = Duration.between(item.getLoginTime(), LocalDateTime.now());
                    netLoginTime = netLoginTime.plus(totalLoginDuration);
                }
                if (item.getStartCallTime() == null && item.getUnLoginTime() != null) {
                    unServiceDuration = Duration.between(item.getUnLoginTime(), LocalDateTime.now());
                    unServiceDuration = unServiceDuration.plus(totalUnServiceDuration);
                } else {
                    unServiceDuration = totalUnServiceDuration;
                }
                Duration totalTalkDuration = Duration.ofSeconds(this.getDurationOrZero(item.getTotalTalkDuration()));
                Duration totalAcwDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(item.getTotalAcwDuration().longValue())));
                Duration totalIdleDuration = netLoginTime.minus(netRingDuration).minus(totalAcwDuration).minus(totalTalkDuration).minus(totalBreakDuration).minus(unServiceDuration);
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)totalIdleDuration.getSeconds()));
            }
            case "startDate": {
                return DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)item.getStartDate());
            }
            case "unServiceDuration": {
                if (item.getUnServiceDuration() != null) {
                    Duration unServiceDuration;
                    if (item.getStartCallTime() == null && item.getUnLoginTime() != null) {
                        unServiceDuration = Duration.between(item.getUnLoginTime(), LocalDateTime.now());
                        unServiceDuration = unServiceDuration.plus(totalUnServiceDuration);
                    } else {
                        unServiceDuration = totalUnServiceDuration;
                    }
                    return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)unServiceDuration.getSeconds()));
                }
                return "00:00:00";
            }
        }
        return null;
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    @PostMapping(value={"/dailyPerformanceReportDownloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForDailyPerformance(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for daily report--");
            boolean adminUser = false;
            boolean teamLeaderUser = false;
            boolean managerUser = false;
            if (this.userService.checkAdminUser(principal.getName())) {
                adminUser = true;
            } else if (this.userService.checkRoleTL(principal.getName())) {
                teamLeaderUser = true;
            } else if (this.userService.checkManagerUser(principal.getName())) {
                managerUser = true;
            }
            Specification filters = AgentPerformanceSummarySpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (boolean)adminUser, (boolean)teamLeaderUser, (boolean)managerUser, (List)this.queueTLService.getAgentListByTL(principal.getName()));
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startDate" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startDate" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.agentPerformanceSummaryRepository.findAll(filters, sort) : this.agentPerformanceSummaryRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappingsForDailyPerformance.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (AgentPerformanceSummary item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName123 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValues(item, columnName123));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for daily report cdr", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading daily report CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValues(AgentPerformanceSummary item, String columnName) {
        Duration netRingDuration;
        Duration totalIdleDuration;
        Duration unServiceDuration;
        Duration totalTime;
        Duration totalTalkDuration = Duration.ofSeconds(this.getDurationOrZero(item.getTotalTalkDuration()));
        Duration totalAcwDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(item.getTotalAcwDuration().longValue())));
        Duration totalLoginDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(item.getTotalLoginDuration().longValue())));
        Duration totalUnServiceDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(item.getUnServiceDuration().longValue())));
        Duration totalBreakDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(item.getTotalBreakDuration().longValue())));
        Duration totalRingDuration = Duration.ofSeconds(this.getDurationOrZero(item.getTotalRingDuration()));
        Duration realTotalDialedDuration = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(item.getRealTotalDialedDuration().longValue())));
        if (item.getLoginTime() == null && item.getLogoutTime() == null) {
            totalTime = Duration.ZERO;
            unServiceDuration = Duration.ZERO;
            totalIdleDuration = Duration.ZERO;
            totalBreakDuration = Duration.ZERO;
            netRingDuration = Duration.ZERO;
            totalLoginDuration = Duration.ZERO;
        } else {
            if (item.getLoginTime() != null && item.getLogoutTime() == null) {
                Duration totalLogin = Duration.between(item.getLoginTime(), LocalDateTime.now());
                totalLoginDuration = totalLoginDuration.plus(totalLogin);
            }
            if (item.getStartCallTime() == null && item.getUnLoginTime() != null) {
                unServiceDuration = Duration.between(item.getUnLoginTime(), LocalDateTime.now());
                unServiceDuration = unServiceDuration.plus(totalUnServiceDuration);
            } else {
                unServiceDuration = totalUnServiceDuration;
            }
            if (item.getBreakTime() != null && item.getLogoutTime() == null) {
                Duration totalBreakTime = Duration.between(item.getBreakTime(), LocalDateTime.now());
                totalBreakDuration = totalBreakDuration.plus(totalBreakTime);
            }
            netRingDuration = totalRingDuration.plus(realTotalDialedDuration);
            totalTime = totalLoginDuration.minus(totalBreakDuration).minus(unServiceDuration);
            totalIdleDuration = totalLoginDuration.minus(netRingDuration).minus(totalAcwDuration).minus(totalTalkDuration).minus(totalBreakDuration).minus(unServiceDuration);
        }
        switch (columnName) {
            case "fullname": {
                return this.checkNull((Object)item.getFullname());
            }
            case "agentName": {
                return this.checkNull((Object)item.getAgentName());
            }
            case "totalOffered": {
                return this.checkNull((Object)item.getTotalOffered());
            }
            case "totalDialed": {
                return this.checkNull((Object)item.getTotalDialed());
            }
            case "totalNoAnswered": {
                return this.checkNull((Object)(item.getTotalNoAnswered() + item.getTotalNotConnected()));
            }
            case "totalAnswered": {
                return this.checkNull((Object)(item.getTotalAnswered() + item.getTotalConnected()));
            }
            case "inAnswered": {
                return this.checkNull((Object)item.getTotalAnswered());
            }
            case "outAnswered": {
                return this.checkNull((Object)item.getTotalConnected());
            }
            case "inNoAnswered": {
                return this.checkNull((Object)item.getTotalNoAnswered());
            }
            case "outNoAnswered": {
                return this.checkNull((Object)item.getTotalNotConnected());
            }
            case "inTalkDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getTotalOfferedTalkDuration()));
            }
            case "outTalkDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getTotalDialedTalkDuration()));
            }
            case "totalRingDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)netRingDuration.getSeconds()));
            }
            case "totalLoginDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)totalTime.getSeconds()));
            }
            case "totalBreakDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)totalBreakDuration.getSeconds()));
            }
            case "netLoginTime": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)totalLoginDuration.getSeconds()));
            }
            case "totalTalkDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getTotalTalkDuration()));
            }
            case "averageTalkDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getAverageTalkDuration()));
            }
            case "totalIdleDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)totalIdleDuration.getSeconds()));
            }
            case "second10": {
                return this.checkNull((Object)item.getSecond10());
            }
            case "second20": {
                return this.checkNull((Object)item.getSecond20());
            }
            case "second30": {
                return this.checkNull((Object)item.getSecond30());
            }
            case "second40": {
                return this.checkNull((Object)item.getSecond40());
            }
            case "second50": {
                return this.checkNull((Object)item.getSecond50());
            }
            case "second60": {
                return this.checkNull((Object)item.getSecond60());
            }
            case "startDate": {
                return this.dateFormatUtility.epochToLocalDateForLocalTimeZone(item.getStartDate());
            }
            case "totalAcwDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getTotalAcwDuration().longValue()));
            }
            case "unServiceDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)unServiceDuration.getSeconds()));
            }
        }
        return null;
    }

    private long getDurationOrZero(Long duration) {
        return duration != null ? duration : 0L;
    }

    @PostMapping(value={"/dailyPerformanceReportList"})
    public ResponseEntity<RequestResponse> getAllByFilterForDailyPerformance(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.agentPerformanceSummary.getAllByFilterForDailyPerformance(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    static {
        columnMappings.put(NET_LOGIN_TIME_COLUMN, "Total Login Time");
        columnMappings.put("fullname", "Agent Name");
        columnMappings.put("agentName", "AgentId");
        columnMappings.put("totalOffered", "Call Offered");
        columnMappings.put("totalNoAnswered", "Total No Answered");
        columnMappings.put("totalAnswered", "Total Answered");
        columnMappings.put("inAnswered", "In Answered");
        columnMappings.put("outAnswered", "Out Answered");
        columnMappings.put("inNoAnswered", "In No Answered");
        columnMappings.put("outNoAnswered", "Out No Answered");
        columnMappings.put("inTalkDuration", "In Talk Time");
        columnMappings.put("outTalkDuration", "Out Talk Time");
        columnMappings.put("totalLoginDuration", "Net Login Time");
        columnMappings.put("totalBreakDuration", "Break Time");
        columnMappings.put("totalRingDuration", "Ring Time");
        columnMappings.put("totalTalkDuration", "Talk Time");
        columnMappings.put("averageTalkDuration", "Avg Talk Time");
        columnMappings.put("totalAcwDuration", "ACW Time");
        columnMappings.put("totalIdleDuration", "Idle Time");
        columnMappings.put("startDate", "Start Date");
        columnMappings.put("unServiceDuration", "Total Unservice Time");
        columnMappingsForDailyPerformance = new ConcurrentHashMap();
        columnMappingsForDailyPerformance.put(NET_LOGIN_TIME_COLUMN, "Total Login Time");
        columnMappingsForDailyPerformance.put("fullname", "Agent Name");
        columnMappingsForDailyPerformance.put("agentName", "AgentId");
        columnMappingsForDailyPerformance.put("totalOffered", "Call Offered");
        columnMappingsForDailyPerformance.put("totalDialed", "Dialed Out");
        columnMappingsForDailyPerformance.put("totalNoAnswered", "Total No Answered");
        columnMappingsForDailyPerformance.put("totalAnswered", "Total Answered");
        columnMappingsForDailyPerformance.put("inAnswered", "In Answered");
        columnMappingsForDailyPerformance.put("outAnswered", "Out Answered");
        columnMappingsForDailyPerformance.put("inNoAnswered", "In No Answered");
        columnMappingsForDailyPerformance.put("outNoAnswered", "Out No Answered");
        columnMappingsForDailyPerformance.put("inTalkDuration", "In Talk Time");
        columnMappingsForDailyPerformance.put("outTalkDuration", "Out Talk Time");
        columnMappingsForDailyPerformance.put("totalRingDuration", "Total Ring Time");
        columnMappingsForDailyPerformance.put("totalTalkDuration", "Total Talk Time");
        columnMappingsForDailyPerformance.put("averageTalkDuration", "Avg Talk Time");
        columnMappingsForDailyPerformance.put("totalIdleDuration", "Total Idle Time");
        columnMappingsForDailyPerformance.put("totalBreakDuration", "Total Break Time");
        columnMappingsForDailyPerformance.put("totalLoginDuration", "Net Login Time");
        columnMappingsForDailyPerformance.put("totalAcwDuration", "ACW Time");
        columnMappingsForDailyPerformance.put("second10", "10 Sec");
        columnMappingsForDailyPerformance.put("second20", "20 Sec");
        columnMappingsForDailyPerformance.put("second30", "30 Sec");
        columnMappingsForDailyPerformance.put("second40", "40 Sec");
        columnMappingsForDailyPerformance.put("second50", "50 Sec");
        columnMappingsForDailyPerformance.put("second60", "60 Sec");
        columnMappingsForDailyPerformance.put("startDate", "Start Date");
        columnMappingsForDailyPerformance.put("unServiceDuration", "Total Unservice Time");
    }
}

