/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.InboundGateway.service;

import com.coraltele.db.telephony.pbx.entity.CLIServerCommandLog;
import com.coraltele.db.telephony.pbx.entity.InboundGateway;
import com.coraltele.db.telephony.pbx.repository.InboundGatewayRepository;
import com.coraltele.db.telephony.pbx.specification.InboundGatewaySpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.InboundGateway.model.InboundGatewayModel;
import com.coraltele.service.uc.service.CustomerAccountService;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class InboundGatewayService {
    private static final Logger logger = LogManager.getLogger(InboundGatewayService.class);
    @Autowired
    InboundGatewayRepository inboundGatewayRepository;
    @Autowired
    CustomerAccountService customerAccountService;

    public RequestResponse createData(InboundGatewayModel data) {
        logger.debug("create new inboundGateway : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            List list = (List)this.inboundGatewayRepository.findAll();
            for (InboundGateway gwCode : list) {
                if (!gwCode.getGwCode().equals(data.getGwCode())) continue;
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Unable to Create InboundGateway");
                returnValue.setMessageDetail("Please Enter Different GwCode");
                return returnValue;
            }
            if (CustomerAccountService.getClickToCall()) {
                String code = data.getGwCode();
                String type = "";
                type = data.getGwType().equals("customType") ? data.getGwTypeCustom() : data.getGwType();
                String name = data.getGwName();
                String param = data.getGwParam();
                CLIServerCommandLog cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("gwinbound create %s %s %s %s", code, type, name, param));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info(cliServerCommandLog.getCLICommand());
                CLIServerCommandLog cliServerCommandLog1 = new CLIServerCommandLog();
                cliServerCommandLog1.setCLICommand(String.format("gwinbound update %s active true", data.getGwCode()));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog1);
                logger.info(cliServerCommandLog1.getCLICommand());
            } else {
                InboundGateway inboundGateway = new InboundGateway();
                inboundGateway.setAnonymousCallRejection(data.getAnonymousCallRejection());
                inboundGateway.setCallerStrip(data.getCallerStrip());
                inboundGateway.setCodec(data.getCodec());
                inboundGateway.setCustomDestination(data.getCustomDestination());
                inboundGateway.setCutTime(data.getCutTime());
                inboundGateway.setDid(data.getDid());
                inboundGateway.setDniBasedRouting(data.getDniBasedRouting());
                inboundGateway.setGatewayControllerCode(data.getGatewayControllerCode());
                inboundGateway.setGwCode(data.getGwCode());
                inboundGateway.setGwName(data.getGwName());
                inboundGateway.setGwOutbound(data.getGwOutbound());
                inboundGateway.setGwParam(data.getGwParam());
                if (data.getGwType().equals("customType")) {
                    inboundGateway.setGwType(data.getGwTypeCustom());
                } else {
                    inboundGateway.setGwType(data.getGwType());
                }
                inboundGateway.setHandleIsDnCause(data.getHandleIsDnCause());
                inboundGateway.setInboundCos(data.getInboundCos());
                inboundGateway.setIsCliBaseRouting(data.getIsCliBaseRouting());
                inboundGateway.setIsEnable(data.getIsEnable());
                inboundGateway.setIsRecording(data.getIsRecording());
                inboundGateway.setMaxCallerDigit(data.getMaxCallerDigit());
                inboundGateway.setMaxChannel(data.getMaxChannel());
                inboundGateway.setMissCallRedial(data.getMissCallRedial());
                inboundGateway.setNameReplaceWithCaller(data.getNameReplaceWithCaller());
                inboundGateway.setNumberStrip(data.getNumberStrip());
                inboundGateway.setOutboundCos(data.getOutboundCos());
                inboundGateway.setOutboundGroupGw(data.getOutboundGroupGw());
                inboundGateway.setPeerToPeer(data.getPeerToPeer());
                inboundGateway.setQSig(data.getQSig());
                inboundGateway.setRestrictFeatureAccess(data.getRestrictFeatureAccess());
                inboundGateway.setRingBackTone(data.getRingBackTone());
                inboundGateway.setRingReady(data.getRingReady());
                inboundGateway.setTenantCode(data.getTenantCode());
                this.inboundGatewayRepository.save((Object)inboundGateway);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("InboundGateway Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create InboundGateway");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(InboundGatewayModel data) {
        logger.debug("Update DistortionFile {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional inboundGateway = this.inboundGatewayRepository.findById((Object)data.getId());
        if (!inboundGateway.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("InboundGateway not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (CustomerAccountService.getClickToCall()) {
            CLIServerCommandLog cliServerCommandLog;
            logger.info("Saving data using cli command");
            if (!Objects.equals(data.getAnonymousCallRejection(), ((InboundGateway)inboundGateway.get()).getAnonymousCallRejection())) {
                if ("true".equalsIgnoreCase(String.valueOf(data.getAnonymousCallRejection()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s acr on", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getAnonymousCallRejection() == null || "false".equalsIgnoreCase(String.valueOf(data.getAnonymousCallRejection()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s acr off", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getCustomDestination(), ((InboundGateway)inboundGateway.get()).getCustomDestination())) {
                if (data.getCustomDestination() != null && !data.getCustomDestination().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s customdestination %s", data.getGwCode(), data.getCustomDestination()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getCustomDestination() == null || data.getCustomDestination().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s customdestination reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getMaxChannel(), ((InboundGateway)inboundGateway.get()).getMaxChannel())) {
                if (data.getMaxChannel() != null && !data.getMaxChannel().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s maxchannel %s", data.getGwCode(), data.getMaxChannel()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getMaxChannel() == null || data.getMaxChannel().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s maxchannel reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getOutboundCos(), ((InboundGateway)inboundGateway.get()).getOutboundCos())) {
                if (data.getOutboundCos() != null && !data.getOutboundCos().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s outboundcos %s", data.getGwCode(), data.getOutboundCos()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getOutboundCos() == null || data.getOutboundCos().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s outboundcos reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getRestrictFeatureAccess(), ((InboundGateway)inboundGateway.get()).getRestrictFeatureAccess())) {
                if ("true".equalsIgnoreCase(String.valueOf(data.getRestrictFeatureAccess()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s rfa on", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getRestrictFeatureAccess() == null || "false".equalsIgnoreCase(String.valueOf(data.getRestrictFeatureAccess()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s rfa off", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getOutboundGroupGw(), ((InboundGateway)inboundGateway.get()).getOutboundGroupGw())) {
                if (data.getOutboundGroupGw() != null && !data.getOutboundGroupGw().isEmpty()) {
                    if (data.getOutboundGroupGw().equalsIgnoreCase("CustomGroup")) {
                        cliServerCommandLog = new CLIServerCommandLog();
                        cliServerCommandLog.setCLICommand(String.format("gwinbound update %s gwgroup %s", data.getGwCode(), data.getOutboundCustomGroupGw()));
                        this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                        logger.info(cliServerCommandLog.getCLICommand());
                    } else {
                        cliServerCommandLog = new CLIServerCommandLog();
                        cliServerCommandLog.setCLICommand(String.format("gwinbound update %s gwgroup %s", data.getGwCode(), data.getOutboundGroupGw()));
                        this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                        logger.info(cliServerCommandLog.getCLICommand());
                    }
                } else if (data.getOutboundGroupGw() == null || data.getOutboundGroupGw().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s gwgroup reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getMissCallRedial(), ((InboundGateway)inboundGateway.get()).getMissCallRedial())) {
                if ("true".equalsIgnoreCase(String.valueOf(data.getMissCallRedial()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s misscallredial on", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getMissCallRedial() == null || "false".equalsIgnoreCase(String.valueOf(data.getMissCallRedial()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s misscallredial off", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getGwParam(), ((InboundGateway)inboundGateway.get()).getGwParam())) {
                if (data.getGwParam() != null && !data.getGwParam().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s param %s", data.getGwCode(), data.getGwParam()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getGwParam() == null || data.getGwParam().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s param reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getRingBackTone(), ((InboundGateway)inboundGateway.get()).getRingBackTone())) {
                if (data.getRingBackTone() != null && !data.getRingBackTone().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s ringbacktone %s", data.getGwCode(), data.getRingBackTone()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getRingBackTone() == null || data.getRingBackTone().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s ringbacktone reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getCallerStrip(), ((InboundGateway)inboundGateway.get()).getCallerStrip())) {
                if (data.getCallerStrip() != null && !data.getCallerStrip().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s callerstrip %s", data.getGwCode(), data.getCallerStrip()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getCallerStrip() == null || data.getCallerStrip().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s callerstrip reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getDniBasedRouting(), ((InboundGateway)inboundGateway.get()).getDniBasedRouting())) {
                if ("true".equalsIgnoreCase(String.valueOf(data.getDniBasedRouting()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s dnibasedrouting on", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getDniBasedRouting() == null || "false".equalsIgnoreCase(String.valueOf(data.getDniBasedRouting()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s dnibasedrouting off", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getHandleIsDnCause(), ((InboundGateway)inboundGateway.get()).getHandleIsDnCause())) {
                if ("true".equalsIgnoreCase(String.valueOf(data.getHandleIsDnCause()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s handleisdncause on", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getHandleIsDnCause() == null || "false".equalsIgnoreCase(String.valueOf(data.getHandleIsDnCause()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s handleisdncause off", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getPeerToPeer(), ((InboundGateway)inboundGateway.get()).getPeerToPeer())) {
                if ("true".equalsIgnoreCase(String.valueOf(data.getPeerToPeer()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s peertopeer on", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getPeerToPeer() == null || "false".equalsIgnoreCase(String.valueOf(data.getPeerToPeer()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s peertopeer off", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getRingReady(), ((InboundGateway)inboundGateway.get()).getRingReady())) {
                if ("true".equalsIgnoreCase(String.valueOf(data.getRingReady()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s ringready on", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getRingReady() == null || "false".equalsIgnoreCase(String.valueOf(data.getRingReady()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s ringready off", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getIsCliBaseRouting(), ((InboundGateway)inboundGateway.get()).getIsCliBaseRouting())) {
                if ("true".equalsIgnoreCase(String.valueOf(data.getIsCliBaseRouting()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s cbr true", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getIsCliBaseRouting() == null || "false".equalsIgnoreCase(String.valueOf(data.getIsCliBaseRouting()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s cbr false", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getInboundCos(), ((InboundGateway)inboundGateway.get()).getInboundCos())) {
                if (data.getInboundCos() != null && !data.getInboundCos().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s inboundcos %s", data.getGwCode(), data.getInboundCos()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getInboundCos() == null || data.getInboundCos().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s inboundcos reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getNameReplaceWithCaller(), ((InboundGateway)inboundGateway.get()).getNameReplaceWithCaller())) {
                if ("true".equalsIgnoreCase(String.valueOf(data.getNameReplaceWithCaller()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s nameupdatewithcaller on", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getNameReplaceWithCaller() == null || "false".equalsIgnoreCase(String.valueOf(data.getNameReplaceWithCaller()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s nameupdatewithcaller off", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getQSig(), ((InboundGateway)inboundGateway.get()).getQSig())) {
                if ("true".equalsIgnoreCase(String.valueOf(data.getQSig()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s qsig on", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getQSig() == null || "false".equalsIgnoreCase(String.valueOf(data.getQSig()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s qsig off", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getTenantCode(), ((InboundGateway)inboundGateway.get()).getTenantCode())) {
                if (data.getTenantCode() != null && !data.getTenantCode().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s tenant %s", data.getGwCode(), data.getTenantCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getTenantCode() == null || data.getTenantCode().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s tenant reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getCodec(), ((InboundGateway)inboundGateway.get()).getCodec())) {
                if (data.getCodec() != null && !data.getCodec().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s codec %s", data.getGwCode(), data.getCodec()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getCodec() == null || data.getCodec().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s codec reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getGatewayControllerCode(), ((InboundGateway)inboundGateway.get()).getGatewayControllerCode())) {
                if (data.getGatewayControllerCode() != null && !data.getGatewayControllerCode().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s gatewaycontrollercode %s", data.getGwCode(), data.getGatewayControllerCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getGatewayControllerCode() == null || data.getGatewayControllerCode().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s gatewaycontrollercode reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getMaxCallerDigit(), ((InboundGateway)inboundGateway.get()).getMaxCallerDigit())) {
                if (data.getMaxCallerDigit() != null && !data.getMaxCallerDigit().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s maxcallerlimit %s", data.getGwCode(), data.getMaxCallerDigit()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getMaxCallerDigit() == null || data.getMaxCallerDigit().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s maxcallerlimit reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getNumberStrip(), ((InboundGateway)inboundGateway.get()).getNumberStrip())) {
                if (data.getNumberStrip() != null && !data.getNumberStrip().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s numberstrip %s", data.getGwCode(), data.getNumberStrip()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getNumberStrip() == null || data.getNumberStrip().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s numberstrip reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getIsRecording(), ((InboundGateway)inboundGateway.get()).getIsRecording())) {
                if ("true".equalsIgnoreCase(String.valueOf(data.getIsRecording()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s rec on", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getIsRecording() == null || "false".equalsIgnoreCase(String.valueOf(data.getIsRecording()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s rec off", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getGwType(), ((InboundGateway)inboundGateway.get()).getGwType())) {
                if (data.getGwType() != null && !data.getGwType().isEmpty()) {
                    if (data.getGwType().equals("customType")) {
                        cliServerCommandLog = new CLIServerCommandLog();
                        cliServerCommandLog.setCLICommand(String.format("gwinbound update %s type %s", data.getGwCode(), data.getGwTypeCustom()));
                        this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                        logger.info(cliServerCommandLog.getCLICommand());
                    } else {
                        cliServerCommandLog = new CLIServerCommandLog();
                        cliServerCommandLog.setCLICommand(String.format("gwinbound update %s type %s", data.getGwCode(), data.getGwType()));
                        this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                        logger.info(cliServerCommandLog.getCLICommand());
                    }
                } else if (data.getGwType() == null || data.getGwType().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s type reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getCutTime(), ((InboundGateway)inboundGateway.get()).getCutTime())) {
                if (data.getCutTime() != null && !data.getCutTime().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s cuttime %s", data.getGwCode(), data.getCutTime()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getCutTime() == null || data.getCutTime().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s cuttime reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getDid(), ((InboundGateway)inboundGateway.get()).getDid())) {
                if (data.getDid() != null && !data.getDid().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s gatewaydid %s", data.getGwCode(), data.getDid()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getDid() == null || data.getDid().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s gatewaydid reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getGwName(), ((InboundGateway)inboundGateway.get()).getGwName())) {
                if (data.getGwName() != null && !data.getGwName().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s name %s", data.getGwCode(), data.getGwName()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getGwName() == null || data.getGwName().toString().isEmpty()) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s name reset", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
            if (!Objects.equals(data.getIsEnable(), ((InboundGateway)inboundGateway.get()).getIsEnable())) {
                if ("true".equalsIgnoreCase(String.valueOf(data.getIsEnable()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s active true", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                } else if (data.getIsEnable() == null || "false".equalsIgnoreCase(String.valueOf(data.getIsEnable()))) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("gwinbound update %s active false", data.getGwCode()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info(cliServerCommandLog.getCLICommand());
                }
            }
        } else {
            logger.info("Saving data in database");
            ((InboundGateway)inboundGateway.get()).setAnonymousCallRejection(data.getAnonymousCallRejection());
            ((InboundGateway)inboundGateway.get()).setCallerStrip(data.getCallerStrip());
            ((InboundGateway)inboundGateway.get()).setCodec(data.getCodec());
            ((InboundGateway)inboundGateway.get()).setCustomDestination(data.getCustomDestination());
            ((InboundGateway)inboundGateway.get()).setCutTime(data.getCutTime());
            ((InboundGateway)inboundGateway.get()).setDid(data.getDid());
            ((InboundGateway)inboundGateway.get()).setDniBasedRouting(data.getDniBasedRouting());
            ((InboundGateway)inboundGateway.get()).setGatewayControllerCode(data.getGatewayControllerCode());
            ((InboundGateway)inboundGateway.get()).setGwCode(data.getGwCode());
            ((InboundGateway)inboundGateway.get()).setGwName(data.getGwName());
            ((InboundGateway)inboundGateway.get()).setGwOutbound(data.getGwOutbound());
            ((InboundGateway)inboundGateway.get()).setGwParam(data.getGwParam());
            if (data.getOutboundGroupGw().equalsIgnoreCase("CustomGroup")) {
                ((InboundGateway)inboundGateway.get()).setOutboundGroupGw(data.getOutboundCustomGroupGw());
            } else {
                ((InboundGateway)inboundGateway.get()).setOutboundGroupGw(data.getOutboundGroupGw());
            }
            if (data.getGwType() != null && data.getGwType().equals("customType")) {
                ((InboundGateway)inboundGateway.get()).setGwType(data.getGwTypeCustom());
            } else if (data.getGwType() != null) {
                ((InboundGateway)inboundGateway.get()).setGwType(data.getGwType());
            }
            ((InboundGateway)inboundGateway.get()).setHandleIsDnCause(data.getHandleIsDnCause());
            ((InboundGateway)inboundGateway.get()).setInboundCos(data.getInboundCos());
            ((InboundGateway)inboundGateway.get()).setIsCliBaseRouting(data.getIsCliBaseRouting());
            ((InboundGateway)inboundGateway.get()).setIsEnable(data.getIsEnable());
            ((InboundGateway)inboundGateway.get()).setIsRecording(data.getIsRecording());
            ((InboundGateway)inboundGateway.get()).setMaxCallerDigit(data.getMaxCallerDigit());
            ((InboundGateway)inboundGateway.get()).setMaxChannel(data.getMaxChannel());
            ((InboundGateway)inboundGateway.get()).setMissCallRedial(data.getMissCallRedial());
            ((InboundGateway)inboundGateway.get()).setNameReplaceWithCaller(data.getNameReplaceWithCaller());
            ((InboundGateway)inboundGateway.get()).setNumberStrip(data.getNumberStrip());
            ((InboundGateway)inboundGateway.get()).setOutboundCos(data.getOutboundCos());
            ((InboundGateway)inboundGateway.get()).setPeerToPeer(data.getPeerToPeer());
            ((InboundGateway)inboundGateway.get()).setQSig(data.getQSig());
            ((InboundGateway)inboundGateway.get()).setRestrictFeatureAccess(data.getRestrictFeatureAccess());
            ((InboundGateway)inboundGateway.get()).setRingBackTone(data.getRingBackTone());
            ((InboundGateway)inboundGateway.get()).setRingReady(data.getRingReady());
            ((InboundGateway)inboundGateway.get()).setTenantCode(data.getTenantCode());
            this.inboundGatewayRepository.save(inboundGateway.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("InboundGateway Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteInboundGateway(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        for (Integer ids : data.getIntId()) {
            Optional inboundGateway = this.inboundGatewayRepository.findById((Object)ids);
            if (!inboundGateway.isPresent()) continue;
            if (CustomerAccountService.getClickToCall()) {
                CLIServerCommandLog cliServerCommandLog = new CLIServerCommandLog();
                cliServerCommandLog.setCLICommand(String.format("gwinbound delete %s", ((InboundGateway)inboundGateway.get()).getGwCode()));
                this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                logger.info(cliServerCommandLog.getCLICommand());
                continue;
            }
            this.inboundGatewayRepository.deleteById((Object)ids);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = InboundGatewaySpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.inboundGatewayRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.inboundGatewayRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

