/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.dnd.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.coralApps.callcenter.dnd.model.DNDModel;
import com.coraltele.service.coralApps.callcenter.dnd.service.DNDService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/dnd"})
@RestController
public class DNDController {
    @Autowired
    DNDService dndService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody DNDModel data) {
        RequestResponse returnValue = this.dndService.createDataInDnd(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody DNDModel data) {
        RequestResponse returnValue = this.dndService.updateById(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.dndService.deleteAgentById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.dndService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

