/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.configuration.nodeConfiguration.service;

import com.coraltele.db.telephony.main.entity.NodeCluster;
import com.coraltele.db.telephony.main.entity.Routes;
import com.coraltele.db.telephony.main.entity.WAns;
import com.coraltele.db.telephony.main.repository.NodeClusterRepository;
import com.coraltele.db.telephony.main.repository.RoutesRepository;
import com.coraltele.db.telephony.main.repository.WAnsRepository;
import com.coraltele.db.telephony.main.specification.NodeClusterSpecification;
import com.coraltele.helper.BashCmd;
import com.coraltele.helper.ClusterKeyEncryptDecrypt;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.configuration.nodeConfiguration.model.CoralConfigurationModel;
import com.coraltele.service.configuration.nodeConfiguration.model.HostnameModel;
import com.coraltele.service.configuration.nodeConfiguration.model.NodeClusterModel;
import com.coraltele.service.configuration.nodeConfiguration.model.NodeClusterModelBulk;
import com.coraltele.service.configuration.nodeConfiguration.model.NodesModel;
import com.coraltele.service.configuration.nodeConfiguration.model.UpdateNodesModel;
import com.coraltele.service.pbx.fileConfiguration.sipTrunkConfiguration.model.SIPTrunkModel;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;
import org.ini4j.Profile;
import org.ini4j.Wini;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class NodeClusterService {
    private static final Logger logger = LogManager.getLogger(NodeClusterService.class);
    @Autowired
    NodeClusterRepository nodeClusterRepository;
    @Autowired
    RoutesRepository routeRepo;
    @Autowired
    WAnsRepository wanRepo;
    @Autowired
    private ClusterKeyEncryptDecrypt key;
    @Autowired
    BashCmd shellCommand;

    public List<NodeCluster> getList() {
        return this.nodeClusterRepository.findAll();
    }

    public RequestResponse getList(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = NodeClusterSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.nodeClusterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.nodeClusterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("node-cluster list rendered successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse register(NodeClusterModel data) throws Exception {
        RequestResponse returnValue = new RequestResponse();
        try {
            NodeCluster dataToSave = new NodeCluster();
            dataToSave.setNodeName(data.getNodeName());
            dataToSave.setHostIP0(data.getHostIP0());
            dataToSave.setHostIP1(data.getHostIP1());
            dataToSave.setControlIP(data.getControlIP());
            dataToSave.setMmeIP(data.getMmeIP());
            dataToSave.setCscf(data.getCscf());
            dataToSave.setFeature(data.getFeature());
            dataToSave.setTrunk(data.getTrunk());
            dataToSave.setHostGateway(data.getHostGateway());
            dataToSave.setCscfGateway(data.getCscfGateway());
            dataToSave.setHostSubnet(data.getHostSubnet());
            dataToSave.setCscfSubnet(data.getCscfSubnet());
            dataToSave.setMcc(data.getMcc());
            dataToSave.setMnc(data.getMnc());
            dataToSave.setPassType(data.getPassType());
            dataToSave.setAmf(data.getAmf());
            dataToSave.setSd(data.getSd());
            dataToSave.setMode(data.getMode());
            dataToSave.setTac(data.getTac());
            dataToSave.setMmeMNC(data.getMmeMNC());
            dataToSave.setDomain(data.getDomain());
            dataToSave.setTls(data.getTls());
            dataToSave.setSbcUsersPort(data.getSbcUsersPort());
            dataToSave.setSbcUsersPortTls(data.getSbcUsersPortTls());
            dataToSave.setFeatureUsersPort(data.getFeatureUsersPort());
            dataToSave.setFeatureUsersPortTls(data.getFeatureUsersPortTls());
            dataToSave.setTrunkGatewayPort(data.getTrunkGatewayPort());
            dataToSave.setTrunkGatewayPortTls(data.getTrunkGatewayPortTls());
            dataToSave.setTrunkProxyPort(data.getTrunkProxyPort());
            dataToSave.setTrunkProxyPortTls(data.getTrunkProxyPortTls());
            if (data.getClusterKey() != null) {
                dataToSave.setClusterKey(this.key.encrypt(data.getClusterKey()));
            }
            dataToSave.setEnableBilling(data.getEnableBilling());
            dataToSave.setIpRecordingServer(data.getIpRecordingServer());
            dataToSave.setNodeCscf(data.getNodeCscf());
            dataToSave.setCscfName(data.getCscfName());
            dataToSave.setRouterId(data.getRouterId());
            dataToSave.setEnableTrunkGatewayInservice(data.getEnableTrunkGatewayInService());
            dataToSave.setIpProxyCscf(data.getIpProxyCscf());
            if (data.getMediaProxyPortsFrom() != null) {
                dataToSave.setMediaProxyPortsFrom(data.getMediaProxyPortsFrom());
            } else {
                dataToSave.setMediaProxyPortsFrom(Integer.valueOf(16384));
            }
            if (data.getMediaProxyPortsTo() != null) {
                dataToSave.setMediaProxyPortsTo(data.getMediaProxyPortsTo());
            } else {
                dataToSave.setMediaProxyPortsTo(Integer.valueOf(32768));
            }
            dataToSave.setIpTrunkGateway(data.getIpTrunkGateway());
            dataToSave.setIpTrunkGatewayProxy(data.getIpTrunkGatewayProxy());
            dataToSave.setIpMediaProxy(data.getIpMediaProxy());
            dataToSave.setIpAdditional(data.getIpAdditional());
            if (data.getFeatureMediaPortsFrom() != null) {
                dataToSave.setFeatureMediaPortsFrom(data.getFeatureMediaPortsFrom());
            } else {
                dataToSave.setFeatureMediaPortsFrom(Integer.valueOf(16384));
            }
            if (data.getFeatureMediaPortsTo() != null) {
                dataToSave.setFeatureMediaPortsTo(data.getFeatureMediaPortsTo());
            } else {
                dataToSave.setFeatureMediaPortsTo(Integer.valueOf(32768));
            }
            if (data.getTrunkMediaPortsFrom() != null) {
                dataToSave.setTrunkMediaPortsFrom(data.getTrunkMediaPortsFrom());
            } else {
                dataToSave.setTrunkMediaPortsFrom(Integer.valueOf(16384));
            }
            if (data.getTrunkMediaPortsTo() != null) {
                dataToSave.setTrunkMediaPortsTo(data.getTrunkMediaPortsTo());
            } else {
                dataToSave.setTrunkMediaPortsTo(Integer.valueOf(32768));
            }
            dataToSave.setGateway(data.getGateway());
            dataToSave.setStickyIp(data.getStickyIp());
            dataToSave.setScadaServers(data.getScadaServers());
            dataToSave.setSnmpTrapReceiveIp(data.getSnmpTrapReceiveIp());
            dataToSave.setSnmpTrapReceivePort(data.getSnmpTrapReceivePort());
            dataToSave.setSnmpTrapSendIp(data.getSnmpTrapSendIp());
            dataToSave.setSnmpTrapSendPort(data.getSnmpTrapSendPort());
            dataToSave.setSnmpEventSendIp(data.getSnmpEventSendIp());
            dataToSave.setSnmpEventSendPort(data.getSnmpEventSendPort());
            dataToSave.setEnableRedisPubSub(data.getEnableRedisPubSub());
            dataToSave.setEnableNms(data.getEnableNms());
            dataToSave.setCentralNmsRedisIp(data.getCentralNmsRedisIp());
            dataToSave.setCentralNmsRedisPort(data.getCentralNmsRedisPort());
            dataToSave.setServerRluCode(data.getServerRluCode());
            dataToSave.setDiscoveryDuration(data.getDiscoveryDuration());
            dataToSave.setDiscoveryTimeout(data.getDiscoveryTimeout());
            dataToSave.setIcmpCheckThreads(data.getIcmpCheckThreads());
            dataToSave.setIpCountEachThread(data.getIpCountEachThread());
            dataToSave.setNode(data.getNode());
            dataToSave.setScAdaPort(data.getScAdaPort());
            dataToSave.setGroupCode(data.getGroupCode());
            dataToSave.setRecordingMode(data.getRecordingMode());
            this.nodeClusterRepository.save((Object)dataToSave);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("cluster created successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("cluster creation failed ");
            logger.info("error during register node:", (Object)e.getMessage(), (Object)e);
        }
        return returnValue;
    }

    public RequestResponse update(NodeClusterModel data) {
        RequestResponse returnValue = new RequestResponse();
        Optional currentRecord = this.nodeClusterRepository.findById((Object)data.getId());
        if (currentRecord.isPresent()) {
            NodeCluster dataToSave = (NodeCluster)currentRecord.get();
            if (data.getNodeName() != null) {
                dataToSave.setNodeName(data.getNodeName());
            }
            if (data.getHostIP0() != null) {
                dataToSave.setHostIP0(data.getHostIP0());
            }
            if (data.getHostIP1() != null) {
                dataToSave.setHostIP1(data.getHostIP1());
            }
            if (data.getControlIP() != null) {
                dataToSave.setControlIP(data.getControlIP());
            }
            if (data.getMmeIP() != null) {
                dataToSave.setMmeIP(data.getMmeIP());
            }
            if (data.getCscf() != null) {
                dataToSave.setCscf(data.getCscf());
            }
            if (data.getFeature() != null) {
                dataToSave.setFeature(data.getFeature());
            }
            if (data.getTrunk() != null) {
                dataToSave.setTrunk(data.getTrunk());
            }
            if (data.getHostGateway() != null) {
                dataToSave.setHostGateway(data.getHostGateway());
            }
            if (data.getCscfGateway() != null) {
                dataToSave.setCscfGateway(data.getCscfGateway());
            }
            if (data.getHostSubnet() != null) {
                dataToSave.setHostSubnet(data.getHostSubnet());
            }
            if (data.getCscfSubnet() != null) {
                dataToSave.setCscfSubnet(data.getCscfSubnet());
            }
            if (data.getMcc() != null) {
                dataToSave.setMcc(data.getMcc());
            }
            if (data.getMnc() != null) {
                dataToSave.setMnc(data.getMnc());
            }
            if (data.getPassType() != null) {
                dataToSave.setPassType(data.getPassType());
            }
            if (data.getAmf() != null) {
                dataToSave.setAmf(data.getAmf());
            }
            if (data.getSd() != null) {
                dataToSave.setSd(data.getSd());
            }
            if (data.getMode() != null) {
                dataToSave.setMode(data.getMode());
            }
            if (data.getTac() != null) {
                dataToSave.setTac(data.getTac());
            }
            if (data.getMmeMNC() != null) {
                dataToSave.setMmeMNC(data.getMmeMNC());
            }
            if (data.getDomain() != null) {
                dataToSave.setDomain(data.getDomain());
            }
            if (data.getTls() != null) {
                dataToSave.setTls(data.getTls());
            }
            if (data.getSbcUsersPort() != null) {
                dataToSave.setSbcUsersPort(data.getSbcUsersPort());
            }
            if (data.getSbcUsersPortTls() != null) {
                dataToSave.setSbcUsersPortTls(data.getSbcUsersPortTls());
            }
            if (data.getFeatureUsersPort() != null) {
                dataToSave.setFeatureUsersPort(data.getFeatureUsersPort());
            }
            if (data.getFeatureUsersPortTls() != null) {
                dataToSave.setFeatureUsersPortTls(data.getFeatureUsersPortTls());
            }
            if (data.getTrunkGatewayPort() != null) {
                dataToSave.setTrunkGatewayPort(data.getTrunkGatewayPort());
            }
            if (data.getTrunkGatewayPortTls() != null) {
                dataToSave.setTrunkGatewayPortTls(data.getTrunkGatewayPortTls());
            }
            if (data.getTrunkProxyPort() != null) {
                dataToSave.setTrunkProxyPort(data.getTrunkProxyPort());
            }
            if (data.getTrunkProxyPortTls() != null) {
                dataToSave.setTrunkProxyPortTls(data.getTrunkProxyPortTls());
            }
            if (data.getClusterKey() != null) {
                dataToSave.setClusterKey(data.getClusterKey());
            }
            if (data.getEnableBilling() != null) {
                dataToSave.setEnableBilling(data.getEnableBilling());
            }
            if (data.getIpRecordingServer() != null) {
                dataToSave.setIpRecordingServer(data.getIpRecordingServer());
            }
            if (data.getNodeCscf() != null) {
                dataToSave.setNodeCscf(data.getNodeCscf());
            }
            if (data.getCscfName() != null) {
                dataToSave.setCscfName(data.getCscfName());
            }
            if (data.getRouterId() != null) {
                dataToSave.setRouterId(data.getRouterId());
            }
            if (data.getEnableTrunkGatewayInService() != null) {
                dataToSave.setEnableTrunkGatewayInservice(data.getEnableTrunkGatewayInService());
            }
            if (data.getIpProxyCscf() != null) {
                dataToSave.setIpProxyCscf(data.getIpProxyCscf());
            }
            if (data.getMediaProxyPortsFrom() != null) {
                dataToSave.setMediaProxyPortsFrom(data.getMediaProxyPortsFrom());
            }
            if (data.getMediaProxyPortsTo() != null) {
                dataToSave.setMediaProxyPortsTo(data.getMediaProxyPortsTo());
            }
            if (data.getIpTrunkGateway() != null) {
                dataToSave.setIpTrunkGateway(data.getIpTrunkGateway());
            }
            if (data.getIpTrunkGatewayProxy() != null) {
                dataToSave.setIpTrunkGatewayProxy(data.getIpTrunkGatewayProxy());
            }
            if (data.getIpMediaProxy() != null) {
                dataToSave.setIpMediaProxy(data.getIpMediaProxy());
            }
            if (data.getIpAdditional() != null) {
                dataToSave.setIpAdditional(data.getIpAdditional());
            }
            if (data.getFeatureMediaPortsFrom() != null) {
                dataToSave.setFeatureMediaPortsFrom(data.getFeatureMediaPortsFrom());
            }
            if (data.getFeatureMediaPortsTo() != null) {
                dataToSave.setFeatureMediaPortsTo(data.getFeatureMediaPortsTo());
            }
            if (data.getTrunkMediaPortsFrom() != null) {
                dataToSave.setTrunkMediaPortsFrom(data.getTrunkMediaPortsFrom());
            }
            if (data.getTrunkMediaPortsTo() != null) {
                dataToSave.setTrunkMediaPortsTo(data.getTrunkMediaPortsTo());
            }
            if (data.getGateway() != null) {
                dataToSave.setGateway(data.getGateway());
            }
            if (data.getStickyIp() != null) {
                dataToSave.setStickyIp(data.getStickyIp());
            }
            if (data.getScadaServers() != null) {
                dataToSave.setScadaServers(data.getScadaServers());
            }
            if (data.getSnmpTrapReceiveIp() != null) {
                dataToSave.setSnmpTrapReceiveIp(data.getSnmpTrapReceiveIp());
            }
            if (data.getSnmpTrapReceivePort() != null) {
                dataToSave.setSnmpTrapReceivePort(data.getSnmpTrapReceivePort());
            }
            if (data.getSnmpTrapSendIp() != null) {
                dataToSave.setSnmpTrapSendIp(data.getSnmpTrapSendIp());
            }
            if (data.getSnmpTrapSendPort() != null) {
                dataToSave.setSnmpTrapSendPort(data.getSnmpTrapSendPort());
            }
            if (data.getSnmpEventSendIp() != null) {
                dataToSave.setSnmpEventSendIp(data.getSnmpEventSendIp());
            }
            if (data.getSnmpEventSendPort() != null) {
                dataToSave.setSnmpEventSendPort(data.getSnmpEventSendPort());
            }
            if (data.getEnableRedisPubSub() != null) {
                dataToSave.setEnableRedisPubSub(data.getEnableRedisPubSub());
            }
            if (data.getEnableNms() != null) {
                dataToSave.setEnableNms(data.getEnableNms());
            }
            if (data.getCentralNmsRedisIp() != null) {
                dataToSave.setCentralNmsRedisIp(data.getCentralNmsRedisIp());
            }
            if (data.getCentralNmsRedisPort() != null) {
                dataToSave.setCentralNmsRedisPort(data.getCentralNmsRedisPort());
            }
            if (data.getServerRluCode() != null) {
                dataToSave.setServerRluCode(data.getServerRluCode());
            }
            if (data.getDiscoveryDuration() != null) {
                dataToSave.setDiscoveryDuration(data.getDiscoveryDuration());
            }
            if (data.getDiscoveryTimeout() != null) {
                dataToSave.setDiscoveryTimeout(data.getDiscoveryTimeout());
            }
            if (data.getIcmpCheckThreads() != null) {
                dataToSave.setIcmpCheckThreads(data.getIcmpCheckThreads());
            }
            if (data.getIpCountEachThread() != null) {
                dataToSave.setIpCountEachThread(data.getIpCountEachThread());
            }
            if (data.getScAdaPort() != null) {
                dataToSave.setScAdaPort(data.getScAdaPort());
            }
            if (data.getNode() != null) {
                dataToSave.setNode(data.getNode());
            }
            if (data.getGroupCode() != null) {
                dataToSave.setGroupCode(data.getGroupCode());
            }
            if (data.getRecordingMode() != null) {
                dataToSave.setRecordingMode(data.getRecordingMode());
            }
            if (data.getDomain() != null) {
                dataToSave.setDomain(data.getDomain());
            }
            this.nodeClusterRepository.save((Object)dataToSave);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Data updated successfully");
        } else {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Unable to find the record");
        }
        logger.info(returnValue.getMessage() + "of node cluster");
        return returnValue;
    }

    public RequestResponse delete(InputIdModel dataToDelete) {
        RequestResponse returnValue = new RequestResponse();
        for (Long row : dataToDelete.getId()) {
            this.nodeClusterRepository.deleteById((Object)row);
        }
        returnValue.setMessage("node data deleted successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse bulkUpdate(NodeClusterModelBulk data) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setStatus(Constants.Error.OK);
        StringBuilder message = new StringBuilder();
        for (Long row : data.getId()) {
            Optional currentRecord = this.nodeClusterRepository.findById((Object)row);
            if (currentRecord.isPresent()) {
                NodeCluster dataToSave = (NodeCluster)currentRecord.get();
                if (data.getData().getNodeName() != null) {
                    dataToSave.setNodeName(data.getData().getNodeName());
                }
                if (data.getData().getHostIP0() != null) {
                    dataToSave.setHostIP0(data.getData().getHostIP0());
                }
                if (data.getData().getHostIP1() != null) {
                    dataToSave.setHostIP1(data.getData().getHostIP1());
                }
                if (data.getData().getControlIP() != null) {
                    dataToSave.setControlIP(data.getData().getControlIP());
                }
                if (data.getData().getMmeIP() != null) {
                    dataToSave.setMmeIP(data.getData().getMmeIP());
                }
                if (data.getData().getCscf() != null) {
                    dataToSave.setCscf(data.getData().getCscf());
                }
                if (data.getData().getFeature() != null) {
                    dataToSave.setFeature(data.getData().getFeature());
                }
                if (data.getData().getTrunk() != null) {
                    dataToSave.setTrunk(data.getData().getTrunk());
                }
                if (data.getData().getHostGateway() != null) {
                    dataToSave.setHostGateway(data.getData().getHostGateway());
                }
                if (data.getData().getCscfGateway() != null) {
                    dataToSave.setCscfGateway(data.getData().getCscfGateway());
                }
                if (data.getData().getHostSubnet() != null) {
                    dataToSave.setHostSubnet(data.getData().getHostSubnet());
                }
                if (data.getData().getCscfSubnet() != null) {
                    dataToSave.setCscfSubnet(data.getData().getCscfSubnet());
                }
                if (data.getData().getMcc() != null) {
                    dataToSave.setMcc(data.getData().getMcc());
                }
                if (data.getData().getMnc() != null) {
                    dataToSave.setMnc(data.getData().getMnc());
                }
                if (data.getData().getPassType() != null) {
                    dataToSave.setPassType(data.getData().getPassType());
                }
                if (data.getData().getAmf() != null) {
                    dataToSave.setAmf(data.getData().getAmf());
                }
                if (data.getData().getSd() != null) {
                    dataToSave.setSd(data.getData().getSd());
                }
                if (data.getData().getMode() != null) {
                    dataToSave.setMode(data.getData().getMode());
                }
                if (data.getData().getTac() != null) {
                    dataToSave.setTac(data.getData().getTac());
                }
                if (data.getData().getMmeMNC() != null) {
                    dataToSave.setMmeMNC(data.getData().getMmeMNC());
                }
                if (data.getData().getDomain() != null) {
                    dataToSave.setDomain(data.getData().getDomain());
                }
                this.nodeClusterRepository.save((Object)dataToSave);
                message.append(MessageFormat.format("Data Updated successfully for id {0}.{1}", row, System.lineSeparator()));
                continue;
            }
            message.append(MessageFormat.format("Unable to locate data successfully for id {0}.{1}", row, System.lineSeparator()));
        }
        returnValue.setMessage("Data Processed");
        returnValue.setMessageDetail(message.toString());
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse publish(Boolean generateFile) {
        RequestResponse returnValue = new RequestResponse();
        String clusterConfiguration = "/tmp/coral-test";
        String hostNameFilePath = "/etc/hostname";
        File SIPTrunkActiveFolder = new File("/etc/coraltele/siptrunk/active");
        File[] jsonFiles = SIPTrunkActiveFolder.listFiles();
        List nodeList = this.nodeClusterRepository.findAllByOrderByNodeName();
        List cScfTrueList = this.nodeClusterRepository.findByNodeCscfIsTrue();
        List routeList = this.routeRepo.findAll();
        List wanList = this.wanRepo.findAll();
        try {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(hostNameFilePath));
                Object object = null;
                try {
                    String hostname;
                    Constants.hostName = hostname = reader.readLine();
                    logger.info("Current Machine hostname: {}", (Object)Constants.hostName);
                }
                catch (Throwable hostname) {
                    object = hostname;
                    throw hostname;
                }
                finally {
                    if (reader != null) {
                        if (object != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable hostname) {
                                ((Throwable)object).addSuppressed(hostname);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                logger.error("Unable to read hostname from file", (Throwable)e);
            }
            if (!Constants.hostName.equalsIgnoreCase("Naveens-MacBook-Pro.local")) {
                clusterConfiguration = "/etc/default/coral";
            }
            logger.info("Cluster Configuration to {}", (Object)clusterConfiguration);
            if (nodeList.size() > 0) {
                NodeCluster currentNode = null;
                for (NodeCluster node : nodeList) {
                    if (!node.getNodeName().equals(Constants.hostName)) continue;
                    currentNode = node;
                    break;
                }
                if (currentNode != null) {
                    Object trunkMediaPorts;
                    Object featureMediaPorts;
                    Object mediaProxyPorts;
                    Object section;
                    if (generateFile.booleanValue()) {
                        String newClusterConfiguration;
                        clusterConfiguration = newClusterConfiguration = "/tmp/preview";
                        logger.info("Generating file at {}", (Object)clusterConfiguration);
                    }
                    String url = "http://" + currentNode.getSnmpEventSendIp() + ":" + currentNode.getSnmpEventSendPort() + "/sendTrap";
                    File existingFile = new File(clusterConfiguration);
                    if (existingFile.exists()) {
                        existingFile.delete();
                    }
                    File newFile = new File(clusterConfiguration);
                    newFile.createNewFile();
                    Wini ini = new Wini(newFile);
                    IniPreferences configuration = new IniPreferences((Ini)ini);
                    configuration.node("CLUSTER").put("VER", "2");
                    configuration.node("CLUSTER").putInt("Nodes", nodeList.size());
                    configuration.node("CLUSTER").putInt("CSCF", cScfTrueList.size());
                    configuration.node("CLUSTER").putInt("ROUTES", routeList.size());
                    configuration.node("CLUSTER").putInt("WANS", wanList.size());
                    configuration.node("CLUSTER").putInt("ISP", jsonFiles.length);
                    configuration.node("CLUSTER").put("DOMAIN", currentNode.getDomain() != null ? currentNode.getDomain().toLowerCase() : "");
                    configuration.node("CLUSTER").put("AMQ", "2");
                    configuration.node("CLUSTER").put("BILLING_VERSION", "3");
                    configuration.node("CLUSTER").put("UC_VERSION", "3");
                    configuration.node("CLUSTER").put("CALL_CENTER_VERSION", "0");
                    if (currentNode.getRecordingMode() == null) {
                        configuration.node("CLUSTER").put("PCAPFILEMODE", "");
                    } else {
                        configuration.node("CLUSTER").putInt("PCAPFILEMODE", currentNode.getRecordingMode());
                    }
                    if (currentNode.getTls() != null) {
                        if (currentNode.getTls().booleanValue()) {
                            configuration.node("CLUSTER").put("TLS", "Y");
                        } else {
                            configuration.node("CLUSTER").put("TLS", "N");
                        }
                    } else {
                        configuration.node("CLUSTER").put("TLS", "");
                    }
                    if (currentNode.getSbcUsersPort() != null) {
                        configuration.node("CLUSTER").putInt("SBC_USERS_PORT", currentNode.getSbcUsersPort());
                    } else {
                        configuration.node("CLUSTER").put("SBC_USERS_PORT", " ");
                    }
                    if (currentNode.getSbcUsersPortTls() != null) {
                        configuration.node("CLUSTER").putInt("SBC_USERS_PORT_TLS", currentNode.getSbcUsersPortTls());
                    } else {
                        configuration.node("CLUSTER").put("SBC_USERS_PORT_TLS", " ");
                    }
                    if (currentNode.getFeatureUsersPort() != null) {
                        configuration.node("CLUSTER").putInt("FEATURE_USERS_PORT", currentNode.getFeatureUsersPort());
                    } else {
                        configuration.node("CLUSTER").put("FEATURE_USERS_PORT", "");
                    }
                    if (currentNode.getFeatureUsersPortTls() != null) {
                        configuration.node("CLUSTER").putInt("FEATURE_USERS_PORT_TLS", currentNode.getFeatureUsersPortTls());
                    } else {
                        configuration.node("CLUSTER").put("FEATURE_USERS_PORT_TLS", "");
                    }
                    if (currentNode.getTrunkGatewayPort() != null) {
                        configuration.node("CLUSTER").putInt("TRUNK_GATEWAY_PORT", currentNode.getTrunkGatewayPort());
                    } else {
                        configuration.node("CLUSTER").put("TRUNK_GATEWAY_PORT", "");
                    }
                    if (currentNode.getTrunkGatewayPortTls() != null) {
                        configuration.node("CLUSTER").putInt("TRUNK_GATEWAY_PORT_TLS", currentNode.getTrunkGatewayPortTls());
                    } else {
                        configuration.node("CLUSTER").put("TRUNK_GATEWAY_PORT_TLS", "");
                    }
                    if (currentNode.getTrunkProxyPort() != null) {
                        configuration.node("CLUSTER").putInt("TRUNK_PROXY_PORT", currentNode.getTrunkProxyPort());
                    } else {
                        configuration.node("CLUSTER").put("TRUNK_PROXY_PORT", "");
                    }
                    if (currentNode.getTrunkProxyPortTls() != null) {
                        configuration.node("CLUSTER").putInt("TRUNK_PROXY_PORT_TLS", currentNode.getTrunkProxyPortTls());
                    } else {
                        configuration.node("CLUSTER").put("TRUNK_PROXY_PORT_TLS", "");
                    }
                    configuration.node("CLUSTER").put("CLUSTER-KEY", currentNode.getClusterKey() != null ? currentNode.getClusterKey() : "");
                    configuration.node("CLUSTER").put("PARALLEL-THREAD", "1");
                    configuration.node("NMS").put("SCADA-SERVERS", currentNode.getScadaServers() != null ? currentNode.getScadaServers().toLowerCase() : "");
                    configuration.node("NMS").put("SNMP-TRAP-RECEIVE-IP", currentNode.getSnmpTrapReceiveIp() != null ? currentNode.getSnmpTrapReceiveIp().toLowerCase() : "");
                    if (currentNode.getSnmpTrapReceivePort() != null) {
                        configuration.node("NMS").putInt("SNMP-TRAP-RECEIVE-PORT", currentNode.getSnmpTrapReceivePort());
                    } else {
                        configuration.node("NMS").put("SNMP-TRAP-RECEIVE-PORT", "");
                    }
                    configuration.node("NMS").put("SNMP-TRAP-SEND-IP", currentNode.getSnmpTrapSendIp() != null ? currentNode.getSnmpTrapSendIp().toLowerCase() : "");
                    if (currentNode.getSnmpTrapSendPort() != null) {
                        configuration.node("NMS").putInt("SNMP-TRAP-SEND-PORT", currentNode.getSnmpTrapSendPort());
                    } else {
                        configuration.node("NMS").put("SNMP-TRAP-SEND-PORT", "");
                    }
                    configuration.node("NMS").put("SNMP-EVENT-SEND-URL", url);
                    if (currentNode.getDiscoveryDuration() != null) {
                        configuration.node("NMS").putInt("DISCOVERY-DURATION", currentNode.getDiscoveryDuration());
                    } else {
                        configuration.node("NMS").put("DISCOVERY-DURATION", "");
                    }
                    if (currentNode.getDiscoveryTimeout() != null) {
                        configuration.node("NMS").putInt("DISCOVERY-TIMEOUT", currentNode.getDiscoveryTimeout());
                    } else {
                        configuration.node("NMS").put("DISCOVERY-TIMEOUT", "");
                    }
                    if (currentNode.getIcmpCheckThreads() != null) {
                        configuration.node("NMS").putInt("ICMP-CHECK-THREADS", currentNode.getIcmpCheckThreads());
                    } else {
                        configuration.node("NMS").put("ICMP-CHECK-THREADS", "");
                    }
                    if (currentNode.getIpCountEachThread() != null) {
                        configuration.node("NMS").putInt("IP-COUNT-EACH-THREAD", currentNode.getIpCountEachThread());
                    } else {
                        configuration.node("NMS").put("IP-COUNT-EACH-THREAD", "");
                    }
                    if (currentNode.getScAdaPort() != null) {
                        configuration.node("NMS").putInt("SCADA-PORT", currentNode.getScAdaPort());
                    } else {
                        configuration.node("NMS").put("SCADA-PORT", "");
                    }
                    if (currentNode.getEnableRedisPubSub() != null) {
                        if (currentNode.getEnableRedisPubSub().booleanValue()) {
                            configuration.node("NMS").put("ENABLE-REDIS-PUB-SUB", "Y");
                        } else {
                            configuration.node("NMS").put("ENABLE-REDIS-PUB-SUB", "N");
                        }
                    } else {
                        configuration.node("NMS").put("ENABLE-REDIS-PUB-SUB", "");
                    }
                    if (currentNode.getEnableNms() != null) {
                        if (currentNode.getEnableNms().booleanValue()) {
                            configuration.node("NMS").put("ENABLE-NMS", "Y");
                        } else {
                            configuration.node("NMS").put("ENABLE-NMS", "N");
                        }
                    } else {
                        configuration.node("NMS").put("ENABLE-NMS", "");
                    }
                    configuration.node("NMS").put("CENTRAL-NMS-REDIS-IP", currentNode.getCentralNmsRedisIp() != null ? currentNode.getCentralNmsRedisIp().toLowerCase() : "");
                    if (currentNode.getCentralNmsRedisPort() != null) {
                        configuration.node("NMS").putInt("CENTRAL-NMS-REDIS-PORT", currentNode.getCentralNmsRedisPort());
                    } else {
                        configuration.node("NMS").put("CENTRAL-NMS-REDIS-PORT", "");
                    }
                    configuration.node("NMS").put("SERVER-RLU-CODE", currentNode.getServerRluCode() != null ? currentNode.getServerRluCode().toLowerCase() : "");
                    if (currentNode.getMmeIP() != null && !currentNode.getMmeIP().isEmpty()) {
                        configuration.node("MOBILITY").put("MCC", currentNode.getMcc() != null ? currentNode.getMcc().toLowerCase() : "");
                        configuration.node("MOBILITY").put("MNC", currentNode.getMnc() != null ? currentNode.getMnc().toLowerCase() : "");
                        configuration.node("MOBILITY").put("MME-MNC", currentNode.getMmeMNC() != null ? currentNode.getMmeMNC().toLowerCase() : "");
                        configuration.node("MOBILITY").put("TAC", currentNode.getTac() != null ? currentNode.getTac().toLowerCase() : "");
                        configuration.node("MOBILITY").put("PASS-TYPE", currentNode.getPassType() != null ? currentNode.getPassType().toLowerCase() : "");
                        configuration.node("MOBILITY").put("AMF", currentNode.getAmf() != null ? currentNode.getAmf() : "");
                        configuration.node("MOBILITY").put("SD", currentNode.getSd() != null ? currentNode.getSd().toLowerCase() : "");
                        configuration.node("MOBILITY").put("MODE", currentNode.getMode() != null ? currentNode.getMode().toLowerCase() : "");
                    }
                    Integer i = 0;
                    for (NodeCluster node : cScfTrueList) {
                        Integer n = i;
                        Integer n2 = i = Integer.valueOf(i + 1);
                        section = "CSCF-" + i.toString();
                        mediaProxyPorts = node.getMediaProxyPortsFrom() + "-" + node.getMediaProxyPortsTo();
                        featureMediaPorts = node.getFeatureMediaPortsFrom() + "-" + node.getFeatureMediaPortsTo();
                        trunkMediaPorts = node.getTrunkMediaPortsFrom() + "-" + node.getTrunkMediaPortsTo();
                        configuration.node((String)section).put("NAME", node.getCscfName() != null ? node.getCscfName().toLowerCase() : "");
                        if (node.getRouterId() != null) {
                            configuration.node((String)section).putInt("ROUTER-ID", node.getRouterId());
                        } else {
                            configuration.node((String)section).put("ROUTER-ID", "");
                        }
                        configuration.node((String)section).put("GROUP-CODE", node.getGroupCode() != null ? node.getGroupCode().toLowerCase() : "");
                        if (node != null && node.getCscf() != null && !node.getCscf().equals(" ")) {
                            configuration.node((String)section).put("ENABLE-SERVICING-CSCF", "Y");
                        } else {
                            configuration.node((String)section).put("ENABLE-SERVICING-CSCF", "N");
                        }
                        if (node != null && node.getIpProxyCscf() != null && !node.getIpProxyCscf().equals(" ")) {
                            configuration.node((String)section).put("ENABLE-PROXY-CSCF", "Y");
                        } else {
                            configuration.node((String)section).put("ENABLE-PROXY-CSCF", "N");
                        }
                        if (node != null && node.getFeature() != null && !node.getFeature().equals(" ")) {
                            configuration.node((String)section).put("ENABLE-FEATURE-SERVER", "Y");
                        } else {
                            configuration.node((String)section).put("ENABLE-FEATURE-SERVER", "N");
                        }
                        if (node != null && node.getIpTrunkGateway() != null && !node.getIpTrunkGateway().equals(" ")) {
                            configuration.node((String)section).put("ENABLE-TRUNK-GATEWAY", "Y");
                        } else {
                            configuration.node((String)section).put("ENABLE-TRUNK-GATEWAY", "N");
                        }
                        if (node != null && node.getIpTrunkGatewayProxy() != null && !node.getIpTrunkGatewayProxy().equals(" ")) {
                            configuration.node((String)section).put("ENABLE-TRUNK-GATEWAY-PROXY", "Y");
                        } else {
                            configuration.node((String)section).put("ENABLE-TRUNK-GATEWAY-PROXY", "N");
                        }
                        if (node != null && node.getIpMediaProxy() != null && !node.getIpMediaProxy().equals(" ")) {
                            configuration.node((String)section).put("ENABLE-MEDIA-PROXY", "Y");
                        } else {
                            configuration.node((String)section).put("ENABLE-MEDIA-PROXY", "N");
                        }
                        String controlIP = node.getControlIP() != null && !node.getControlIP().isEmpty() ? node.getControlIP() : " ";
                        configuration.node((String)section).put("IP", controlIP);
                        configuration.node((String)section).put("IP-SERVICING-CSCF", node.getCscf() != null ? node.getCscf().toLowerCase() : "");
                        String ipProxyCscf = node.getIpProxyCscf() != null && !node.getIpProxyCscf().isEmpty() ? node.getIpProxyCscf().toLowerCase() : " ";
                        configuration.node((String)section).put("IP-PROXY-CSCF", ipProxyCscf);
                        String feature = node.getFeature() != null && !node.getFeature().isEmpty() ? node.getFeature().toLowerCase() : " ";
                        configuration.node((String)section).put("IP-FEATURE-SERVER", feature);
                        String ipTrunkGateway = node.getIpTrunkGateway() != null && !node.getIpTrunkGateway().isEmpty() ? node.getIpTrunkGateway().toLowerCase() : " ";
                        configuration.node((String)section).put("IP-TRUNK-GATEWAY", ipTrunkGateway);
                        String ipTrunkGatewayProxy = node.getIpTrunkGatewayProxy() != null && !node.getIpTrunkGatewayProxy().isEmpty() ? node.getIpTrunkGatewayProxy() : " ";
                        configuration.node((String)section).put("IP-TRUNK-GATEWAY-PROXY", ipTrunkGatewayProxy.toLowerCase());
                        String ipMediaProxy = node.getIpMediaProxy() != null && !node.getIpMediaProxy().isEmpty() ? node.getIpMediaProxy() : " ";
                        configuration.node((String)section).put("IP-MEDIA-PROXY", ipMediaProxy.toLowerCase());
                        String mmeIP = node.getMmeIP() != null && !node.getMmeIP().isEmpty() ? node.getMmeIP() : " ";
                        configuration.node((String)section).put("IP-MME", mmeIP.toLowerCase());
                        String ipAdditional = node.getIpAdditional() != null && !node.getIpAdditional().isEmpty() ? node.getIpAdditional() : " ";
                        configuration.node((String)section).put("IP-ADDITIONAL", ipAdditional.toLowerCase());
                        configuration.node((String)section).put("MEDIA-PROXY-PORTS", ((String)mediaProxyPorts).toLowerCase());
                        configuration.node((String)section).put("FEATURE-MEDIA-PORTS", ((String)featureMediaPorts).toLowerCase());
                        configuration.node((String)section).put("TRUNK-MEDIA-PORTS", ((String)trunkMediaPorts).toLowerCase());
                        if (node.getCscfSubnet() != null) {
                            configuration.node((String)section).putInt("CIDR", node.getCscfSubnet());
                        } else {
                            configuration.node((String)section).put("CIDR", "");
                        }
                        String gateway = node.getGateway() != null && !node.getGateway().isEmpty() ? node.getGateway() : " ";
                        configuration.node((String)section).put("GATEWAY", gateway.toLowerCase());
                        String cScfGateway = node.getCscfGateway() != null && !node.getCscfGateway().isEmpty() ? node.getCscfGateway() : " ";
                        configuration.node((String)section).put("CSCF-GATEWAY", cScfGateway.toLowerCase());
                        if (node.getStickyIp() != null && !node.getIpMediaProxy().equals(" ")) {
                            if (node.getStickyIp().booleanValue()) {
                                configuration.node((String)section).put("STICKY-IP", "Y");
                            } else {
                                configuration.node((String)section).put("STICKY-IP", "N");
                            }
                        } else {
                            configuration.node((String)section).put("STICKY-IP", "");
                        }
                        String nodeName = node.getNode() != null && !node.getNode().isEmpty() ? node.getNode() : " ";
                        configuration.node((String)section).put("NODES", nodeName.toLowerCase());
                    }
                    i = 0;
                    for (NodeCluster node : nodeList) {
                        section = i;
                        i = i + 1;
                        mediaProxyPorts = i;
                        section = "NODE-" + i.toString();
                        configuration.node((String)section).put("NAME", node.getNodeName() != null ? node.getNodeName() : "");
                        configuration.node((String)section).put("HOSTIP0", node.getHostIP0() != null ? node.getHostIP0() : "");
                        configuration.node((String)section).put("GATEWAY", node.getHostGateway() != null ? node.getHostGateway() : "");
                        if (node.getHostSubnet() != null) {
                            configuration.node((String)section).putInt("CIDR", node.getHostSubnet());
                        } else {
                            configuration.node((String)section).put("CIDR", "");
                        }
                        configuration.node((String)section).put("HOSTIP1", node.getHostIP1() != null ? node.getHostIP1() : "");
                        if (node.getEnableBilling() != null) {
                            if (node.getEnableBilling().booleanValue()) {
                                configuration.node((String)section).put("ENABLE-Billing", "Y");
                            } else {
                                configuration.node((String)section).put("ENABLE-Billing", "N");
                            }
                        } else {
                            configuration.node((String)section).put("ENABLE-Billing", "N");
                        }
                        configuration.node((String)section).put("IP-RECORDING-SERVER", node.getIpRecordingServer() != null ? node.getIpRecordingServer() : "");
                        if (node.getNodeCscf() != null) {
                            if (node.getNodeCscf().booleanValue()) {
                                configuration.node((String)section).put("NODE-CSCF", "Y");
                                continue;
                            }
                            configuration.node((String)section).put("NODE-CSCF", "N");
                            continue;
                        }
                        configuration.node((String)section).put("NODE-CSCF", "");
                    }
                    i = 0;
                    for (Routes route : routeList) {
                        section = i;
                        i = i + 1;
                        mediaProxyPorts = i;
                        section = "ROUTE-" + i.toString();
                        configuration.node((String)section).put("IP", route.getIp() != null ? route.getIp().toLowerCase() : "");
                        configuration.node((String)section).put("GW", route.getGateway() != null ? route.getGateway().toLowerCase() : "");
                        if (route.getCidr() != null) {
                            configuration.node((String)section).putInt("CIDR", route.getCidr());
                        } else {
                            configuration.node((String)section).put("CIDR", "");
                        }
                        configuration.node((String)section).put("INTERFACE", route.getInterfaces() != null ? route.getInterfaces().toLowerCase() : "");
                        configuration.node((String)section).put("NODES", route.getNodes() != null ? route.getNodes().toLowerCase() : "");
                    }
                    i = 0;
                    for (WAns wan : wanList) {
                        section = i;
                        i = i + 1;
                        mediaProxyPorts = i;
                        section = "WAN-" + i.toString();
                        configuration.node((String)section).put("NAME", wan.getName() != null ? wan.getName().toLowerCase() : "");
                        configuration.node((String)section).put("IP-LOCAL", wan.getIpLocal() != null ? wan.getIpLocal().toLowerCase() : "");
                        configuration.node((String)section).put("IP-PUBLIC", wan.getIpPublic() != null ? wan.getIpPublic().toLowerCase() : "");
                        configuration.node((String)section).put("IP-REMOTE", wan.getIpRemote() != null ? wan.getIpRemote().toLowerCase() : "");
                        configuration.node((String)section).put("WAN-TYPE", wan.getWanType() != null ? wan.getWanType().toLowerCase() : "");
                    }
                    i = 0;
                    if (jsonFiles != null) {
                        for (File jsonFile : jsonFiles) {
                            featureMediaPorts = i;
                            i = i + 1;
                            trunkMediaPorts = i;
                            String section2 = "ISP-" + i;
                            try {
                                ObjectMapper objectMapper = new ObjectMapper();
                                List listOfData = (List)objectMapper.readValue(jsonFile, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                                for (SIPTrunkModel node : listOfData) {
                                    configuration.node(section2).put(node.getName(), node.getValue());
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                logger.error(e.getMessage());
                            }
                        }
                    }
                    ini.store();
                    String command = null;
                    String commandOutput = null;
                    if (generateFile.booleanValue()) {
                        returnValue.setData((Object)this.getFileContent(clusterConfiguration));
                    } else {
                        command = "configure-node";
                        commandOutput = this.shellCommand.executeCommand(command);
                        returnValue.setData((Object)commandOutput);
                    }
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("file Published successfully");
                    logger.info("output get from configure-node cmd:", (Object)commandOutput);
                } else {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("file failed to publish!");
                    returnValue.setMessageDetail("one node must be present of::" + Constants.hostName);
                    logger.info(returnValue.getMessage() + ":" + returnValue.getMessageDetail());
                }
            } else if (nodeList.size() == 0) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No node present");
                returnValue.setMessageDetail("Publish Fail");
                logger.error("Data not present", (Object)returnValue.getMessage(), (Object)returnValue.getMessageDetail());
            }
        }
        catch (IOException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("contact to administrator");
            logger.error("Unable to read property file", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse listOfNodes() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList node = new ArrayList();
        List list = this.nodeClusterRepository.findAll();
        if (!list.isEmpty()) {
            list.forEach(row -> {
                NodesModel data = new NodesModel(row.getId(), row.getNodeName(), row.getHostIP0());
                node.add(data);
            });
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("list of nodes");
            returnValue.setData(node);
        } else {
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Empty list of nodes!");
        }
        return returnValue;
    }

    public RequestResponse updateNode(UpdateNodesModel data) {
        RequestResponse returnValue = new RequestResponse();
        Optional currentRecord = this.nodeClusterRepository.findById((Object)data.getId());
        if (currentRecord.isPresent()) {
            NodeCluster dataToSave = (NodeCluster)currentRecord.get();
            List nodesList = data.getNodeName();
            if (nodesList != null) {
                String nodesString = String.join((CharSequence)",", nodesList);
                dataToSave.setNode(nodesString);
            }
            this.nodeClusterRepository.save((Object)dataToSave);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Node added successfully");
            logger.info("nodes added successfully");
        } else {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error occurred on addition of nodes");
            logger.error("unable to add nodes", (Object)returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse decryptClusterKey() throws Exception {
        RequestResponse returnValue = new RequestResponse();
        String path = "/etc/default/coral";
        try (BufferedReader reader = new BufferedReader(new FileReader(path));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("CLUSTER-KEY")) continue;
                String encryptedKey = line.substring(line.indexOf("=") + 1).trim();
                HashMap<String, String> map = new HashMap<String, String>();
                String decryptedKey = this.key.decrypt(encryptedKey);
                map.put("cluster", decryptedKey);
                returnValue.setMessage("actual key");
                returnValue.setMessageDetail("cluster key decrypt successfully");
                returnValue.setData(map);
                logger.info(returnValue.getMessageDetail());
                break;
            }
        }
        catch (IOException e) {
            returnValue.setMessage("failed at decryption");
            returnValue.setMessageDetail("cluster key decrypt failed");
            logger.error(returnValue.getMessageDetail() + e.getMessage(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse uploadDataFromJsonFile(MultipartFile jsonFile) {
        RequestResponse returnValue = new RequestResponse();
        try {
            if (jsonFile.isEmpty()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("File is empty!");
                returnValue.setMessageDetail("Please provide a valid JSON file.");
                logger.info("JSON File is empty. {}", (Object)returnValue.getMessageDetail());
                return returnValue;
            }
            this.nodeClusterRepository.deleteAll();
            this.routeRepo.deleteAll();
            this.wanRepo.deleteAll();
            ObjectMapper objectMapper = new ObjectMapper();
            CoralConfigurationModel configuration = (CoralConfigurationModel)objectMapper.readValue(jsonFile.getInputStream(), CoralConfigurationModel.class);
            List nodes = configuration.getNodes();
            List routeNodes = configuration.getRoutes();
            List wanNodes = configuration.getWAns();
            this.nodeClusterRepository.saveAll((Iterable)nodes);
            this.routeRepo.saveAll((Iterable)routeNodes);
            this.wanRepo.saveAll((Iterable)wanNodes);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Data from JSON file successfully uploaded !");
            returnValue.setMessageDetail("file successfully uploaded to database");
            logger.info("file uploaded successfully to the tables.");
        }
        catch (IOException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Something went wrong!");
            returnValue.setMessageDetail("Contact to administrator");
            logger.error("Error occurred while reading or parsing the JSON file. {}", (Object)e.getMessage(), (Object)e);
        }
        return returnValue;
    }

    public RequestResponse updateHostName(HostnameModel data) throws IOException {
        String hostNamePath = "/etc/hostname";
        RequestResponse returnValue = new RequestResponse();
        ArrayList<HostnameModel> addValue = new ArrayList<HostnameModel>();
        File file = new File(hostNamePath);
        if (!file.exists()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("file not exist");
            returnValue.setMessageDetail("hostname file doesn't exist at:" + hostNamePath);
            logger.info(returnValue.getMessageDetail());
        } else {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                writer.write(data.getHostname());
                writer.newLine();
                writer.flush();
            }
            catch (IOException e) {
                logger.error("Error writing to file: " + e.getMessage());
            }
            addValue.add(data);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Updated");
            returnValue.setMessageDetail("Hostname Updated Successfully");
            returnValue.setData(addValue);
            logger.info(returnValue.getMessageDetail());
        }
        return returnValue;
    }

    public RequestResponse getHostName() throws IOException {
        String hostNamePath = "/etc/hostname";
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        File file = new File(hostNamePath);
        if (!file.exists()) {
            logger.info("File does not exist");
        } else {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                StringBuilder data = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    data.append(line);
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", "1");
                map.put("hostname", data.toString());
                addValue.add(map);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Retrieved ");
                returnValue.setMessageDetail("Data Retrieved Successfully");
                returnValue.setData(addValue);
            }
            catch (IOException e) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("contact to administrator ");
                logger.error("Error while reading host file: " + e.getMessage(), (Throwable)e);
            }
        }
        return returnValue;
    }

    private String getFileContent(String filePath) throws IOException {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line);
                content.append(System.lineSeparator());
            }
        }
        return content.toString();
    }

    /*
     * Unable to fully structure code
     */
    public RequestResponse reversePublish() throws IOException {
        returnValue = new RequestResponse();
        coralFilePath = "/etc/default/coral";
        ispFilePath = "/etc/coraltele/siptrunk/active/";
        hostName = this.hostname();
        hostnameVerification = 0;
        backupFilePath = "/etc/default/coralToImport";
        coralFile = Paths.get(coralFilePath, new String[0]);
        backupCoralFile = Paths.get(backupFilePath, new String[0]);
        try {
            if (!Files.exists(backupCoralFile, new LinkOption[0])) {
                Files.copy(coralFile, backupCoralFile, new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES});
                NodeClusterService.logger.info("coralToImport backup file successfully generate");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            NodeClusterService.logger.error("Error creating backup file: " + e.getMessage());
        }
        file = new File(coralFilePath);
        try {
            ini = new Ini(file);
            clusterSection = (Profile.Section)ini.get((Object)"CLUSTER");
            if (clusterSection == null || clusterSection.size() < 10) ** GOTO lbl398
            node = (String)clusterSection.get((Object)"Nodes");
            cscf = (String)clusterSection.get((Object)"CSCF");
            route = (String)clusterSection.get((Object)"ROUTES");
            wan = (String)clusterSection.get((Object)"WANS");
            isp = (String)clusterSection.get((Object)"ISP");
            domain = (String)clusterSection.get((Object)"DOMAIN");
            pCapFileMode = (String)clusterSection.get((Object)"PCAPFILEMODE");
            tls = (String)clusterSection.get((Object)"TLS");
            sbcUsersPort = (String)clusterSection.get((Object)"SBC_USERS_PORT");
            sbcUsersPortTls = (String)clusterSection.get((Object)"SBC_USERS_PORT_TLS");
            featureUsersPort = (String)clusterSection.get((Object)"FEATURE_USERS_PORT");
            featureUsersPortTls = (String)clusterSection.get((Object)"FEATURE_USERS_PORT_TLS");
            trunkGatewayPort = (String)clusterSection.get((Object)"TRUNK_GATEWAY_PORT");
            trunkGatewayPortTls = (String)clusterSection.get((Object)"TRUNK_GATEWAY_PORT_TLS");
            trunkProxyPort = (String)clusterSection.get((Object)"TRUNK_PROXY_PORT");
            trunkProxyPortTls = (String)clusterSection.get((Object)"TRUNK_PROXY_PORT_TLS");
            clusterKey = (String)clusterSection.get((Object)"CLUSTER-KEY");
            if (node != null && !node.equals("null") && !node.equals("")) {
                for (i = 1; i <= Integer.parseInt(node); ++i) {
                    nodeSectionName = "NODE-" + i;
                    nodeSection = (Profile.Section)ini.get((Object)nodeSectionName);
                    name = (String)nodeSection.get((Object)"NAME");
                    if (!name.equals(hostName)) continue;
                    ++hostnameVerification;
                    break;
                }
            }
            if (hostnameVerification <= 0) ** GOTO lbl395
            directory = new File(ispFilePath);
            if (!directory.exists()) {
                directory.mkdirs();
                System.out.println("Directory created for ISP: " + ispFilePath);
            }
            if (directory.isDirectory() && (files = directory.listFiles()) != null) {
                for (Profile.Section sipFile : files) {
                    if (!sipFile.isFile()) continue;
                    sipFile.delete();
                }
            }
            this.nodeClusterRepository.deleteAll();
            this.routeRepo.deleteAll();
            this.wanRepo.deleteAll();
            if (node != null && !node.equals("null") && !node.equals("")) {
                for (i = 1; i <= Integer.parseInt(node); ++i) {
                    nodeSectionName = "NODE-" + i;
                    nodeSection = (Profile.Section)ini.get((Object)nodeSectionName);
                    name = (String)nodeSection.get((Object)"NAME");
                    hostIp0 = (String)nodeSection.get((Object)"HOSTIP0");
                    gateway = (String)nodeSection.get((Object)"GATEWAY");
                    cidr = (String)nodeSection.get((Object)"CIDR");
                    hostIp1 = (String)nodeSection.get((Object)"HOSTIP1");
                    enableBilling = (String)nodeSection.get((Object)"ENABLE-Billing");
                    ipRecordingServer = (String)nodeSection.get((Object)"IP-RECORDING-SERVER");
                    nodeCscf = (String)nodeSection.get((Object)"NODE-CSCF");
                    data = new NodeCluster();
                    data.setNodeName(name);
                    if (hostIp0 != null && !hostIp0.equals("") && !hostIp0.equals("null")) {
                        data.setHostIP0(hostIp0);
                    }
                    if (gateway != null && !gateway.equals("") && !gateway.equals("null")) {
                        data.setHostGateway(gateway);
                    }
                    if (cidr != null && !cidr.isEmpty()) {
                        data.setHostSubnet(Integer.valueOf(Integer.parseInt(cidr)));
                    }
                    if (hostIp1 != null && !hostIp1.equals("") && !hostIp1.equals("null")) {
                        data.setHostIP1(hostIp1);
                    }
                    if (enableBilling != null && !enableBilling.equals("")) {
                        if (enableBilling.equals("Y")) {
                            data.setEnableBilling(Boolean.valueOf(true));
                        } else if (enableBilling.equals("N")) {
                            data.setEnableBilling(Boolean.valueOf(false));
                        }
                    }
                    if (ipRecordingServer != null && !ipRecordingServer.equals("") && !ipRecordingServer.equals("null")) {
                        data.setIpRecordingServer(ipRecordingServer);
                    }
                    if (nodeCscf != null && !nodeCscf.equals("")) {
                        if (nodeCscf.equals("Y")) {
                            data.setNodeCscf(Boolean.valueOf(true));
                        } else if (nodeCscf.equals("N")) {
                            data.setNodeCscf(Boolean.valueOf(false));
                        }
                    }
                    this.nodeClusterRepository.save((Object)data);
                }
                NodeClusterService.logger.info("Node section Retrieved Successfully");
                if (cscf != null && !cscf.equals("null") && !cscf.equals("")) {
                    for (i = 1; i <= Integer.parseInt(cscf); ++i) {
                        cscfSection = (Profile.Section)ini.get((Object)("CSCF-" + i));
                        nodesValue = (String)cscfSection.get((Object)"NODES");
                        name = (String)cscfSection.get((Object)"NAME");
                        routerId = (String)cscfSection.get((Object)"ROUTER-ID");
                        groupCode = (String)cscfSection.get((Object)"GROUP-CODE");
                        enableServicingCSCF = (String)cscfSection.get((Object)"ENABLE-SERVICING-CSCF");
                        enableProxyCSCF = (String)cscfSection.get((Object)"ENABLE-PROXY-CSCF");
                        enableFeatureServer = (String)cscfSection.get((Object)"ENABLE-FEATURE-SERVER");
                        enableTrunkGateway = (String)cscfSection.get((Object)"ENABLE-TRUNK-GATEWAY");
                        enableTrunkGatewayProxy = (String)cscfSection.get((Object)"ENABLE-TRUNK-GATEWAY-PROXY");
                        enableMediaProxy = (String)cscfSection.get((Object)"ENABLE-MEDIA-PROXY");
                        ip = (String)cscfSection.get((Object)"IP");
                        ipServicingCSCF = (String)cscfSection.get((Object)"IP-SERVICING-CSCF");
                        ipProxyCSCF = (String)cscfSection.get((Object)"IP-PROXY-CSCF");
                        ipFeatureServer = (String)cscfSection.get((Object)"IP-FEATURE-SERVER");
                        ipTrunkGateway = (String)cscfSection.get((Object)"IP-TRUNK-GATEWAY");
                        ipTrunkGatewayProxy = (String)cscfSection.get((Object)"IP-TRUNK-GATEWAY-PROXY");
                        ipMediaProxy = (String)cscfSection.get((Object)"IP-MEDIA-PROXY");
                        ipMME = (String)cscfSection.get((Object)"IP-MME");
                        ipAdditional = (String)cscfSection.get((Object)"IP-ADDITIONAL");
                        mediaProxyPorts = (String)cscfSection.get((Object)"MEDIA-PROXY-PORTS");
                        featureMediaPorts = (String)cscfSection.get((Object)"FEATURE-MEDIA-PORTS");
                        trunkMediaPorts = (String)cscfSection.get((Object)"TRUNK-MEDIA-PORTS");
                        cidr = (String)cscfSection.get((Object)"CIDR");
                        gateway = (String)cscfSection.get((Object)"GATEWAY");
                        cscfGateway = (String)cscfSection.get((Object)"CSCF-GATEWAY");
                        stickyIP = (String)cscfSection.get((Object)"STICKY-IP");
                        mediaProxyPortsArray = mediaProxyPorts.split("-");
                        featureMediaPortsArray = featureMediaPorts.split("-");
                        trunkMediaPortsArray = trunkMediaPorts.split("-");
                        mediaProxyPortsFrom = mediaProxyPortsArray[0].trim();
                        mediaProxyPortsTo = mediaProxyPortsArray[1].trim();
                        featureMediaPortsFrom = featureMediaPortsArray[0].trim();
                        featureMediaPortsTo = featureMediaPortsArray[1].trim();
                        trunkMediaPortsFrom = trunkMediaPortsArray[0].trim();
                        trunkMediaPortsTo = trunkMediaPortsArray[1].trim();
                        nodesArray = nodesValue.split(",");
                        cscfNode = nodesArray[0].trim();
                        data = this.nodeClusterRepository.findByNodeName(cscfNode);
                        if (!data.isPresent()) continue;
                        updateCscf = (NodeCluster)data.get();
                        if (mediaProxyPortsFrom != null && !mediaProxyPortsFrom.equals("null") && !mediaProxyPortsFrom.equals("")) {
                            updateCscf.setMediaProxyPortsFrom(Integer.valueOf(Integer.parseInt(mediaProxyPortsFrom)));
                        }
                        if (mediaProxyPortsTo != null && !mediaProxyPortsTo.equals("null") && !mediaProxyPortsTo.equals("")) {
                            updateCscf.setMediaProxyPortsTo(Integer.valueOf(Integer.parseInt(mediaProxyPortsTo)));
                        }
                        if (featureMediaPortsFrom != null && !featureMediaPortsFrom.equals("null") && !featureMediaPortsFrom.equals("")) {
                            updateCscf.setFeatureMediaPortsFrom(Integer.valueOf(Integer.parseInt(featureMediaPortsFrom)));
                        }
                        if (featureMediaPortsTo != null && !featureMediaPortsTo.equals("null") && !featureMediaPortsTo.equals("")) {
                            updateCscf.setFeatureMediaPortsTo(Integer.valueOf(Integer.parseInt(featureMediaPortsTo)));
                        }
                        if (trunkMediaPortsFrom != null && !trunkMediaPortsFrom.equals("null") && !trunkMediaPortsFrom.equals("")) {
                            updateCscf.setTrunkMediaPortsFrom(Integer.valueOf(Integer.parseInt(trunkMediaPortsFrom)));
                        }
                        if (trunkMediaPortsTo != null && !trunkMediaPortsTo.equals("null")) {
                            updateCscf.setTrunkMediaPortsTo(Integer.valueOf(Integer.parseInt(trunkMediaPortsTo)));
                        }
                        if (name != null) {
                            updateCscf.setCscfName(name);
                        }
                        if (routerId != null && !routerId.equals("null") && !routerId.equals("")) {
                            updateCscf.setRouterId(Integer.valueOf(Integer.parseInt(routerId)));
                        }
                        if (groupCode != null) {
                            updateCscf.setGroupCode(groupCode);
                        }
                        if (enableServicingCSCF != null) {
                            updateCscf.setCscf(enableServicingCSCF);
                        }
                        if (enableFeatureServer != null) {
                            updateCscf.setFeature(enableFeatureServer);
                        }
                        if (enableMediaProxy != null && !enableMediaProxy.equals("null") && !enableMediaProxy.equals("")) {
                            updateCscf.setIpMediaProxy(enableMediaProxy);
                        }
                        if (ip != null && !ip.equals("null") && !ip.equals("")) {
                            updateCscf.setControlIP(ip);
                        }
                        if (ipServicingCSCF != null && !ipServicingCSCF.equals("null") && !ipServicingCSCF.equals("")) {
                            updateCscf.setCscf(ipServicingCSCF);
                        }
                        if (ipProxyCSCF != null && !ipProxyCSCF.equals("null") && !ipProxyCSCF.equals("")) {
                            updateCscf.setIpProxyCscf(ipProxyCSCF);
                        }
                        if (ipFeatureServer != null) {
                            updateCscf.setFeature(ipFeatureServer);
                        }
                        if (ipTrunkGateway != null && !ipTrunkGateway.equals("null") && !ipTrunkGateway.equals("")) {
                            updateCscf.setIpTrunkGateway(ipTrunkGateway);
                        }
                        if (ipTrunkGatewayProxy != null && !ipTrunkGatewayProxy.equals("null") && !ipTrunkGatewayProxy.equals("")) {
                            updateCscf.setIpTrunkGatewayProxy(ipTrunkGatewayProxy);
                        }
                        if (ipMediaProxy != null) {
                            updateCscf.setIpMediaProxy(ipMediaProxy);
                        }
                        if (ipMME != null) {
                            updateCscf.setMmeIP(ipMME);
                        }
                        if (ipAdditional != null && !ipAdditional.equals("null") && !ipAdditional.equals("")) {
                            updateCscf.setIpAdditional(ipAdditional);
                        }
                        if (cidr != null && !cidr.equals("null") && !cidr.equals("")) {
                            updateCscf.setCscfSubnet(Integer.valueOf(Integer.parseInt(cidr)));
                        }
                        if (gateway != null && !gateway.equals("null") && !gateway.equals("")) {
                            updateCscf.setGateway(gateway);
                        }
                        if (cscfGateway != null && !cscfGateway.equals("null") && !cscfGateway.equals("")) {
                            updateCscf.setCscfGateway(cscfGateway);
                        }
                        if (stickyIP != null && !stickyIP.equals("") && !stickyIP.equals("null")) {
                            if (stickyIP.equals("Y")) {
                                updateCscf.setStickyIp(Boolean.valueOf(true));
                            } else if (stickyIP.equals("N")) {
                                updateCscf.setStickyIp(Boolean.valueOf(false));
                            }
                        }
                        if (nodesValue != null) {
                            updateCscf.setNode(nodesValue);
                        }
                        updateCscf.setNodeCscf(Boolean.valueOf(true));
                        this.nodeClusterRepository.save((Object)updateCscf);
                    }
                    NodeClusterService.logger.info("CSCF Section Retrieved Successfully.");
                }
                data = this.nodeClusterRepository.findByNodeName(hostName);
                NMSSection = (Profile.Section)ini.get((Object)"NMS");
                if (data.isPresent()) {
                    row = (NodeCluster)data.get();
                    row.setDomain(hostName);
                    if (domain != null) {
                        row.setDomain(domain);
                    }
                    if (pCapFileMode != null && !pCapFileMode.equals("null") && !pCapFileMode.equals("")) {
                        row.setRecordingMode(Integer.valueOf(Integer.parseInt(pCapFileMode)));
                    }
                    if (tls != null && !tls.equals("")) {
                        if (tls.equals("Y")) {
                            row.setTls(Boolean.valueOf(true));
                        } else if (tls.equals("N")) {
                            row.setTls(Boolean.valueOf(false));
                        }
                    }
                    if (sbcUsersPort != null && sbcUsersPort.equals("null") && sbcUsersPort.equals("")) {
                        row.setSbcUsersPort(Integer.valueOf(Integer.parseInt(sbcUsersPort)));
                    }
                    if (sbcUsersPortTls != null && !sbcUsersPortTls.equals("null") && !sbcUsersPortTls.equals("")) {
                        row.setSbcUsersPortTls(Integer.valueOf(Integer.parseInt(sbcUsersPortTls)));
                    }
                    if (featureUsersPort != null && !featureUsersPort.equals("null") && !featureUsersPort.equals("")) {
                        row.setFeatureUsersPort(Integer.valueOf(Integer.parseInt(featureUsersPort)));
                    }
                    if (featureUsersPortTls != null && !featureUsersPortTls.equals("null") && !featureUsersPortTls.equals("")) {
                        row.setFeatureUsersPortTls(Integer.valueOf(Integer.parseInt(featureUsersPortTls)));
                    }
                    if (trunkGatewayPort != null && !trunkGatewayPort.equals("null") && !trunkGatewayPort.equals("")) {
                        row.setTrunkGatewayPort(Integer.valueOf(Integer.parseInt(trunkGatewayPort)));
                    }
                    if (trunkGatewayPortTls != null && !trunkGatewayPortTls.equals("null") && !trunkGatewayPortTls.equals("")) {
                        row.setTrunkGatewayPortTls(Integer.valueOf(Integer.parseInt(trunkGatewayPortTls)));
                    }
                    if (trunkProxyPort != null && !trunkProxyPort.equals("null") && !trunkProxyPort.equals("")) {
                        row.setTrunkProxyPort(Integer.valueOf(Integer.parseInt(trunkProxyPort)));
                    }
                    if (trunkProxyPortTls != null && !trunkProxyPortTls.equals("null") && !trunkProxyPortTls.equals("")) {
                        row.setTrunkProxyPortTls(Integer.valueOf(Integer.parseInt(trunkProxyPortTls)));
                    }
                    if (clusterKey != null) {
                        row.setClusterKey(clusterKey);
                    }
                    if (NMSSection != null) {
                        url = (String)NMSSection.get((Object)"SNMP-EVENT-SEND-URL");
                        snmpEventSendIp = null;
                        snmpEventSendPort = null;
                        if (url.startsWith("http://") && (parts = url.split(":")).length >= 3) {
                            snmpEventSendIp = parts[1].substring(2);
                            snmpEventSendPort = parts[2].split("/")[0];
                        }
                        scadaServers = (String)NMSSection.get((Object)"SCADA-SERVERS");
                        snmpTrapReceiveIp = (String)NMSSection.get((Object)"SNMP-TRAP-RECEIVE-IP");
                        snmpTrapReceivePort = (String)NMSSection.get((Object)"SNMP-TRAP-RECEIVE-PORT");
                        snmpTrapSendIp = (String)NMSSection.get((Object)"SNMP-TRAP-SEND-IP");
                        snmpTrapSendPort = (String)NMSSection.get((Object)"SNMP-TRAP-SEND-PORT");
                        discoveryDuration = (String)NMSSection.get((Object)"DISCOVERY-DURATION");
                        discoveryTimeout = (String)NMSSection.get((Object)"DISCOVERY-TIMEOUT");
                        icmpCheckThreads = (String)NMSSection.get((Object)"ICMP-CHECK-THREADS");
                        ipCountEachThread = (String)NMSSection.get((Object)"IP-COUNT-EACH-THREAD");
                        scAdaPort = (String)NMSSection.get((Object)"SCADA-PORT");
                        enableRedisPubSub = (String)NMSSection.get((Object)"ENABLE-REDIS-PUB-SUB");
                        enableNms = (String)NMSSection.get((Object)"ENABLE-NMS");
                        centralNmsRedisIp = (String)NMSSection.get((Object)"CENTRAL-NMS-REDIS-IP");
                        centralNmsRedisPort = (String)NMSSection.get((Object)"CENTRAL-NMS-REDIS-PORT");
                        serverRluCode = (String)NMSSection.get((Object)"SERVER-RLU-CODE");
                        if (scadaServers != null && !scadaServers.equals("null") && !scadaServers.equals("")) {
                            row.setScadaServers(scadaServers);
                        }
                        if (snmpEventSendIp != null && !snmpEventSendIp.equals("null") && !snmpEventSendIp.equals("")) {
                            row.setSnmpEventSendIp(snmpEventSendIp);
                        }
                        if (snmpEventSendPort != null && !snmpEventSendPort.equals("null") && !snmpEventSendPort.equals("")) {
                            row.setSnmpEventSendPort(Integer.valueOf(Integer.parseInt(snmpEventSendPort)));
                        }
                        if (snmpTrapReceiveIp != null && !snmpTrapReceiveIp.equals("null") && !snmpTrapReceiveIp.equals("")) {
                            row.setSnmpTrapReceiveIp(snmpTrapReceiveIp);
                        }
                        if (snmpTrapReceivePort != null && !snmpTrapReceivePort.equals("null") && !snmpTrapReceivePort.equals("")) {
                            row.setSnmpTrapReceivePort(Integer.valueOf(Integer.parseInt(snmpTrapReceivePort)));
                        }
                        if (snmpTrapSendIp != null) {
                            row.setSnmpTrapSendIp(snmpTrapSendIp);
                        }
                        if (snmpTrapSendPort != null && !snmpTrapSendPort.equals("null") && !snmpTrapSendPort.equals("")) {
                            row.setSnmpTrapSendPort(Integer.valueOf(Integer.parseInt(snmpTrapSendPort)));
                        }
                        if (discoveryDuration != null && !discoveryDuration.equals("null") && !discoveryDuration.equals("")) {
                            row.setDiscoveryDuration(Integer.valueOf(Integer.parseInt(discoveryDuration)));
                        }
                        if (discoveryTimeout != null && !discoveryTimeout.equals("null") && !discoveryTimeout.equals("")) {
                            row.setDiscoveryTimeout(Integer.valueOf(Integer.parseInt(discoveryTimeout)));
                        }
                        if (icmpCheckThreads != null && !icmpCheckThreads.equals("null") && !icmpCheckThreads.equals("")) {
                            row.setIcmpCheckThreads(Integer.valueOf(Integer.parseInt(icmpCheckThreads)));
                        }
                        if (ipCountEachThread != null && !ipCountEachThread.equals("null") && !ipCountEachThread.equals("")) {
                            row.setIpCountEachThread(Integer.valueOf(Integer.parseInt(ipCountEachThread)));
                        }
                        if (scAdaPort != null && !scAdaPort.equals("null") && !scAdaPort.equals("")) {
                            row.setScAdaPort(Integer.valueOf(Integer.parseInt(scAdaPort)));
                        }
                        if (enableRedisPubSub != null) {
                            if (enableRedisPubSub.equals("Y")) {
                                row.setEnableRedisPubSub(Boolean.valueOf(true));
                            } else if (enableRedisPubSub.equals("N")) {
                                row.setEnableRedisPubSub(Boolean.valueOf(false));
                            }
                        }
                        if (enableNms != null) {
                            if (enableNms.equals("Y")) {
                                row.setEnableNms(Boolean.valueOf(true));
                            } else if (enableNms.equals("N")) {
                                row.setEnableNms(Boolean.valueOf(false));
                            }
                        }
                        if (centralNmsRedisIp != null && !centralNmsRedisIp.equals("null") && !centralNmsRedisIp.equals("")) {
                            row.setCentralNmsRedisIp(centralNmsRedisIp);
                        }
                        if (centralNmsRedisPort != null && !centralNmsRedisPort.equals("null") && !centralNmsRedisPort.equals("")) {
                            row.setCentralNmsRedisPort(Integer.valueOf(Integer.parseInt(centralNmsRedisPort)));
                        }
                        if (serverRluCode != null) {
                            row.setServerRluCode(serverRluCode);
                        }
                    }
                    this.nodeClusterRepository.save((Object)row);
                }
                NodeClusterService.logger.info("NMS-MOBILITY section retrieved successfully");
                if (route != null && !route.equals("null") && !route.equals("")) {
                    for (i = 1; i <= Integer.parseInt(route); ++i) {
                        routeSectionName = "ROUTE-" + i;
                        routeSection = (Profile.Section)ini.get((Object)routeSectionName);
                        ip = (String)routeSection.get((Object)"IP");
                        gw = (String)routeSection.get((Object)"GW");
                        cidr = (String)routeSection.get((Object)"CIDR");
                        interfaces = (String)routeSection.get((Object)"INTERFACE");
                        routeNodes = (String)routeSection.get((Object)"NODES");
                        row = new Routes();
                        row.setIp(ip);
                        row.setGateway(gw);
                        row.setInterfaces(interfaces);
                        if (cidr != null && !cidr.equals("null") && !cidr.equals("")) {
                            row.setCidr(Integer.valueOf(Integer.parseInt(cidr)));
                        }
                        row.setNodes(routeNodes);
                        this.routeRepo.save((Object)row);
                    }
                    NodeClusterService.logger.info("Route Section Retrieved Successfully");
                }
                if (wan != null && !wan.equals("null") && !wan.equals("")) {
                    for (i = 1; i <= Integer.parseInt(wan); ++i) {
                        wanSectionName = "WAN-" + i;
                        wanSection = (Profile.Section)ini.get((Object)wanSectionName);
                        name = (String)wanSection.get((Object)"NAME");
                        ipLocal = (String)wanSection.get((Object)"IP-LOCAL");
                        ipPublic = (String)wanSection.get((Object)"IP-PUBLIC");
                        ipRemote = (String)wanSection.get((Object)"IP-REMOTE");
                        wanType = (String)wanSection.get((Object)"WAN-TYPE");
                        row = new WAns();
                        row.setName(name);
                        row.setIpLocal(ipLocal);
                        row.setIpPublic(ipPublic);
                        row.setIpRemote(ipRemote);
                        row.setWanType(wanType);
                        this.wanRepo.save((Object)row);
                    }
                    NodeClusterService.logger.info("WANS Section Retrieved Successfully");
                }
                if (isp != null && !isp.equals("null") && !isp.equals("")) {
                    for (i = 1; i <= Integer.parseInt(isp); ++i) {
                        nodeSectionName = "ISP-" + i;
                        ispSection = (Profile.Section)ini.get((Object)nodeSectionName);
                        isDelete = Arrays.asList(new String[]{"NAME", "TRUNK-NAME", "INTERFACE", "LOCAL-IP", "LOCAL-PORT", "PROXY-IP", "CIDR", "GATEWAY", "CODECS", "NODES"});
                        sectionEntries = new LinkedHashMap<Object, String>();
                        nameTag = null;
                        for (Map.Entry entry : ispSection.entrySet()) {
                            key = (String)entry.getKey();
                            value = (String)entry.getValue();
                            sectionEntries.put(key, value);
                            if (!key.equals("NAME")) continue;
                            nameTag = value;
                        }
                        trueSipTrunkModels = new ArrayList<Object>();
                        falseSipTrunkModels = new ArrayList<SIPTrunkModel>();
                        for (Map.Entry entry : ispSection.entrySet()) {
                            key = (String)entry.getKey();
                            value = (String)entry.getValue();
                            model = new SIPTrunkModel();
                            model.setName(key);
                            model.setValue(value);
                            model.setIsDelete(Boolean.valueOf(isDelete.contains(key) == false));
                            if (model.getIsDelete().booleanValue()) {
                                falseSipTrunkModels.add(model);
                                continue;
                            }
                            trueSipTrunkModels.add(model);
                        }
                        trueSipTrunkModels.addAll(falseSipTrunkModels);
                        objectMapper = new ObjectMapper();
                        fileName = nameTag + ".json";
                        sipFileName = ispFilePath + fileName;
                        fileWriter = new FileWriter(sipFileName);
                        dataReceived = objectMapper.writeValueAsString(trueSipTrunkModels);
                        fileWriter.write(dataReceived);
                        fileWriter.close();
                    }
                    NodeClusterService.logger.info("ISP Section Retrieved Successfully");
                }
                returnValue.setMessage("data Stored Successfully");
                returnValue.setMessageDetail("ALL table and files update according to configuration!");
                NodeClusterService.logger.info(returnValue.getMessageDetail());
            } else {
                returnValue.setMessageDetail("file present with empty data, Create new records again");
                NodeClusterService.logger.info(returnValue.getMessageDetail());
                return returnValue;
lbl395:
                // 1 sources

                returnValue.setMessageDetail("Not appropriate data exist inside coral file");
                NodeClusterService.logger.info(returnValue.getMessageDetail() + ",check masterNode,ISP,Node,Route,Wan,numbers in cluster Section in file");
                return returnValue;
lbl398:
                // 1 sources

                returnValue.setMessage("coral file present with invalid data");
                NodeClusterService.logger.info(returnValue.getMessage());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            NodeClusterService.logger.error(e.getMessage());
        }
        return returnValue;
    }

    public String hostname() {
        String hostName;
        block17: {
            hostName = "";
            try {
                String hostNamePath = "/etc/hostname";
                File file = new File(hostNamePath);
                if (file.exists()) {
                    try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                        hostName = reader.readLine();
                        break block17;
                    }
                    catch (IOException e) {
                        System.err.println("Error while reading hostname file: " + e.getMessage());
                    }
                    break block17;
                }
                System.err.println("Hostname file does not exist");
            }
            catch (SecurityException e) {
                System.err.println("Permission denied to access hostname file: " + e.getMessage());
            }
        }
        return hostName;
    }
}

