/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.complaint.CallDispositionQueueView.controller;

import com.coraltele.db.coralapps.callcenter.entity.view.CallDispositionQueueNew;
import com.coraltele.db.coralapps.callcenter.repository.CallDispositionQueueRepository;
import com.coraltele.db.coralapps.callcenter.specification.CallDispositionQueueSpecification;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.complaint.CallDispositionQueueView.service.CallDispositionQueueService;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.user.service.UserService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/callDispositionQueue"})
public class CallDispositionQueueController {
    private static final Logger logger = LogManager.getLogger(CallDispositionQueueController.class);
    @Autowired
    CallDispositionQueueRepository callDispositionQueueRepository;
    @Autowired
    CallDispositionQueueService callDispositionQueueService;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadServiceTest;
    @Autowired
    UserRepository userRepository;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllCallDispositionQueue(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.callDispositionQueueService.getAllCallDispositionQueue(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for dispositionAnalysisQueue--");
            boolean teamLeaderUser = false;
            boolean adminUser = false;
            boolean managerUser = false;
            if (this.userService.checkRoleTL(principal.getName())) {
                teamLeaderUser = true;
            }
            List queueId = null;
            if (teamLeaderUser) {
                queueId = this.queueTLService.getQueueListByTeamLeaderInt(principal.getName());
            } else if (this.userService.checkManagerUser(principal.getName())) {
                managerUser = true;
            } else if (this.userService.checkAdminUser(principal.getName())) {
                adminUser = true;
            }
            Specification filters = CallDispositionQueueSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, (boolean)adminUser, (boolean)managerUser, (List)queueId);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "recordCreatedOn" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "recordCreatedOn" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.callDispositionQueueRepository.findAll(filters, sort) : this.callDispositionQueueRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (CallDispositionQueueNew item : filteredData) {
                    ArrayList<String> values = new ArrayList<String>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for dispositionAnalysisQueue", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading dispositionAnalysisQueue CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private String getColumnValue(CallDispositionQueueNew item, String columnName) {
        switch (columnName) {
            case "recordCreatedOn": {
                return this.checkNull((Object)item.getRecordCreatedOn());
            }
            case "queueId": {
                return this.checkNull((Object)item.getQueueId());
            }
            case "queueName": {
                return this.checkNull((Object)item.getQueueName());
            }
            case "agentId": {
                return this.checkNull((Object)item.getAgentId());
            }
            case "agentName": {
                Optional user = this.userRepository.findByUsername(item.getAgentId());
                if (user.isPresent()) {
                    return this.checkNull((Object)((User)user.get()).getDescription());
                }
                return "";
            }
            case "phoneNumber": {
                return this.checkNull((Object)item.getPhoneNumber());
            }
            case "customerStatus": {
                return this.checkNull((Object)item.getCustomerStatus());
            }
            case "recordLastModifiedOn": {
                return this.checkNull((Object)item.getRecordLastModifiedOn());
            }
        }
        return "";
    }

    private String checkNull(Object value) {
        return value != null && !value.equals("null") ? value.toString() : "";
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadServiceTest.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    static {
        columnMappings.put("recordCreatedOn", "Record Date");
        columnMappings.put("queueId", "Queue");
        columnMappings.put("queueName", "Queue Name");
        columnMappings.put("agentId", "Agent Id ");
        columnMappings.put("agentName", "Agent Name");
        columnMappings.put("phoneNumber", "Phone Number");
        columnMappings.put("customerStatus", "Call Disposition");
        columnMappings.put("recordLastModifiedOn", "Next Action Date");
    }
}

