/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.log.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.billing.log.service.UserLogService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.MessageFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/userLog"})
@RestController
public class UserLogController {
    private static final Logger logger = LogManager.getLogger(UserLogController.class);
    private static final String CONTROLLER_NAME = "User Log";
    @Autowired
    UserLogService userLogService;

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllUserLog(@RequestBody SearchRequest data) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String dataReceived = objectMapper.writeValueAsString((Object)data);
            String message = MessageFormat.format("{1} received for listing : {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            RequestResponse returnValue = this.userLogService.getList(data);
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                message = MessageFormat.format("{1} data processed successfully for listing : {0}", CONTROLLER_NAME, dataReceived);
                logger.info(message);
                return ResponseEntity.ok((Object)returnValue);
            }
            message = MessageFormat.format("{1} unable to process data for listing: {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (JsonProcessingException e) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Invalid json data");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/list/internal"})
    public ResponseEntity<RequestResponse> getAllUserLogInternal(@RequestBody SearchRequest data) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String dataReceived = objectMapper.writeValueAsString((Object)data);
            String message = MessageFormat.format("{1} received for listing : {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            RequestResponse returnValue = this.userLogService.getListInternal(data);
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                message = MessageFormat.format("{1} data processed successfully for listing : {0}", "User Log Internal", dataReceived);
                logger.info(message);
                return ResponseEntity.ok((Object)returnValue);
            }
            message = MessageFormat.format("{1} unable to process data for listing: {0}", "User Log Internal", dataReceived);
            logger.info(message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (JsonProcessingException e) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Invalid json data");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/list/external"})
    public ResponseEntity<RequestResponse> getAllUserLogExternal(@RequestBody SearchRequest data) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String dataReceived = objectMapper.writeValueAsString((Object)data);
            String message = MessageFormat.format("{1} received for listing : {0}", CONTROLLER_NAME, dataReceived);
            logger.info(message);
            RequestResponse returnValue = this.userLogService.getListExternal(data);
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                message = MessageFormat.format("{1} data processed successfully for listing : {0}", "User Log External", dataReceived);
                logger.info(message);
                return ResponseEntity.ok((Object)returnValue);
            }
            message = MessageFormat.format("{1} unable to process data for listing: {0}", "User Log External", dataReceived);
            logger.info(message);
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        catch (JsonProcessingException e) {
            RequestResponse returnValue = new RequestResponse();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Invalid json data");
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
    }
}

