/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.coralapps.callcenter.entity.view;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import lombok.Generated;
import org.hibernate.annotations.Subselect;

@Entity
@Subselect(value="SELECT row_number() OVER () AS id,\n    id as callbackid,\n    callerid,\n    callbackactivatedby,\n    callbackactivatedon,\n    callbackscheduledon,\n    queue,\n    queuename,\n    campaign,\n    campaignname,\n    status,\n    cidname\nFROM (\n    SELECT \n        a.id,\n        RIGHT(a.phonenumber, 10) AS callerid,\n        a.recordcreatedby AS callbackactivatedby,\n        a.recordcreatedon AS callbackactivatedon,\n        a.recordlastmodifiedon AS callbackscheduledon,\n        CASE \n            WHEN COALESCE(a.valuetype, 'q') = 'q' THEN d.id::text \n            ELSE c.systemname \n        END AS queue,\n        CASE \n            WHEN COALESCE(a.valuetype, 'q') = 'l' THEN a.queue \n            ELSE NULL \n        END AS campaign,\n        a.valuetype AS queueorlead,\n        CASE \n            WHEN COALESCE(a.callback_isdialed, false) = true THEN 'Dialed'\n            WHEN COALESCE(a.callback_isdialed, false) = false \n                AND COALESCE(a.callback_ismanualmarkedasdialed, false) = true THEN 'Marked as Dialed'\n            ELSE 'Pending' \n        END AS status,\n        CASE \n            WHEN COALESCE(a.callback_isdialed, false) = true THEN '#dff0d8'\n            WHEN COALESCE(a.callback_ismanualmarkedasdialed, false) = true THEN '#fcf8e3'\n            WHEN (EXTRACT(EPOCH FROM (now() - a.recordlastmodifiedon))) > 0 THEN '' \n            ELSE '' \n        END AS statuscolor,\n        a.callback_finalstatus,\n        CASE \n            WHEN COALESCE(a.callback_isdialed, false) = false \n                AND COALESCE(a.callback_ismanualmarkedasdialed, false) = false THEN true \n            ELSE false \n        END AS showdialingbtn,\n        COALESCE(d.description, c.description) AS queuename,\n        b.description AS campaignname,\n        CASE \n            WHEN COALESCE(a.valuetype, 'q') = 'q' THEN \n                'qid:' || COALESCE(a.queue, 0) \n            ELSE \n                'leadid:' || COALESCE(a.queue::int, 0) || '_dialid:' || COALESCE(a.id::int, 0) \n        END AS cidname\n    FROM callcenter.t_dynamicpopupdata a\n    LEFT JOIN callcenter.m_campaign b ON a.queue::int = b.id AND COALESCE(a.valuetype, 'q') = 'l'\n    LEFT JOIN callcenter.m_queue c ON b.queue::int = c.id\n    LEFT JOIN callcenter.m_queue d ON a.queue::text = d.systemname AND COALESCE(a.valuetype, 'q') = 'q'\n    WHERE LOWER(COALESCE(a.customerstatus, '')) IN ('call back', 'callback')\n      AND COALESCE(a.recordcreatedby, '') <> ''\n      AND a.recordlastmodifiedon IS NOT NULL\n      AND a.recordlastmodifiedon <= NOW()\n) a\nWHERE COALESCE(a.status, '') = 'Pending'\n")
public class CallBackReportView {
    @Id
    private Long id;
    @Column(name="callbackid")
    private Integer callbackId;
    @Column(name="callerid")
    private String callerId;
    @Column(name="callbackactivatedby")
    private String callbackActivatedBy;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Column(name="callbackactivatedon")
    private LocalDateTime callbackActivatedOn;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Column(name="callbackscheduledon")
    private LocalDateTime callbackScheduledOn;
    @Column(name="queue")
    private String queue;
    @Column(name="queuename")
    private String queueName;
    @Column(name="campaign")
    private String campaign;
    @Column(name="campaignname")
    private String campaignName;
    @Column(name="status")
    private String status;
    @Column(name="cidname")
    private String cidName;

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Integer getCallbackId() {
        return this.callbackId;
    }

    @Generated
    public String getCallerId() {
        return this.callerId;
    }

    @Generated
    public String getCallbackActivatedBy() {
        return this.callbackActivatedBy;
    }

    @Generated
    public LocalDateTime getCallbackActivatedOn() {
        return this.callbackActivatedOn;
    }

    @Generated
    public LocalDateTime getCallbackScheduledOn() {
        return this.callbackScheduledOn;
    }

    @Generated
    public String getQueue() {
        return this.queue;
    }

    @Generated
    public String getQueueName() {
        return this.queueName;
    }

    @Generated
    public String getCampaign() {
        return this.campaign;
    }

    @Generated
    public String getCampaignName() {
        return this.campaignName;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getCidName() {
        return this.cidName;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCallbackId(Integer callbackId) {
        this.callbackId = callbackId;
    }

    @Generated
    public void setCallerId(String callerId) {
        this.callerId = callerId;
    }

    @Generated
    public void setCallbackActivatedBy(String callbackActivatedBy) {
        this.callbackActivatedBy = callbackActivatedBy;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public void setCallbackActivatedOn(LocalDateTime callbackActivatedOn) {
        this.callbackActivatedOn = callbackActivatedOn;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public void setCallbackScheduledOn(LocalDateTime callbackScheduledOn) {
        this.callbackScheduledOn = callbackScheduledOn;
    }

    @Generated
    public void setQueue(String queue) {
        this.queue = queue;
    }

    @Generated
    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @Generated
    public void setCampaign(String campaign) {
        this.campaign = campaign;
    }

    @Generated
    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setCidName(String cidName) {
        this.cidName = cidName;
    }

    @Generated
    public CallBackReportView() {
    }

    @Generated
    public CallBackReportView(Long id, Integer callbackId, String callerId, String callbackActivatedBy, LocalDateTime callbackActivatedOn, LocalDateTime callbackScheduledOn, String queue, String queueName, String campaign, String campaignName, String status, String cidName) {
        this.id = id;
        this.callbackId = callbackId;
        this.callerId = callerId;
        this.callbackActivatedBy = callbackActivatedBy;
        this.callbackActivatedOn = callbackActivatedOn;
        this.callbackScheduledOn = callbackScheduledOn;
        this.queue = queue;
        this.queueName = queueName;
        this.campaign = campaign;
        this.campaignName = campaignName;
        this.status = status;
        this.cidName = cidName;
    }
}

