/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.service;

import com.coraltele.db.users.main.entity.Role;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.RoleRepository;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.db.users.main.specification.RoleSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.helper.ReturnField;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.user.model.RoleModel;
import com.coraltele.service.user.service.UserService;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RoleService {
    private static final Logger logger = LogManager.getLogger(RoleService.class);
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    UserService userService;
    @Autowired
    UserRepository userRepository;

    public RequestResponse createRole(RoleModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Role role = new Role();
            role.setDescription(data.getDescription());
            if (data.getEnabled() != null) {
                role.setEnabled(Integer.valueOf(data.getEnabled() != false ? 1 : 0));
            } else {
                role.setEnabled(Integer.valueOf(0));
            }
            role.setCreatedBy(principal.getName());
            role.setCreatedOn(LocalDateTime.now());
            if (StringUtils.hasLength((String)data.getRoles())) {
                role.setRoles(data.getRoles());
                role.setShortCode("ROLE_" + data.getRoles().toUpperCase());
            }
            if (data.getStar() != null) {
                role.setStar(Integer.valueOf(data.getStar() != false ? 1 : 0));
            } else {
                role.setStar(Integer.valueOf(0));
            }
            this.roleRepository.save((Object)role);
            ReturnField field = new ReturnField();
            field.setId(role.getId().intValue());
            field.setDescription(role.getDescription());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage(" Registered");
            returnValue.setMessageDetail("Role registered successfully ");
            returnValue.setData((Object)field);
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to create role");
            returnValue.setMessageDetail("Contact with administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getById(int id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional role = this.roleRepository.findById(id);
            if (role.isPresent()) {
                RoleModel data = new RoleModel();
                data.setId(((Role)role.get()).getId().intValue());
                data.setDescription(((Role)role.get()).getDescription());
                data.setEnabled(Boolean.valueOf(((Role)role.get()).getEnabled() == 1));
                data.setRoles(((Role)role.get()).getRoles());
                data.setStar(Boolean.valueOf(((Role)role.get()).getStar() == 1));
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("role Found");
                returnValue.setData((Object)data);
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updateRole(RoleModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        String loggedUser = principal.getName();
        Optional userInfo = this.userRepository.findByUsername(loggedUser);
        try {
            Optional role = this.roleRepository.findById(data.getId());
            if (role.isPresent()) {
                if (data.getDescription() != null) {
                    ((Role)role.get()).setDescription(data.getDescription());
                }
                if (data.getEnabled() != null) {
                    ((Role)role.get()).setEnabled(Integer.valueOf(data.getEnabled() != false ? 1 : 0));
                } else {
                    ((Role)role.get()).setEnabled(Integer.valueOf(0));
                }
                if (data.getRoles() != null) {
                    ((Role)role.get()).setRoles(data.getRoles());
                    ((Role)role.get()).setShortCode("ROLE_" + data.getRoles().toUpperCase());
                }
                if (data.getStar() != null) {
                    ((Role)role.get()).setStar(Integer.valueOf(data.getStar() != false ? 1 : 0));
                } else {
                    ((Role)role.get()).setStar(Integer.valueOf(0));
                }
                if (userInfo.isPresent()) {
                    ((Role)role.get()).setUpdatedBy(Long.valueOf(((User)userInfo.get()).getId().intValue()));
                }
                ((Role)role.get()).setUpdatedOn(LocalDateTime.now());
                this.roleRepository.save(role.get());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Updated");
                returnValue.setMessageDetail("Role Updated successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Role not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to update user");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.error(returnValue.getMessage(), (Object)e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse deleteRole(InputIdModel id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            for (Integer ids : id.getIntId()) {
                Optional role = this.roleRepository.findById((Object)ids);
                if (role.isPresent()) {
                    this.roleRepository.deleteById((Object)ids);
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("deleted");
                    returnValue.setMessageDetail("Record deleted successfully");
                    logger.info(returnValue.getMessage());
                    continue;
                }
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to delete role");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = (List)this.roleRepository.findAll();
        ArrayList<RoleModel> addValue = new ArrayList<RoleModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Role role : list) {
            RoleModel data = new RoleModel();
            data.setId(role.getId().intValue());
            data.setDescription(role.getDescription());
            data.setEnabled(Boolean.valueOf(role.getEnabled() == 1));
            data.setRoles(role.getRoles());
            data.setShortCode(role.getShortCode());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getRoleByFilter(SearchRequest searchRequest) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = RoleSpecification.generateFilters((SearchRequest)searchRequest);
        Sort sort = null;
        if (searchRequest.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequest.sortBy}).ascending();
        } else if (searchRequest.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequest.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.roleRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequest.getCurrentPage(), (int)(searchRequest.getPageSize() == 0 ? 10 : searchRequest.getPageSize()))) : this.roleRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequest.getCurrentPage(), (int)(searchRequest.getPageSize() == 0 ? 10 : searchRequest.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequest.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequest.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

