/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.EventNotifyModel;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.user.model.ChangePasswordModel;
import com.coraltele.service.user.model.UserAccessModel;
import com.coraltele.service.user.model.UserModel;
import com.coraltele.service.user.model.UserMultipleUpdateModel;
import com.coraltele.service.user.service.UserAuthenticationService;
import com.coraltele.service.user.service.UserService;
import java.io.File;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/user"})
@RestController
public class UserController {
    private static final Logger logger = LogManager.getLogger(UserController.class);
    @Autowired
    private UserService userService;
    @Autowired
    private UserAuthenticationService userAuthenticationService;

    @PostMapping(value={"/register"})
    public ResponseEntity<RequestResponse> registerUser(@RequestBody UserModel data, Principal principal) {
        RequestResponse returnValue = this.userService.createUser(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/refreshToken"})
    public ResponseEntity<RequestResponse> refreshToken(Principal principal) {
        RequestResponse returnValue = this.userAuthenticationService.refreshToken(principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/{id}"})
    public ResponseEntity<RequestResponse> getUserById(@PathVariable(value="id") int id) {
        RequestResponse returnValue = this.userService.getUserById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateUser(@RequestBody UserModel data, Principal principal) {
        RequestResponse returnValue = this.userService.updateUser(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteUser(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.userService.deleteUser(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getUserByFilter(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.userService.getUserByFilter(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/changePassword"})
    public ResponseEntity<RequestResponse> changePassword(@RequestBody ChangePasswordModel data, Principal userData) {
        RequestResponse returnValue = this.userService.updatePassword(data, userData);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/dropdownList"})
    public ResponseEntity<RequestResponse> getUsersDropdownList() {
        RequestResponse returnValue = this.userService.getUsersDropdownList();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/multiUpdate/user"})
    public ResponseEntity<RequestResponse> updateMultipleUser(@RequestBody UserMultipleUpdateModel data, Principal principal) {
        RequestResponse returnValue = this.userService.updateMultipleUser(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/createAPIKey"})
    public ResponseEntity<RequestResponse> createAPIKey(Principal principal) {
        RequestResponse returnValue = this.userService.createAPIKey(principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/ucUsersList"})
    public ResponseEntity<RequestResponse> getAllUCUsers() {
        RequestResponse returnValue = this.userService.getAllUCUsers();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateByUsername"})
    public ResponseEntity<RequestResponse> updateUserAgentProp(@RequestBody UserModel data, Principal principal) {
        RequestResponse returnValue = this.userService.updateByUsername(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/username/{username}"})
    public ResponseEntity<RequestResponse> getUserByUserName(@PathVariable(value="username") String id) {
        RequestResponse returnValue = this.userService.getUserByUsername(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/engineerUsersList"})
    public ResponseEntity<RequestResponse> getAllEngineerUsers() {
        RequestResponse returnValue = this.userService.getEngineerUser();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/sendNotification"})
    public ResponseEntity<RequestResponse> eventSend(@RequestBody EventNotifyModel data) {
        RequestResponse returnValue = this.userService.sendNotification(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/accessControl"})
    public ResponseEntity<RequestResponse> eventSendToUser(@RequestBody UserAccessModel data, Principal principal) {
        RequestResponse returnValue = this.userService.sendUserNotifyToUser(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updatePassword"})
    public ResponseEntity<RequestResponse> changePassword(@RequestBody ChangePasswordModel data) {
        RequestResponse returnValue = this.userService.updatePasswordForUsers(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/removeArea/{username}"})
    public ResponseEntity<RequestResponse> updateMultipleUser(@PathVariable(value="username") String id, Principal principal) {
        RequestResponse returnValue = this.userService.deAttachedUser(id, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    public static String getClusterKey() {
        String clusterKey;
        block3: {
            String coralFilePath = "/etc/default/coral";
            clusterKey = "";
            try {
                Ini ini;
                File file = new File(coralFilePath);
                if (!file.exists() || !(ini = new Ini(file)).containsKey((Object)"CLUSTER")) break block3;
                Profile.Section cscfSection = (Profile.Section)ini.get((Object)"CLUSTER");
                if (cscfSection.containsKey((Object)"CLUSTER-KEY")) {
                    clusterKey = (String)cscfSection.get((Object)"CLUSTER-KEY");
                    break block3;
                }
                return "";
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        return clusterKey;
    }

    @PostMapping(value={"/loginData"})
    public ResponseEntity<RequestResponse> loginUser(Principal principal, HttpServletRequest request) throws Exception {
        RequestResponse returnValue = this.userAuthenticationService.getUserLoginResponse(principal, request);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/refresh-subscriber-data"})
    public ResponseEntity<RequestResponse> refreshSubscriberData() {
        RequestResponse returnValue = new RequestResponse();
        try {
            this.userService.regenerateSIPCredentials();
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Subscriber data refreshed successfully.");
        }
        catch (Exception e) {
            logger.error("Error refreshing subscriber data: {}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Failed to refresh subscriber data.");
        }
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

