/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.nonHoliday.service;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.coraltele.db.telephony.pbx.entity.NonWorkingHoliday;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.pbx.repository.NonWorkingHolidayRepository;
import com.coraltele.db.telephony.pbx.specification.NonHoldidaySpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.nonHoliday.model.DeleteListModel;
import com.coraltele.service.pbx.nonHoliday.model.NonHolidayListModel;
import com.coraltele.service.pbx.nonHoliday.model.NonHolidayModel;
import com.coraltele.service.pbx.nonHoliday.model.ToggleModel;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.Principal;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class NonHolidayService {
    private static final Logger logger = LogManager.getLogger(NonHolidayService.class);
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    NonWorkingHolidayRepository nonHolidayRepository;
    @Autowired
    PdfReportRepository pdfReportRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;

    public RequestResponse createNonHoliday(NonHolidayModel data, Principal principal) {
        try {
            RequestResponse response = new RequestResponse();
            LocalTime newFrom = data.getFromTime();
            LocalTime newTo = data.getToTime();
            if (!newTo.isAfter(newFrom)) {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("ToTime must be greater than FromTime");
                return response;
            }
            List allRecords = (List)this.nonHolidayRepository.findAll();
            List toDelete = allRecords.stream().filter(r -> r.getDay() != null && r.getDay() != 0).collect(Collectors.toList());
            if (!toDelete.isEmpty()) {
                this.nonHolidayRepository.deleteAll(toDelete);
                logger.info("Deleted {} old records (with non-null day)", (Object)toDelete.size());
            }
            for (int i = 1; i <= 7; ++i) {
                NonWorkingHoliday nonHolidayModel = new NonWorkingHoliday();
                nonHolidayModel.setCreatedOn(Long.valueOf(System.currentTimeMillis()));
                nonHolidayModel.setModifiedOn(Long.valueOf(System.currentTimeMillis()));
                nonHolidayModel.setModifiedby(principal.getName());
                nonHolidayModel.setTimezone(data.getTimezone());
                nonHolidayModel.setDay(Integer.valueOf(i));
                nonHolidayModel.setDate(data.getDate());
                nonHolidayModel.setHolidayName(this.getDayName(i));
                nonHolidayModel.setIsActive(Boolean.valueOf(true));
                if ("hangup".equalsIgnoreCase(data.getServingApp())) {
                    nonHolidayModel.setServingApp("hangup");
                    nonHolidayModel.setServingData("");
                } else {
                    nonHolidayModel.setServingApp(data.getServingApp());
                    nonHolidayModel.setServingData(data.getServingData());
                }
                if (data.getNumber() != null && data.getNumber().contains(i)) {
                    nonHolidayModel.setFromTime(LocalTime.of(0, 1));
                    nonHolidayModel.setToTime(LocalTime.of(23, 59));
                } else {
                    nonHolidayModel.setFromTime(data.getFromTime());
                    nonHolidayModel.setToTime(data.getToTime());
                }
                this.nonHolidayRepository.save((Object)nonHolidayModel);
            }
            response.setStatus(Constants.Error.OK);
            response.setMessage("Old data deleted (except null-day records) and 7 new Non-Holidays created");
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            RequestResponse response = new RequestResponse();
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Error occurred: " + e.getMessage());
            return response;
        }
    }

    private String getDayName(int dayNumber) {
        switch (dayNumber) {
            case 1: {
                return "Sunday";
            }
            case 2: {
                return "Monday";
            }
            case 3: {
                return "Tuesday";
            }
            case 4: {
                return "Wednesday";
            }
            case 5: {
                return "Thursday";
            }
            case 6: {
                return "Friday";
            }
            case 7: {
                return "Saturday";
            }
        }
        return "Unknown";
    }

    public RequestResponse deleteHoliday(InputIdModel id) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : id.getIntId()) {
            Optional extGroup = this.nonHolidayRepository.findById((Object)ids);
            if (extGroup.isPresent()) {
                addValue.add(extGroup.get());
                this.nonHolidayRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getFilterList(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = NonHoldidaySpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.nonHolidayRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.nonHolidayRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<NonHolidayListModel> entityToModelConversion(List<NonWorkingHoliday> actionCodeList) {
        ArrayList<NonHolidayListModel> addValue = new ArrayList<NonHolidayListModel>();
        for (NonWorkingHoliday row : actionCodeList) {
            NonHolidayListModel data = new NonHolidayListModel();
            data.setId(row.getId());
            data.setCreatedOn(row.getCreatedOn());
            if (row.getDate() != null && row.getDate() != 0L) {
                data.setDate(this.dateFormatUtility.epochToLocalDate(row.getDate()));
                data.setHolidayName(row.getHolidayName());
            } else {
                data.setHolidayName("");
            }
            data.setDay(row.getDay());
            data.setFromTime(row.getFromTime());
            data.setServingApp(row.getServingApp());
            data.setServingData(row.getServingData());
            data.setTimezone(row.getTimezone());
            data.setToTime(row.getToTime());
            data.setIsActive(row.getIsActive());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse createSingle(NonHolidayModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        try {
            LocalTime newFrom = data.getFromTime();
            LocalTime newTo = data.getToTime();
            if (!newTo.isAfter(newFrom)) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("ToTime must be greater than FromTime");
                return returnValue;
            }
            if (data.getFromTime() == null || data.getToTime() == null) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("FromTime and ToTime are required");
                return returnValue;
            }
            if (newFrom == null || newTo == null) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("FromTime and ToTime must not be null");
                return returnValue;
            }
            List existingHolidays = new ArrayList();
            for (Integer aa : data.getNumber()) {
                existingHolidays = this.nonHolidayRepository.findByDay(aa);
            }
            logger.info(existingHolidays);
            for (NonWorkingHoliday existing : existingHolidays) {
                LocalTime existingTo;
                LocalTime existingFrom = existing.getFromTime();
                if (!this.isTimeOverlapping(newFrom, newTo, existingFrom, existingTo = existing.getToTime())) continue;
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Time range overlaps with an existing record for this day (" + existingFrom + " - " + existingTo + ")");
                return returnValue;
            }
            NonWorkingHoliday newHoliday = new NonWorkingHoliday();
            newHoliday.setCreatedOn(Long.valueOf(System.currentTimeMillis()));
            newHoliday.setTimezone(data.getTimezone());
            newHoliday.setDay(((NonWorkingHoliday)existingHolidays.get(0)).getDay());
            newHoliday.setDate(data.getDate());
            newHoliday.setHolidayName(((NonWorkingHoliday)existingHolidays.get(0)).getHolidayName());
            newHoliday.setFromTime(newFrom);
            newHoliday.setToTime(newTo);
            newHoliday.setServingApp(data.getServingApp());
            newHoliday.setModifiedOn(Long.valueOf(System.currentTimeMillis()));
            newHoliday.setModifiedby(principal.getName());
            newHoliday.setServingData("hangup".equalsIgnoreCase(data.getServingApp()) ? "" : data.getServingData());
            this.nonHolidayRepository.save((Object)newHoliday);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Data created successfully");
            logger.info("NonHoliday created successfully.");
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error creating holiday: " + e.getMessage());
            logger.error("Error while creating NonHoliday", (Throwable)e);
        }
        return returnValue;
    }

    private boolean isTimeOverlapping(LocalTime newFrom, LocalTime newTo, LocalTime existingFrom, LocalTime existingTo) {
        boolean existingOvernight = existingFrom.isAfter(existingTo);
        boolean newOvernight = newFrom.isAfter(newTo);
        if (!existingOvernight && !newOvernight) {
            return newFrom.isBefore(existingTo) && newTo.isAfter(existingFrom);
        }
        if (existingOvernight && !newOvernight) {
            return !newTo.isBefore(existingFrom) || !newFrom.isAfter(existingTo);
        }
        if (!existingOvernight && newOvernight) {
            return !existingTo.isBefore(newFrom) || !existingFrom.isAfter(newTo);
        }
        return true;
    }

    public RequestResponse updateById(NonHolidayModel data, Principal principal) {
        logger.debug("Update Non-Holiday {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional extGroupOptional = this.nonHolidayRepository.findById((Object)data.getId());
        if (data.getNumber() != null && !data.getNumber().isEmpty()) {
            List existingHolidays = this.nonHolidayRepository.findByDay(((NonWorkingHoliday)extGroupOptional.get()).getDay());
            LocalTime newFrom = data.getFromTime();
            LocalTime newTo = data.getToTime();
            if (!newTo.isAfter(newFrom)) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("ToTime must be greater than FromTime");
                return returnValue;
            }
            for (NonWorkingHoliday existing : existingHolidays) {
                LocalTime existingTo;
                LocalTime existingFrom;
                if (existing.getId().equals(data.getId()) || !this.isTimeOverlapping(newFrom, newTo, existingFrom = existing.getFromTime(), existingTo = existing.getToTime())) continue;
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Time range overlaps with an existing record (" + existingFrom + " - " + existingTo + ")");
                return returnValue;
            }
            if (!extGroupOptional.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Not Found");
                returnValue.setMessageDetail("Non-Holiday record not found");
                logger.error(returnValue.getMessage());
                return returnValue;
            }
            ((NonWorkingHoliday)extGroupOptional.get()).setCreatedOn(Long.valueOf(System.currentTimeMillis()));
            ((NonWorkingHoliday)extGroupOptional.get()).setTimezone(((NonWorkingHoliday)extGroupOptional.get()).getTimezone());
            ((NonWorkingHoliday)extGroupOptional.get()).setDay(((NonWorkingHoliday)extGroupOptional.get()).getDay());
            ((NonWorkingHoliday)extGroupOptional.get()).setDate(((NonWorkingHoliday)extGroupOptional.get()).getDate());
            ((NonWorkingHoliday)extGroupOptional.get()).setHolidayName(((NonWorkingHoliday)extGroupOptional.get()).getHolidayName());
            ((NonWorkingHoliday)extGroupOptional.get()).setFromTime(data.getFromTime());
            ((NonWorkingHoliday)extGroupOptional.get()).setToTime(data.getToTime());
            ((NonWorkingHoliday)extGroupOptional.get()).setServingApp(data.getServingApp());
            ((NonWorkingHoliday)extGroupOptional.get()).setModifiedOn(Long.valueOf(System.currentTimeMillis()));
            ((NonWorkingHoliday)extGroupOptional.get()).setModifiedby(principal.getName());
            if ("hangup".equalsIgnoreCase(data.getServingApp())) {
                ((NonWorkingHoliday)extGroupOptional.get()).setServingData("");
            } else {
                ((NonWorkingHoliday)extGroupOptional.get()).setServingData(data.getServingData());
            }
            this.nonHolidayRepository.save(extGroupOptional.get());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Updated");
            returnValue.setMessageDetail("Non-Working Holiday updated successfully");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (!extGroupOptional.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("Non-Holiday record not found");
            logger.error(returnValue.getMessage());
            return returnValue;
        }
        ((NonWorkingHoliday)extGroupOptional.get()).setCreatedOn(Long.valueOf(System.currentTimeMillis()));
        ((NonWorkingHoliday)extGroupOptional.get()).setTimezone(((NonWorkingHoliday)extGroupOptional.get()).getTimezone());
        ((NonWorkingHoliday)extGroupOptional.get()).setDay(((NonWorkingHoliday)extGroupOptional.get()).getDay());
        ((NonWorkingHoliday)extGroupOptional.get()).setDate(((NonWorkingHoliday)extGroupOptional.get()).getDate());
        ((NonWorkingHoliday)extGroupOptional.get()).setHolidayName(((NonWorkingHoliday)extGroupOptional.get()).getHolidayName());
        ((NonWorkingHoliday)extGroupOptional.get()).setFromTime(data.getFromTime());
        ((NonWorkingHoliday)extGroupOptional.get()).setToTime(data.getToTime());
        ((NonWorkingHoliday)extGroupOptional.get()).setServingApp(data.getServingApp());
        ((NonWorkingHoliday)extGroupOptional.get()).setModifiedOn(Long.valueOf(System.currentTimeMillis()));
        ((NonWorkingHoliday)extGroupOptional.get()).setModifiedby(principal.getName());
        if ("hangup".equalsIgnoreCase(data.getServingApp())) {
            ((NonWorkingHoliday)extGroupOptional.get()).setServingData("");
        } else {
            ((NonWorkingHoliday)extGroupOptional.get()).setServingData(data.getServingData());
        }
        this.nonHolidayRepository.save(extGroupOptional.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Non-Working Holiday updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse yearlyCreateNonHoliday(NonHolidayModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        try {
            List existingHolidays = this.nonHolidayRepository.findByDate(data.getDate());
            LocalTime newFrom = data.getFromTime();
            LocalTime newTo = data.getToTime();
            for (NonWorkingHoliday existing : existingHolidays) {
                LocalTime existingTo;
                LocalTime existingFrom = existing.getFromTime();
                if (!this.isTimeOverlapping(newFrom, newTo, existingFrom, existingTo = existing.getToTime())) continue;
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Time overlap detected for date: " + data.getDate() + " between " + existing.getFromTime() + " - " + existing.getToTime());
                return returnValue;
            }
            NonWorkingHoliday row = new NonWorkingHoliday();
            row.setCreatedOn(Long.valueOf(System.currentTimeMillis()));
            row.setTimezone(data.getTimezone());
            row.setDay(Integer.valueOf(0));
            row.setDate(data.getDate());
            row.setHolidayName(data.getHolidayName());
            row.setModifiedOn(Long.valueOf(System.currentTimeMillis()));
            row.setModifiedby(principal.getName());
            row.setHolidayName(data.getHolidayName());
            row.setIsActive(Boolean.valueOf(true));
            if ("hangup".equalsIgnoreCase(data.getServingApp())) {
                row.setServingApp("hangup");
                row.setServingData("");
            } else {
                row.setServingApp(data.getServingApp());
                row.setServingData(data.getServingData());
            }
            row.setFromTime(data.getFromTime());
            row.setToTime(data.getToTime());
            this.nonHolidayRepository.save((Object)row);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Yearly Non Holiday Created Successfully");
            return returnValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error occurred: " + e.getMessage());
            return returnValue;
        }
    }

    public ResponseEntity<byte[]> getPdfFile(String path) {
        try {
            Optional pathLocation = this.pdfReportRepository.findByPdfLocation(path);
            if (!pathLocation.isPresent() || !"success".equals(((PdfReportFilters)pathLocation.get()).getStatus())) {
                String errorMessage = "Failed to download PDF. Invalid or non-successful path: " + path;
                logger.error(errorMessage);
                return ResponseEntity.status((int)400).build();
            }
            byte[] fileContent = Files.readAllBytes(new File(path).toPath());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_PDF);
            headers.setContentDispositionFormData("attachment", "filename.pdf");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)fileContent);
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResponseEntity.status((int)500).build();
        }
    }

    public RequestResponse deleteAllList(DeleteListModel request) {
        RequestResponse response = new RequestResponse();
        List allQueues = (List)this.nonHolidayRepository.findAll();
        List dayValue = this.nonHolidayRepository.findAllWithDayFilled();
        List dateValue = this.nonHolidayRepository.findAllWithDateFilled();
        if (dayValue != null && !dayValue.isEmpty() && request.getIsWeekly().booleanValue() && !request.getIsYearly().booleanValue()) {
            this.nonHolidayRepository.deleteAll((Iterable)dayValue);
            logger.info("Deleted {} weekly records (with non-null day)", (Object)dayValue.size());
        }
        if (dateValue != null && !dateValue.isEmpty() && !request.getIsWeekly().booleanValue() && request.getIsYearly().booleanValue()) {
            this.nonHolidayRepository.deleteAll((Iterable)dateValue);
            logger.info("Deleted {} yearly records (with non-null date)", (Object)dateValue.size());
        }
        if (dateValue != null && !dateValue.isEmpty() && dayValue != null && !dayValue.isEmpty() && request.getIsWeekly().booleanValue() && request.getIsYearly().booleanValue()) {
            this.nonHolidayRepository.deleteAll((Iterable)dateValue);
            this.nonHolidayRepository.deleteAll((Iterable)dayValue);
            logger.info("Deleted {} yearly records (with non-null date)", (Object)dateValue.size());
            logger.info("Deleted {} weekly records (with non-null day)", (Object)dayValue.size());
        }
        if (!request.getIsWeekly().booleanValue() && !request.getIsYearly().booleanValue() || dayValue.isEmpty() && dateValue.isEmpty()) {
            response.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            response.setMessage("No records found to delete based on the provided criteria.");
            logger.info(response.getMessage());
            return response;
        }
        response.setMessageDetail("All Non Working Holiday deletion process completed.");
        logger.info(response.getMessage());
        return response;
    }

    public RequestResponse getActiveToggle(ToggleModel request) {
        RequestResponse returnValue = new RequestResponse();
        Optional extGroupOptional = this.nonHolidayRepository.findById((Object)request.getId());
        if (!extGroupOptional.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("Non-Holiday record not found");
            logger.error(returnValue.getMessage());
            return returnValue;
        }
        ((NonWorkingHoliday)extGroupOptional.get()).setIsActive(request.getIsActive());
        this.nonHolidayRepository.save(extGroupOptional.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Non-Working Holiday Toggle updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

